/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device;
import org.lsst.ccs.subsystem.teststand.data.TSDeviceStatus;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;

public class BOTBench
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Map<String, ThorlabsFWDevice> filterWheelMap = new HashMap<String, ThorlabsFWDevice>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    ThorlabsSC10Device shutterDev;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;

    public void postInit() {
        this.subsys.setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, BOTBench.class.getCanonicalName());
    }

    @Command(type=Command.CommandType.QUERY, name="listFilterWheels", description="list filter wheels and connection status")
    public List<TSDeviceStatus> listFilterWheels() {
        ArrayList<TSDeviceStatus> listfw = new ArrayList<TSDeviceStatus>();
        Set<String> fwNames = this.filterWheelMap.keySet();
        for (String fwName : fwNames) {
            boolean fwOnline = this.filterWheelMap.get(fwName).isOnline();
            listfw.add(new TSDeviceStatus(fwName, fwOnline));
        }
        return listfw;
    }
}

