package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.drivers.gpio.GPIODriver;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.subsystem.teststand.data.TSDeviceStatus;

/**
 ******************************************************************************
 **
 ** Implements the BOT illumination-control subsystem
 *
 * @author  Al Eisner
 *
 * *****************************************************************************
 */
public class BOTBench implements HasLifecycle {

    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    Map<String, ThorlabsFWDevice> filterWheelMap = new HashMap<>();
    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    ThorlabsSC10Device shutterDev;

    @LookupField(strategy = LookupField.Strategy.TOP)
    Subsystem subsys;

    @LookupName
    private String name;

    /**
     * Post-initialization
     */
    @Override
    public void postInit() {

        /** 
         * By setting TESTSTAND_TYPE_AGENT_PROPERTY we signal to consoles 
         * that this subsystem is compatible with the teststand subsystm GUI
         */
        subsys.setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, BOTBench.class.getCanonicalName());

    }

    /**
     *  Return list of filter wheels and their connection status
     *
     *  @return  List<TSDeviceStatus>
     */
    @Command(type=Command.CommandType.QUERY, name="listFilterWheels",
             description="list filter wheels and connection status")
    public List<TSDeviceStatus> listFilterWheels() {
        List<TSDeviceStatus> listfw = new ArrayList<>();
        Set<String> fwNames = filterWheelMap.keySet();
        for (String fwName : fwNames) {
            boolean fwOnline = filterWheelMap.get(fwName).isOnline();
            listfw.add(new TSDeviceStatus(fwName, fwOnline));
        }
	return listfw;
    }

}
