import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.BOTBench;
import org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["bot-bench"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

Class thorlabsFWClass = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice");
Class thorlabsSC10Class = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device");

builder.
    main (BOTBench) {


    SpotProjFWheel (thorlabsFWClass, devcId:"",
        fwsize:6, speedMode:true, sensorMode:false,
        filterNames:["Mask_grid","Mask_spot","empty3","empty4","empty5","empty6"])
    {
        SpotProjFWheelPos (Channel, 
                           description:"Spot projector filter wheel position",
                           devcName:"SpotProjFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    NeutralFWheel (thorlabsFWClass, devcId:"",
        fwsize:12, speedMode:true, sensorMode:false,
        filterNames:["empty", "ND_OD0.1", "ND_OD0.2", "ND_OD0.3", "ND_OD0.4", 
                     "ND_OD0.5", "ND_OD0.6", "ND_OD1.0", "ND_OD1.3", 
                     "ND_OD2.0", "ND_OD3.0", "ND_OD4.0" ])
    {
        NeutralFWheelPos (Channel, 
                           description:"Neutral density filter wheel position",
                           devcName:"NeutralFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    ColorFWheel (thorlabsFWClass, devcId:"",
        fwsize:12, speedMode:true, sensorMode:false,
        filterNames:["480nm", "650nm", "750nm", "870nm", "950nm", "SDSS_u", 
                     "SDSS_g", "SDSS_r", "SDSS_i", "SDSS_z", "SDSS_Y", "empty"])
    {
        ColorFWheelPos (Channel, 
                           description:"Color filter wheel position",
                           devcName:"ColorFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    ProjectorShutter (thorlabsSC10Class, devcId:"",
       //devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Cable_FT1RAJQE-if01-port0", 
       outputMode:false)
    {
    }

//    AlarmHDWPD (Alarm, eventParm:TSConfig.EVENT_ID.PD.ordinal())


}
