/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services.alert;

import java.util.List;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;

public class AgentAlertStateAlertListener
implements AlertListener {
    private final Agent agent;
    private final AgentStateService stateService;

    public AgentAlertStateAlertListener(Agent agent, AgentStateService stateService) {
        this.agent = agent;
        this.stateService = stateService;
    }

    @Override
    public void onAlert(AlertEvent event) {
        if (event.getSource().equals(this.agent.getName())) {
            if (event.getType() == AlertEvent.AlertEventType.ALERT_RAISED) {
                RaisedAlertSummary summary = event.getSummary();
                AlertState globalSeverity = summary.getAlertState();
                if (globalSeverity == AlertState.ALARM && !this.stateService.isInState((Enum)AlertState.ALARM)) {
                    this.stateService.updateInternalState(new AgentState[]{AlertState.ALARM, OperationalState.ENGINEERING_FAULT});
                } else if (globalSeverity == AlertState.WARNING && this.stateService.getState(AlertState.class).compareTo(AlertState.WARNING) < 0) {
                    this.stateService.updateInternalState(new AgentState[]{AlertState.WARNING});
                }
                Alert alert = event.getAlert();
                RaisedAlertHistory raisedAlert = summary.getRaisedAlert(alert.getAlertId());
                StatusRaisedAlert statusAlert = new StatusRaisedAlert(alert, raisedAlert.getLatestAlertCause(), this.stateService.getState(), new RaisedAlertSummary(summary));
                this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)statusAlert);
            } else if (event.getType() == AlertEvent.AlertEventType.ALERT_CLEARED) {
                RaisedAlertSummary summary = event.getSummary();
                AlertState globalSeverity = summary.getAlertState();
                if (globalSeverity == AlertState.WARNING && this.stateService.isInState((Enum)AlertState.ALARM)) {
                    this.stateService.updateInternalState(new AgentState[]{AlertState.WARNING, OperationalState.ENGINEERING_OK});
                } else if (globalSeverity == AlertState.NOMINAL && !this.stateService.isInState((Enum)AlertState.NOMINAL)) {
                    this.stateService.updateInternalState(new AgentState[]{AlertState.NOMINAL, OperationalState.ENGINEERING_OK});
                }
                List<String> clearedIds = event.getClearedIds();
                StatusClearedAlert clearedStatus = new StatusClearedAlert(clearedIds.toArray(new String[clearedIds.size()]), this.stateService.getState(), new RaisedAlertSummary(summary));
                this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)clearedStatus);
            }
        }
    }
}

