/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.GP835;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.VQMDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class GPVacMon835Device
extends Device
implements VQMDevice {
    String serialdev;
    private final GP835 vqmDev = new GP835();
    TSConfig cfg = new TSConfig();
    private final double[] runVac = new double[TSConfig.MAXSTATES];
    TSState.vacstates vstate = TSState.vacstates.NOTCONFIGURED;
    double lastPres = 0.0;
    long last_disconnect = 0L;

    public void initDevice() {
        if (this.serialdev == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"serialdev", (String)"not specified");
        }
        this.fullName = "GP835 VQM device";
    }

    protected void initialize() {
        block2: {
            try {
                this.vqmDev.open(this.serialdev);
                this.setOnline(true);
                this.initSensors();
                this.vstate = TSState.vacstates.OK;
                this.log.info((Object)("Connected to " + this.fullName));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.vqmDev.close();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan != 0) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        double value = super.readChannel(chan, type);
        try {
            value = this.readPressure();
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading VQM pressure: " + e));
            this.setOnline(false);
        }
        return value;
    }

    @Override
    @Command(description="Reconnect to the VQM")
    public void reconnect() {
        this.setOnline(false);
    }

    @Override
    @Command(description="Returns whether the GP835 device is active")
    public boolean isVacuumGaugeOn() throws DriverException {
        try {
            boolean state = this.vqmDev.isGaugeOn();
            if (!this.vstate.equals((Object)TSState.vacstates.TRIPPED)) {
                this.vstate = state ? TSState.vacstates.ON : TSState.vacstates.OFF;
            }
            return state;
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading vacuum gauge state: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Override
    @Command(description="Turn on power to the vacuum gauge")
    public void setGaugeOn() throws DriverException {
        try {
            this.vqmDev.setGaugeOn();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error setting VQM gauge on: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Override
    @Command(description="Turn off power to the vacuum gauge")
    public void setGaugeOff() throws DriverException {
        try {
            this.vqmDev.setGaugeOff();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error setting VQM gauge off: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Command(description="Returns whether the filament is on")
    public boolean isFilamenteOn() throws DriverException {
        try {
            return this.vqmDev.isFilamentOn();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading vacuum gauge filament state: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Command(description="Turn on the vacuum gauge filament")
    public void setFilamentOn() throws DriverException {
        try {
            this.vqmDev.setFilamentOn();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error setting VQM gauge filament on: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Command(description="Turn off the vacuum gauge filament")
    public void setFilamentOff() throws DriverException {
        try {
            this.vqmDev.setFilamentOff();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error setting VQM gauge filament off: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="returns the pressure read from the GP835 device")
    public double readPressure() throws DriverException {
        try {
            this.lastPres = this.vqmDev.getPressure();
            return this.lastPres;
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading VQM pressure: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Command(description="Enable a trip relay")
    public void enableRelay(@Argument(description="Relay number") int relay, @Argument(description="High pressure limit") double limit) throws DriverException {
        this.vqmDev.setRelayTrip(relay, 1, limit);
        this.vqmDev.setRelayTrip(relay, 0, 0.94 * limit);
        this.vqmDev.assignRelay(relay, 0);
        this.vqmDev.enableRelay(relay, true);
    }

    @Command(description="Disable a trip relay")
    public void disableRelay(@Argument(description="Relay number") int relay) throws DriverException {
        this.vqmDev.enableRelay(relay, false);
    }

    @Command(type=Command.CommandType.QUERY, description="Get a trip relay limit value")
    public double getRelayLimit(@Argument(description="Relay number") int relay) throws DriverException {
        return this.vqmDev.getRelayTrip(relay, 1);
    }

    @Command(type=Command.CommandType.QUERY, description="Get a trip relay enabled state")
    public boolean isRelayEnabled(@Argument(description="Relay number") int relay) throws DriverException {
        return this.vqmDev.isRelayEnabled(relay);
    }

    @Command(type=Command.CommandType.QUERY, description="Get a trip relay active state")
    public boolean isRelayActive(@Argument(description="Relay number") int relay) throws DriverException {
        return this.vqmDev.isRelayActive(relay);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Returns the ident read from the GP835 device")
    public String getIdent() throws DriverException {
        try {
            String[] ident = this.vqmDev.getIdentification();
            return ident[0] + "," + ident[1] + "," + ident[2] + "," + ident[3];
        }
        catch (DriverException e) {
            this.log.error((Object)("Error getting VQM device identification: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Returns the test report from the GP835 device")
    public String readReport() throws DriverException {
        try {
            return this.vqmDev.getTestReport();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error getting VQM test report : " + (Object)((Object)e)));
            throw e;
        }
    }

    @Override
    public double getLastPres() {
        return this.lastPres;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="read the buffer")
    public double[][] readAMU() throws DriverException {
        try {
            return this.vqmDev.readAMU();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading AMU report: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Command(type=Command.CommandType.QUERY, description="read the buffer and dump to file")
    public double[][] readAMU(@Argument(name="filename", description="output filename for the VQM buffered values") String filename) throws DriverException {
        double[][] buff = this.readAMU();
        FileWriter fstream = null;
        File pdFl = new File(filename);
        try {
            if (pdFl.exists()) {
                pdFl.delete();
            }
            pdFl.createNewFile();
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to create file (" + filename + ") for reason " + e));
        }
        try {
            fstream = new FileWriter(pdFl);
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
        }
        try {
            if (fstream != null) {
                this.log.error((Object)"writing file of buffered values from either Bias or PhotoDiode device");
                BufferedWriter out = new BufferedWriter(fstream);
                String line = null;
                for (int i = 0; i < buff[0].length; ++i) {
                    line = buff[1][i] + " " + buff[0][i];
                    try {
                        out.write(line);
                        out.newLine();
                        out.flush();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Failed to close file!");
                }
            }
        }
        catch (Exception ee) {
            this.log.error((Object)"Failed to remove and create a new file.!");
        }
        return buff;
    }

    @Command(description="Read the buffer and returns as a string")
    public String readAMUStr() throws DriverException {
        double[][] data = this.vqmDev.readAMU();
        return "Count = " + GPVacMon835Device.getString(data[0]) + "\n AMUs = " + GPVacMon835Device.getString(data[1]) + "\n";
    }

    @Override
    @Command(description="Sets the vac value for acquisition")
    public void setRunVac(double runVac, int cfgstate) {
        this.runVac[cfgstate] = runVac;
    }

    @Override
    @Command(description="Returns the vac value for acquisition")
    public double getRunVac(int cfgstate) {
        return this.runVac[cfgstate];
    }

    @Override
    @Command(description="Set vacuum device status")
    public void setState(@Argument(description="State to set") int istate) {
        this.vstate = TSState.vacstates.values()[istate];
    }

    @Override
    @Command(description="Set vacuum device status")
    public int getState() {
        return this.vstate.ordinal();
    }

    private static StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }
}

