package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 ******************************************************************************
 **
 ** Defines a cryogenic device interface.
 *
 * @author Homer Neal *
 * *****************************************************************************
 */
public interface CryoDevice {

    void open(int type, String ident, int param) throws DriverException;

    void close() throws DriverException;

    double get_init_temp(int cfgstate);

    double getMaxSetPoint(int loop) throws DriverException;

    void setMaxSetPoint(int loop, double temp) throws DriverException;

    double getSetPoint(int loop) throws DriverException;

    void setSetPoint(int loop, double temp) throws DriverException;

    char getLoopSource(int loop) throws DriverException;

    void setLoopSource(int loop, String channel) throws DriverException;

    void setHeaterRange(int loop, String range) throws DriverException;

    double getTemp(String channel) throws DriverException;

    double getTempStdDev();

    double getTempChange();

    char getUnit(String channel) throws DriverException;

    void setUnit(String channel, String unit) throws DriverException;

    void setType(String channel, String calcur_type) throws DriverException;

    int rampTemp(double duration, double value, int nsteps) throws DriverException;

    int rampTemp(double duration,
            double t_target,
            int nsteps,
            int iwloop,
            int ioloop,
            String wchan,
            String ochan,
            double delta_warm) throws DriverException;

    void setRunTemp(double Temp, int cfgstate);

    double getRunTemp(int cfgstate);

    int getState();

    void setState(int istate);

    void setCurrent_channel(String chan);
    void setCurrent_channel2(String chan);

    String getCurrent_channel();
    String getCurrent_channel2();

    void setCurrent_loop(int loop);

    int getCurrent_loop();

    void setToControl() throws DriverException;

    boolean isInControl() throws DriverException;

    double getHtrRead(int loop) throws DriverException;

    double getPID_P(int loop) throws DriverException;

    double getPID_I(int loop) throws DriverException;

    double getPID_D(int loop) throws DriverException;
}
