/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.teststand.CryoCon24cDevice;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

public class CryoCon24cSimDevice
extends CryoCon24cDevice
implements CryoDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    TSConfig cfg = new TSConfig();
    private double[] RUN_TEMP = new double[TSConfig.MAXSTATES];
    private double IDLE_TEMP = 20.0;
    private double simsettmp = 0.0;
    private double[] simData = new double[18];
    private String host;

    public CryoCon24cSimDevice() {
    }

    public CryoCon24cSimDevice(int itype, String host, int port) throws DriverException {
        System.out.println("CryoCon *** sim *** device ready. itype=" + itype + " host=" + host + " port=" + port);
    }

    @Override
    protected void initDevice() {
    }

    @Override
    @Command(name="open", description="Open connection to Model 24C")
    public void open(@Argument(name="type", description="Communications type") int type, @Argument(name="identity", description="Device identifier") String ident, @Argument(name="parameter", description="Device parameter") int param) throws DriverException {
    }

    @Command(name="openDefault", description="Open connection to Default Model 24C")
    public void openDefault() throws DriverException {
    }

    @Override
    @Command(name="showident", description="Show Temp Control 24C identification")
    public String showIdentification() throws DriverException {
        String[] ident = new String[]{"CryoSim", "V1", "V2"};
        return "Manufacturer:    " + ident[0] + "\nModel name:      " + ident[1] + "\nDCI F/W version: " + ident[2] + "\nAI F/W version:  " + ident[3];
    }

    @Override
    @Command(name="getSetPoint", description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.simsettmp;
    }

    @Override
    @Command(name="setSetPoint", description="setSetPoint for loop")
    public void setSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.simsettmp = temp;
    }

    @Override
    @Command(name="getLoopSource", description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return 'a';
    }

    @Override
    @Command(name="setLoopSource", description="Set source channel for loop")
    public void setLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
    }

    @Override
    @Command(name="getTemp", description="Retrieve temperature info")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        char ch = channel.charAt(0);
        return this.simsettmp + Math.random() * 3.0;
    }

    @Override
    @Command(name="getUnit", description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return 'A';
    }

    @Override
    protected void initialize() {
        this.setOnline(true);
    }

    @Override
    protected double readChannel(int chan, int type) {
        return this.simData[chan];
    }

    @Command(name="setSimTemp", description="Set Simulated Data value")
    public void setSimData(@Argument(name="index", description="data index") int indx, @Argument(name="value", description="Simulated value") double val) {
        this.simData[indx] = val;
    }

    static {
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("PA", -1);
    }
}

