/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.List;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystem.teststand.limits.AlgorithmFactory;
import org.lsst.ccs.subsystem.teststand.limits.ChannelLimits;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.Limits;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;

public class VacuumConfiguration {
    @ConfigurationParameter(category="vacuum")
    double pressureSetPoint;
    @ConfigurationParameter(category="vacuum")
    List<Double> pressureSetPointLimits;
    @ConfigurationParameter(category="vacuum")
    String pressureMonitoringLimitAlgorithm;
    @ConfigurationParameter(category="vacuum")
    List<Double> pressureMonitoringLimitAlgorithmParameters;
    @ConfigurationParameter(category="vacuum")
    String pressureMonitoringTransitionAlgorithm;
    @ConfigurationParameter(category="vacuum")
    List<Double> pressureMonitoringTransitionAlgorithmParameters;

    LimitAlgorithm createVacuumLimitsAlgorithm(double nominalInitialValue, Limits initialLimits) {
        LimitAlgorithm la = AlgorithmFactory.createLimitAlgorithm(this.pressureMonitoringLimitAlgorithm);
        Limits setPointLimits = new Limits(this.pressureSetPointLimits);
        la.init(this.pressureMonitoringLimitAlgorithmParameters, nominalInitialValue, initialLimits, this.pressureSetPoint, setPointLimits);
        return la;
    }

    TransitionAlgorithm createVacuumTransitionAlgorithm(LimitAlgorithm limitsAlgorithm, double initialPressure, ChannelLimits limits, long startTime) {
        if (this.pressureMonitoringTransitionAlgorithm != null && !this.pressureMonitoringTransitionAlgorithm.isEmpty()) {
            TransitionAlgorithm ta = AlgorithmFactory.createTransitionAlgorithm(this.pressureMonitoringTransitionAlgorithm);
            ta.init(this.pressureMonitoringTransitionAlgorithmParameters, limitsAlgorithm, initialPressure, limits, startTime);
            return ta;
        }
        return null;
    }

    public String toString() {
        return "VacuumConfiguration{pressureSetPoint=" + this.pressureSetPoint + ", pressureMonitoringLimitAlgorithm=" + this.pressureMonitoringLimitAlgorithm + ", pressureMonitoringLimitAlgorithmParameters=" + this.pressureMonitoringLimitAlgorithmParameters + ", pressureMonitoringTransitionAlgorithm=" + this.pressureMonitoringTransitionAlgorithm + ", pressureMonitoringTransitionAlgorithmParameters=" + this.pressureMonitoringTransitionAlgorithmParameters + '}';
    }
}

