/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.apcpdu.APC7900;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class APC7900Device
extends Device {
    public static final int TYPE_OUTLET = 0;
    public static final int TYPE_POWER = 1;
    public static final int CHAN_CURRENT = 0;
    public static final int CHAN_POWER = 1;
    static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    String node;
    String user = "apc";
    String passwd = "apc";
    final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private final APC7900 pdu = new APC7900();
    final List<String> outlets = new ArrayList<String>();
    int[] outNums;
    Map<String, Integer> outNumMap = new HashMap<String, Integer>();
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"node", (String)"is not specified");
        }
        this.fullName = "APC7900 PDU (" + this.node + ")";
    }

    protected void initialize() {
        try {
            this.pdu.open(Session.ConnType.TELNET, this.node, this.user, this.passwd);
            this.outNumMap = this.pdu.getOutletNumberMap();
            this.outNums = new int[this.outlets.size()];
            this.initSensors();
            this.setOnline(true);
            this.kstate = TSState.pwrstates.OK;
            this.sLog.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.sLog.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.pdu.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        this.outNumMap.clear();
        this.kstate = TSState.pwrstates.NOTCONFIGURED;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        int index = 0;
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"channel type", (Object)type);
        }
        if (iType == 0) {
            index = this.outlets.size();
            this.outlets.add(subtype);
        } else if (hwChan != 0 && hwChan != 1) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{iType | index << 16, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            if ((type & 0xFFFF) == 0) {
                int index = type >> 16;
                String outlet = this.outlets.get(index);
                Integer outNum = this.outNumMap.get(outlet);
                if (outNum == null) {
                    MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"outlet name", (Object)outlet);
                }
                this.outNums[index] = outNum;
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = 0.0;
        switch (type & 0xFFFF) {
            case 0: {
                int outNum = this.outNums[type >> 16];
                try {
                    value = this.pdu.isOutletOn(outNum) ? 1.0 : 0.0;
                }
                catch (DriverException e) {
                    this.sLog.error((Object)("Error getting outlet state: " + (Object)((Object)e)));
                    this.setOnline(false);
                }
                break;
            }
            case 1: {
                try {
                    value = hwChan == 1 ? this.pdu.readPower() : this.pdu.readCurrent()[0];
                    break;
                }
                catch (DriverException e) {
                    this.sLog.error((Object)("Error reading power/current value: " + (Object)((Object)e)));
                    this.setOnline(false);
                }
            }
        }
        return value;
    }

    @Command(name="disable", description="Disable the connection to the PDU")
    public void disable() {
        super.disable();
        this.setOnline(false);
    }

    @Command(name="enable", description="Enable the connection to the PDU")
    public void enable() {
        super.enable();
    }

    @Command(name="getOutletNames", description="Get the list of outlet names")
    public List<String> getOutletNames() {
        return new ArrayList<String>(this.outNumMap.keySet());
    }

    @Command(name="getOutletOnStateMap", description="Get the map of outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        return this.pdu.getOutletOnStateMap();
    }

    @Command(name="outletOn", description="Turn outlet on")
    public void outletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.delayedOutletOn(this.getOutletNumber(name));
    }

    @Command(name="outletOff", description="Turn outlet off")
    public void outletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.delayedOutletOff(this.getOutletNumber(name));
    }

    @Command(name="forceOutletOn", description="Force outlet to turn on")
    public void forceOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.setOutletOn(this.getOutletNumber(name));
    }

    @Command(name="forceOutletOff", description="Force outlet to turn off")
    public void forceOutletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.setOutletOff(this.getOutletNumber(name));
    }

    @Command(name="isOutletOn", description="Get whether outlet is on")
    public boolean isOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        return this.pdu.isOutletOn(this.getOutletNumber(name));
    }

    int getOutletNumber(String name) throws DriverException {
        Integer outNum = this.outNumMap.get(name);
        if (outNum == null) {
            throw new DriverException("Invalid outlet name");
        }
        return outNum;
    }

    static {
        typeMap.put("OUTLET", 0);
        typeMap.put("POWER", 1);
    }
}

