/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.xed.XED;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.Fe55Device;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class XEDDevice
extends Device
implements Fe55Device {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private XED exretrct = null;
    private boolean isconnected = false;
    private int extend_retract = -1;
    TSConfig cfg = new TSConfig();
    private String outname = "";
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;
    boolean failedToInitialize = false;

    public XEDDevice(String host, int port) throws DriverException {
        this.isconnected = true;
        try {
            this.exretrct = new XED();
            if (this.exretrct != null) {
                this.exretrct.openftdi(host, port);
            }
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to XED device!");
            this.isconnected = false;
        }
    }

    public XEDDevice() {
        this.exretrct = new XED();
    }

    protected void initDevice() {
        this.fullName = "XED module";
    }

    protected void close() {
        try {
            if (this.exretrct != null) {
                this.exretrct.close();
            }
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"XED device failed to close!!!");
        }
    }

    protected void initialize() {
        if (this.isconnected) {
            this.log.debug((Object)"XED device is already initialized and prompt returns:");
            try {
                this.log.debug((Object)this.exretrct.getIdent());
            }
            catch (Exception e) {
                if (!this.failedToInitialize) {
                    this.log.error((Object)"XED device failed to respond to ident request! The initialization has FAILED.");
                    this.failedToInitialize = true;
                }
                this.isconnected = false;
            }
            this.log.debug((Object)"Setting device online.");
            this.setOnline(true);
            this.kstate = TSState.pwrstates.OK;
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected LED device!");
            this.failedToInitialize = true;
        }
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="Serial device name") String host, @Argument(name="baud", description="baud rate") int port) throws DriverException {
        this.exretrct.openftdi(host, port);
        this.kstate = TSState.pwrstates.OK;
        return this.exretrct.getIdent();
    }

    @Override
    @Command(name="extendFe55", description="extend the arm")
    public void extendFe55() {
        try {
            if (this.exretrct != null && this.isconnected) {
                this.exretrct.extendFe55();
                this.extend_retract = 1;
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the XED");
        }
    }

    @Override
    @Command(name="retractFe55", description="retract the arm")
    public void retractFe55() {
        try {
            if (this.exretrct != null && this.isconnected) {
                this.exretrct.retractFe55();
                this.extend_retract = 0;
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the XED");
        }
    }

    @Override
    @Command(name="getExtend_retract", description="get the position of the arm")
    public int getExtend_retract() {
        return this.extend_retract;
    }

    public void setExtend_retract(int extend_retract) {
        this.extend_retract = extend_retract;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != 3) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
        try {
            if (type == 3) {
                this.log.debug((Object)("setting channel online - chan=" + chan));
                this.setOnline(true);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    @Command(name="reset", description="reset trips etc...")
    public void reset() throws DriverException {
        if (this.exretrct != null) {
            this.exretrct.reset();
        }
        this.kstate = TSState.pwrstates.OK;
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("XEDDevice readChannel called! chan=" + chan + " type=" + type));
        try {
            if (type == 3) {
                value = this.extend_retract;
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Command(name="setstate", description="set XED device status")
    public void setState(int istate) {
        this.kstate = TSState.pwrstates.values()[istate];
    }

    @Command(name="getstate", description="get XED device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    static {
        typeMap.put("EXTENDRETRACT", 3);
    }
}

