/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.teststand.limits.DeltaLimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.Limits;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;
import org.lsst.ccs.subsystem.teststand.limits.ProportionalLimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.RatchetTransitionAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;

public class RatchetAlgorithmTest {
    private final double[] coldData = new double[]{18.64, 16.43, 13.17, 10.04, 7.34, 5.03, 3.04, 1.27, -0.33, -1.87, -3.43, -5.03, -6.67, -8.33, -10.0, -11.67, -13.35, -15.0, -16.64, -18.28, -19.96, -21.78, -23.87, -26.6, -30.23, -33.48, -36.24, -38.45, -39.88, -40.61, -40.86, -40.84, -40.7, -40.53, -40.29, -40.31, -43.07, -45.81, -47.75, -49.4, -50.67, -51.67, -51.88, -51.48, -50.64, -49.53, -48.22, -46.91, -45.7, -43.96, -43.45, -43.1, -42.88, -42.74};
    private final double[] vacuumData = new double[]{792.7066666666665, 252.2279562130176, 0.03465620074719104, 3.833983651685393E-4, 3.068590393258428E-4, 2.6499379775280933E-4, 2.3889838764044966E-4, 2.1999419662921315E-4, 2.0502173033707852E-4, 1.93145595505618E-4, 1.83645825842697E-4, 1.7616797752809015E-4, 1.6905038202247162E-4, 1.6279714044943825E-4, 1.5727462359550564E-4, 1.5242048314606716E-4, 1.4781973595505635E-4, 1.4368495505618026E-4, 1.400161348314607E-4, 1.3650534269662944E-4, 1.3405551685393287E-4, 1.311510955056173E-4, 1.284428202247189E-4, 1.2590947191011236E-4, 1.2338185393258474E-4, 1.2106707303370735E-4, 1.18949438202247E-4, 1.1686478651685414E-4, 1.1484778089887607E-4, 1.1299380337078699E-4, 1.112415730337078E-4, 1.0944888764044922E-4, 1.0772462359550543E-4, 1.0610096067415765E-4, 1.0452147191011249E-4, 1.0320124719101091E-4, 1.0153832584269655E-4, 1.0086990280898863E-4, 9.954885674157298E-5, 9.823648033707865E-5, 9.703196235955081E-5, 9.57797168539325E-5, 9.459770449438189E-5, 9.347355449438185E-5, 9.230549166666652E-5, 9.122580617977547E-5, 9.016682808988761E-5, 8.913025617977512E-5, 8.808643089887645E-5, 8.714606404494397E-5, 8.615783539325865E-5, 8.527413202247188E-5, 8.436513146067401E-5, 8.346232752808989E-5, 8.257411011235951E-5, 8.17381393258425E-5, 8.087465449438215E-5, 8.005503764044974E-5, 7.924042359550547E-5, 7.84398646067413E-5};

    @Test
    public void testColdRatchetAlgorithm() {
        ArrayList<Double> initialLimitValues = new ArrayList<Double>();
        initialLimitValues.add(9.0);
        initialLimitValues.add(14.0);
        initialLimitValues.add(29.0);
        initialLimitValues.add(34.0);
        double initial = 19.0;
        ArrayList<Double> targetLimitValues = new ArrayList<Double>();
        targetLimitValues.add(-50.0);
        targetLimitValues.add(-45.0);
        targetLimitValues.add(-30.0);
        targetLimitValues.add(-25.0);
        double target = -40.0;
        DeltaLimitAlgorithm limits = new DeltaLimitAlgorithm();
        TestLimits testLimits = new TestLimits(initialLimitValues);
        Limits targetLimits = new Limits(targetLimitValues);
        limits.init(Collections.emptyList(), initial, (LimitsInterface)testLimits, target, (LimitsInterface)targetLimits);
        RatchetTransitionAlgorithm ratchet = new RatchetTransitionAlgorithm();
        ratchet.init(Collections.emptyList(), (LimitAlgorithm)limits, initial, (LimitsInterface)testLimits, 0L);
        try {
            this.testTransition((TransitionAlgorithm)ratchet, testLimits, this.coldData);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testVacuumRatchetAlgorithm() {
        Double[] parameters = new Double[]{0.05, 0.1, 10.0, 20.0};
        ArrayList<Double> targetLimitValues = new ArrayList<Double>();
        targetLimitValues.add(1.0E-7);
        targetLimitValues.add(2.0E-7);
        targetLimitValues.add(4.0E-5);
        targetLimitValues.add(8.0E-5);
        double target = 4.0E-6;
        ArrayList<Double> initialLimitValues = new ArrayList<Double>();
        initialLimitValues.add(780.0);
        initialLimitValues.add(785.0);
        initialLimitValues.add(800.0);
        initialLimitValues.add(810.0);
        double initial = 793.0;
        ProportionalLimitAlgorithm limits = new ProportionalLimitAlgorithm();
        TestLimits testLimits = new TestLimits(initialLimitValues);
        Limits targetLimits = new Limits(targetLimitValues);
        limits.init(Arrays.asList(parameters), initial, (LimitsInterface)testLimits, target, (LimitsInterface)targetLimits);
        RatchetTransitionAlgorithm ratchet = new RatchetTransitionAlgorithm();
        ratchet.init(Collections.emptyList(), (LimitAlgorithm)limits, initial, (LimitsInterface)testLimits, 0L);
        this.testTransition((TransitionAlgorithm)ratchet, testLimits, this.vacuumData);
    }

    private void testTransition(TransitionAlgorithm ta, TestLimits testLimits, double[] data) {
        boolean atTarget = false;
        for (double d : data) {
            if (!(atTarget |= ta.isAtTarget(d, 0L))) {
                ta.adjustLimits(d, 0L);
            } else {
                ta.completeTransition(0L);
            }
            testLimits.test(d);
        }
    }

    private static class TestLimits
    extends Limits {
        TestLimits(List<Double> values) {
            super(values);
        }

        private void test(double d) {
            if (d < this.getWarnLow() || d > this.getWarnHigh()) {
                throw new RuntimeException(String.format("Limits violation: [%g,%g] %g", this.getWarnLow(), this.getWarnHigh(), d));
            }
        }
    }
}

