/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.ref.plotter.AbstractStyleParameter;
import java.awt.Color;
import org.freehep.swing.ColorConverter;

public class ColorStyleParameter
extends AbstractStyleParameter {
    ColorStyleParameter(String name) {
        super(name, null);
    }

    ColorStyleParameter(String name, String defaultColor) {
        super(name, defaultColor);
    }

    public Color color() {
        String value = this.parameterValue();
        if (value == null) {
            return null;
        }
        try {
            Color color = ColorConverter.get((String)value);
            return color;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem converting string " + value + " to a Color");
        }
    }

    public String stringValue() {
        return this.parameterValue();
    }

    public boolean setColor(Color color) {
        return this.setParameter(ColorConverter.get((Color)color));
    }

    public boolean setStringValue(String color) {
        return this.setParameter(color);
    }

    @Override
    protected boolean setParameter(String parValue) {
        boolean result = super.setParameter(parValue);
        try {
            Color c = ColorConverter.get((String)parValue);
            return result;
        }
        catch (Exception cce) {
            return false;
        }
    }

    @Override
    public Class type() {
        return Color.class;
    }
}

