#
# testacq.py : acquire an image from flat exposure
#
#     author: homer
#

#import CCS Scripting Implementation
from org.lsst.ccs.scripting import *
#import the definition for a Java Exception
from java.lang import Exception
 
#This line is not really needed as the default is to throw exceptions
CCS.setThrowExceptions(True);
  
#attach CCS subsystem Devices for scripting
tssub  = CCS.attachSubsystem("ts");
biassub = CCS.attachSubsystem("ts/Bias");
cryosub = CCS.attachSubsystem("ts/Cryo");
vacsub  = CCS.attachSubsystem("ts/Vacuum");
lampsub = CCS.attachSubsystem("ts/Lamp");
#arcsub  = CCS.attachSubsystem("archon");


#check state of ArchonController
#print "Retrieving Archon Controller state";
#try:
#    result = arcsub.synchCommand(10,"ready");
#except ScriptingTimeoutException, timeout:
#    print 'Timeout Exception', timeout
#except Exception, execution:
#    print 'Execution Exception', execution
#else:
#    arcstate = result.getResult();
#    print "Execution Successful",arcstate;
#    if (arcstate) {
#        print "ts devices ready for acquisition";
#    } else {
#        print "Please check Archon monitoring. Aborting acquisition!";
#        exit(0);
#    }

#check state of ts devices
print "Retrieving ts state";
try:
    result = tssub.synchCommand(10,"istsready");
except ScriptingTimeoutException, timeout:
    print 'Timeout Exception', timeout
except Exception, execution:
    print 'Execution Exception', execution
else:
    tsstate = result.getResult();
    print "Execution Successful",tsstate;
    if (tsstate==1):
        print "ts devices ready for acquisition";
    else:
        print "Please check ts devices monitoring. Aborting acquisition!";
        exit(0);

#check lamp current
print "Getting the lamp current";
try:
    result = lampsub.synchCommand(10,"readlampcurrent");
except ScriptingTimeoutException, timeout:
    print 'Timeout Exception', timeout
except Exception, execution:
    print 'Execution Exception', execution
else:
    lampcurrent = result.getResult();
    print "Execution Successful. Lamp current =",lampcurrent;
# the following will become configuration parameters
    MINCUR = 0.0;
    MAXCUR = 0.002;
    if (lampcurrent>MINCUR and lampcurrent<MAXCUR):
        print "lamp ready";
    else:
        print "lamp not ready .... aborting!";
#        exit(0);

#ramp bias voltage to -70V
#set the source output ON
try:
    result = biassub.synchCommandLine(10,"setoutput 1");
except ScriptingTimeoutException, timeout:
    print 'Timeout Exception', timeout
except Exception, execution:
    print 'Execution Exception', execution
else:
    print "Execution Successful";
#ramp the voltage to operating value
try:
    result = biassub.synchCommand(10,"rampvolts",5.0,-70.);
except ScriptingTimeoutException, timeout:
    print 'Timeout Exception', timeout
except Exception, execution:
    print 'Execution Exception', execution
else:
    print "Execution Successful";

#verify voltage
try:
    result = biassub.synchCommand(10,"readvoltage");
except ScriptingTimeoutException, timeout:
    print 'Timeout Exception', timeout
except Exception, execution:
    print 'Execution Exception', execution
else:
    biasvolts = result.getResult();
    print "voltage read gives V=",biasvolts,"V";

#acquire image
#try:
#    result = arcsub.synchCommand(10,"acquire");
#except ScriptingTimeoutException, timeout:
#    print 'Timeout Exception', timeout
#except Exception, execution:
#    print 'Execution Exception', execution
#else:
#    print "image acquired";
