/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;

@Plugin(name="LSST Message Viewer Plugin", id="tracer21", description="LSST Message Viewer tool.")
public class LsstTracerPlugin
extends ConsolePlugin {
    private final CopyOnWriteArrayList<Tracer> tracers = new CopyOnWriteArrayList();
    private final AgentPresenceListener agentConnectionListener;
    private final StatusMessageListener statusListener = m -> this.onMessage((BusMessage)m);
    private final LogMessageListener logListener = m -> this.onMessage((BusMessage)m);
    private final CommandMessageListener commandListener = m -> this.onMessage((BusMessage)m);

    public LsstTracerPlugin() {
        this.agentConnectionListener = new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (final AgentInfo agent : agents) {
                    AgentInfo.AgentType type = agent.getType();
                    if (AgentInfo.AgentType.CONSOLE.equals((Object)type) || AgentInfo.AgentType.LISTENER.equals((Object)type)) continue;
                    SwingUtilities.invokeLater(() -> {
                        AbstractAction action = new AbstractAction(agent.getName()){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LsstTracerPlugin.this.openDefaultTracer(agent.getName());
                            }
                        };
                        LsstTracerPlugin.this.getServices().addMenu(action, "400: CCS Tools :-1:2", "Message Viewer:100:100", "Subsystems:1");
                        action = new AbstractAction("Message Viewer"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LsstTracerPlugin.this.openDefaultTracer(agent.getName());
                            }
                        };
                        LsstTracerPlugin.this.getServices().addMenu(action, "CCS Subsystems", agent.getName() + ":-10:2");
                    });
                }
            }

            public void disconnected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        Console.getConsole().removeMenu(" CCS Tools ", "Message Viewer", "Subsystems", agent.getName());
                        Console.getConsole().removeMenu("CCS Subsystems", agent.getName(), "Message Viewer");
                    }
                });
            }
        };
    }

    @Override
    public void initialize() {
        AbstractAction act = new AbstractAction("New..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Tracer tracer = new Tracer();
                    tracer.getDescriptor().setName("Messages");
                    tracer = tracer.edit("New Message Viewer", null);
                    LsstTracerPlugin.this.openTracer(tracer);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.getServices().addMenu(act, "400: CCS Tools :-1:2", "Message Viewer:1");
        act = new AbstractAction("Load..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersistenceService service = PersistenceService.getService();
                try {
                    Tracer tracer = (Tracer)service.make(null, "Load message viewer", LsstTracerPlugin.this.getConsole().getWindow(), "Tracer");
                    LsstTracerPlugin.this.openTracer(tracer);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.getServices().addMenu(act, "400: CCS Tools :-1:2", "Message Viewer:2");
        act = new AbstractAction("Default"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstTracerPlugin.this.openDefaultTracer(null);
            }
        };
        this.getServices().addMenu(act, "400: CCS Tools :-1:2", "Message Viewer:3");
    }

    @Override
    public void start() {
        AgentMessagingLayer messagingAccess = this.getConsole().getMessagingAccess();
        messagingAccess.addStatusMessageListener(this.statusListener);
        messagingAccess.addCommandMessageListener(this.commandListener);
        messagingAccess.addLogMessageListener(this.logListener);
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.agentConnectionListener);
    }

    @Override
    public void stop() {
        try {
            this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.agentConnectionListener);
            AgentMessagingLayer messagingAccess = this.getConsole().getMessagingAccess();
            messagingAccess.removeStatusMessageListener(this.statusListener);
            messagingAccess.removeCommandMessageListener(this.commandListener);
            messagingAccess.removeLogMessageListener(this.logListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openTracer(Tracer.Descriptor desc) {
        Tracer tracer = (Tracer)PersistenceService.getService().make(desc);
        this.openTracer(tracer);
    }

    public void openTracer(Tracer tracer) {
        HashMap<String, Serializable> data;
        DataPanelDescriptor panDesc;
        if (tracer == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.openTracer(tracer));
            return;
        }
        JComponent panel = tracer.getPanel();
        if (panel == null) {
            return;
        }
        Tracer.Descriptor desc = tracer.getDescriptor();
        HashMap<Object, Object> par = new HashMap<Object, Object>();
        if (desc != null && (panDesc = desc.getPanel()) != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
            par.putAll(data);
        }
        par.put(Panel.TITLE, tracer.getDescriptor().getName());
        Consumer<JComponent> onClose = c -> this.tracers.removeIf(t -> t.getPanel() == c);
        par.put(Panel.ON_CLOSE, onClose);
        Consumer<JComponent> onSaveAs = c -> {
            for (Tracer t : this.tracers) {
                if (c != t.getPanel()) continue;
                PersistenceService service = PersistenceService.getService();
                service.saveAs(t.save(), "Save Message Viewer page", null);
                break;
            }
        };
        par.put(Panel.ON_SAVE_AS, onSaveAs);
        Consumer<JComponent> onEdit = c -> {
            for (Tracer t : this.tracers) {
                if (c != t.getPanel()) continue;
                try {
                    Tracer editedTracer = t.edit("Edit page", null);
                    if (editedTracer == null || editedTracer == t) break;
                    SwingUtilities.invokeLater(() -> {
                        try {
                            this.getConsole().getPanelManager().close((Component)c);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.openTracer(editedTracer);
                    });
                }
                catch (RuntimeException runtimeException) {}
                break;
            }
        };
        par.put(Panel.ON_EDIT, onEdit);
        Console.getConsole().getPanelManager().open((Component)panel, par);
        this.tracers.add(tracer);
    }

    private void openDefaultTracer(String agentName) {
        PersistenceService service = PersistenceService.getService();
        Tracer tracer = (Tracer)service.make("Tracer", "Built-In/Core/Default", agentName, agentName);
        this.openTracer(tracer);
    }

    private void onMessage(BusMessage message) {
        this.tracers.forEach(tracer -> {
            try {
                tracer.onMessage(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        Tracer.Descriptor[] dd;
        if (!(storageBean instanceof Descriptor)) {
            return true;
        }
        Descriptor desc = (Descriptor)storageBean;
        if (!this.tracers.isEmpty()) {
            ArrayList<Tracer> copy = new ArrayList<Tracer>(this.tracers);
            for (Tracer t : copy) {
                JComponent panel = t.getPanel();
                if (panel == null) continue;
                this.getConsole().getPanelManager().close(panel);
            }
            this.tracers.clear();
        }
        if ((dd = desc.getTracers()) != null) {
            for (Tracer.Descriptor d : dd) {
                this.openTracer(d);
            }
        }
        return true;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (!this.tracers.isEmpty()) {
            Tracer.Descriptor[] descriptors = new Tracer.Descriptor[this.tracers.size()];
            for (int i = 0; i < descriptors.length; ++i) {
                descriptors[i] = this.tracers.get(i).save();
            }
            desc.setTracers(descriptors);
        }
        return desc;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private Tracer.Descriptor[] tracers;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public Tracer.Descriptor[] getTracers() {
            return this.tracers;
        }

        public void setTracers(Tracer.Descriptor[] tracers) {
            this.tracers = tracers;
        }
    }
}

