/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DataSource;
import jas.hist.FunctionFactory;
import jas.hist.FunctionFactoryError;
import jas.hist.FunctionParamNodeTraverser;
import jas.hist.FunctionRegistry;
import jas.hist.FunctionStyle1DNodeTraverser;
import jas.hist.InvalidFunctionParameter;
import jas.hist.JASHist;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.JASHistStyle;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Function1DTraverser
extends XMLNodeTraverser {
    private String fitRef;
    private String refName;
    private boolean isVisible = true;
    private static FunctionRegistry theRegistry = FunctionRegistry.instance();
    private JASHist plot;
    private int yAxis;
    private JASHist1DFunctionStyle style;
    private String className;
    private Basic1DFunction function;
    private FunctionParamNodeTraverser fp = new FunctionParamNodeTraverser();
    private FunctionStyle1DNodeTraverser st = new FunctionStyle1DNodeTraverser();

    Function1DTraverser(Node node, JASHist plot) throws XMLNodeTraverser.BadXMLException {
        this.plot = plot;
        this.traverse(node);
    }

    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("functionStyle1d")) {
            this.style = new JASHist1DFunctionStyle();
            this.st.traverse(node, this.style);
        } else if (name.equals("fit")) {
            this.traverse(node);
        } else if (name.equals("functionParam")) {
            if (this.function != null) {
                try {
                    this.fp.traverse(node);
                    String paramName = this.fp.getName();
                    String[] parameterNames = this.function.getParameterNames();
                    for (int i = 0; i < parameterNames.length; ++i) {
                        if (!parameterNames[i].equals(paramName)) continue;
                        this.function.setParameter(i, this.fp.getValue());
                        return;
                    }
                    throw new XMLNodeTraverser.BadXMLException("Unknown parameter " + name + " for function " + this.className);
                }
                catch (InvalidFunctionParameter x) {
                    throw new XMLNodeTraverser.BadXMLException("Invalid value for parameter " + name + " for function " + this.className);
                }
            }
        } else {
            super.handleElement(node, name);
        }
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("axis")) {
            this.yAxis = this.toInt(value.substring(1));
        } else if (name.equals("name")) {
            this.refName = value;
        } else if (name.equals("isVisible")) {
            this.isVisible = this.toBoolean(value);
        } else if (name.equals("ref")) {
            this.fitRef = value;
        } else if (name.equals("type")) {
            this.className = value;
            FunctionFactory ff = theRegistry.find(value);
            if (ff == null) {
                System.err.println("Could not find function " + value + " in function registry -- ignored");
            } else {
                try {
                    this.function = ff.createFunction(this.plot);
                }
                catch (FunctionFactoryError ffe) {
                    throw new XMLNodeTraverser.BadXMLException("Unable to create function " + value);
                }
            }
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    DataSource getDataSource() {
        return this.function;
    }

    int getYAxis() {
        return this.yAxis;
    }

    JASHistStyle getStyle() {
        return this.style;
    }

    boolean isVisible() {
        return this.isVisible;
    }

    String getRefName() {
        return this.refName;
    }

    String getFitRef() {
        return this.fitRef;
    }
}

