/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.subsystem.teststand.ui.jas.TeststandMonitorFilter;

@Plugin(name="TestStand new plugin", description="Displays monitor tables for test stands")
public class TSMonitorPlugin
extends ConsolePlugin {
    private final OptionalPage teststandOptionalPage = new TestStandOptionalPage();

    public void initialize() {
        Console.getConsole().getOptionalPageService().add(this.teststandOptionalPage);
    }

    static class TestStandOptionalPage
    implements OptionalPage {
        TestStandOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY) != null) {
                return "CCS Subsystems/" + agent.getName() + "/Monitoring";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            TeststandMonitorFilter filter = new TeststandMonitorFilter(agent.getName());
            view.setFilter((AgentChannelsFilter)filter);
            view.install();
            view.getPanel().setName(agent.getName() + " Monitoring");
            return view.getPanel();
        }
    }
}

