/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorExport;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPage;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;

@Plugin(name="LSST Monitoring Plugin", id="monitor", description="LSST CCS monitoring data display service.")
public class LsstMonitorPlugin
extends ConsolePlugin {
    private final Studio app = (Studio)Application.getApplication();
    private final Action newView;
    private final ArrayList<MonitorPage> currentViews = new ArrayList(0);
    private final ArrayDeque<MonitorPage.Descriptor> recentViews = new ArrayDeque(0);

    public LsstMonitorPlugin() {
        this.newView = new AbstractAction("Configure..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstMonitorPlugin.this.openManagedPage(null);
            }
        };
    }

    @Override
    public void initialize() {
        this.resetMenu();
        PageManager pm = this.app.getPageManager();
        pm.addPageListener((PageListener)new Saver());
    }

    public void openPage(MonitorView view) {
        JComponent panel = view.getPanel();
        if (panel != null) {
            HashMap<Panel, Object> par = new HashMap<Panel, Object>();
            par.put(Panel.TITLE, view.getName());
            Consumer<JComponent> onClose = c -> view.uninstall();
            par.put(Panel.ON_CLOSE, onClose);
            Console.getConsole().getPanelManager().open((Component)panel, par);
            view.install();
        }
    }

    public void closePage(MonitorView view) {
        PanelManager pm = this.getConsole().getPanelManager();
        JComponent panel = view.getPanel();
        if (panel != null) {
            pm.close(panel);
        }
        view.uninstall();
    }

    private void openManagedPage(MonitorPage.Descriptor desc) {
        JComponent panel;
        MonitorPage monPage = desc == null ? new MonitorPage().edit("Open Monitor Page", null) : new MonitorPage(desc);
        if (monPage != null && (panel = monPage.getPanel()) != null) {
            HashMap<String, Serializable> data;
            DataPanelDescriptor panDesc;
            HashMap<Object, Object> par = new HashMap<Object, Object>();
            if (desc != null && (panDesc = desc.getPanel()) != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
                par.putAll(data);
            }
            par.put(Panel.TITLE, monPage.getName());
            Consumer<JComponent> onClose = c -> this.onClose((JComponent)c);
            par.put(Panel.ON_CLOSE, onClose);
            Console.getConsole().getPanelManager().open((Component)panel, par);
            monPage.getView().install();
            this.currentViews.add(monPage);
        }
    }

    private void onClose(JComponent panel) {
        String name;
        MonitorPage monPage = null;
        Iterator<MonitorPage> it = this.currentViews.iterator();
        while (it.hasNext()) {
            MonitorPage p = it.next();
            if (panel != p.getPanel()) continue;
            monPage = p;
            it.remove();
            break;
        }
        if (monPage == null) {
            return;
        }
        monPage.getView().uninstall();
        MonitorPage.Descriptor pd = monPage.save();
        if (pd != null && (name = pd.getName()) != null) {
            Iterator<MonitorPage.Descriptor> itt = this.recentViews.iterator();
            while (itt.hasNext()) {
                if (!itt.next().getName().equals(name)) continue;
                itt.remove();
                break;
            }
            if (this.recentViews.size() > 9) {
                this.recentViews.pollLast();
            }
            this.recentViews.addFirst(pd);
            this.resetMenu();
        }
    }

    private void resetMenu() {
        Console console = this.getConsole();
        console.removeMenu(" CCS Tools ", "Monitoring...");
        this.getServices().addMenu(this.newView, "400: CCS Tools :-1:15", "Monitoring...:1");
        int i = 0;
        for (final MonitorPage.Descriptor desc : this.recentViews) {
            AbstractAction act = new AbstractAction(desc.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LsstMonitorPlugin.this.openManagedPage(desc);
                }
            };
            this.getServices().addMenu(act, "400: CCS Tools :-1:15", "Monitoring...:1:" + i++);
        }
    }

    @Override
    public ComponentDescriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (!this.currentViews.isEmpty()) {
            MonitorPage.Descriptor[] current = this.currentViews.stream().map(page -> page.save()).collect(Collectors.toList()).toArray(new MonitorPage.Descriptor[0]);
            desc.setCurrentViews(current);
        }
        if (!this.recentViews.isEmpty()) {
            MonitorPage.Descriptor[] recent = this.recentViews.toArray(new MonitorPage.Descriptor[0]);
            desc.setRecentViews(recent);
        }
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        PanelManager pm = this.getConsole().getPanelManager();
        for (MonitorPage page : new ArrayList<MonitorPage>(this.currentViews)) {
            pm.close(page.getPanel());
        }
        this.currentViews.clear();
        this.recentViews.clear();
        if (storageBean instanceof Descriptor) {
            Descriptor desc = (Descriptor)storageBean;
            MonitorPage.Descriptor[] mvd = desc.getCurrentViews();
            if (mvd != null) {
                for (MonitorPage.Descriptor d : mvd) {
                    this.openManagedPage(d);
                }
            }
            if (desc.getRecentViews() != null) {
                this.recentViews.addAll(Arrays.asList(desc.getRecentViews()));
            }
        }
        this.resetMenu();
        return true;
    }

    public static void saveData(OutputStream out, String mimeType, List<AgentChannel> channels, List<MonitorField> fields) {
        PrintStream ps = new PrintStream(out);
        StringBuilder sb = new StringBuilder();
        for (MonitorField field : fields) {
            sb.append(field.getTitle()).append(",");
        }
        ps.println(sb.substring(0, sb.length() - 1));
        for (AgentChannel channel : channels) {
            sb = new StringBuilder();
            for (MonitorField field : fields) {
                sb.append((String)channel.get(field.getKey())).append(",");
            }
            ps.println(sb.substring(0, sb.length() - 1));
        }
    }

    private class Saver
    extends CommandProcessor
    implements PageListener {
        private boolean on;

        private Saver() {
        }

        public void pageChanged(PageEvent pe) {
            PageContext context = pe.getPageContext();
            if (context == null) {
                return;
            }
            JComponent panel = (JComponent)context.getPage();
            if (panel == null) {
                return;
            }
            switch (pe.getID()) {
                case 3999: {
                    MonitorDisplay md = this.findMonitorDisplay(panel, false);
                    if (md == null) {
                        if (!this.on) break;
                        LsstMonitorPlugin.this.app.getCommandTargetManager().remove((CommandGroup)this);
                        this.on = false;
                        break;
                    }
                    if (this.on) break;
                    LsstMonitorPlugin.this.app.getCommandTargetManager().add((CommandGroup)this);
                    this.on = true;
                    break;
                }
            }
        }

        private MonitorDisplay findMonitorDisplay(JComponent component, boolean visibleOnly) {
            Component[] cc;
            if (visibleOnly && !component.isShowing()) {
                return null;
            }
            if (component instanceof MonitorDisplay) {
                return (MonitorDisplay)((Object)component);
            }
            for (Component c : cc = component.getComponents()) {
                MonitorDisplay md;
                if (!(c instanceof JComponent) || (md = this.findMonitorDisplay((JComponent)c, visibleOnly)) == null) continue;
                return md;
            }
            return null;
        }

        public void onSaveAs() {
            try {
                PageManager pm = LsstMonitorPlugin.this.app.getPageManager();
                PageContext context = pm.getSelectedPage();
                JComponent component = (JComponent)context.getPage();
                MonitorDisplay md = this.findMonitorDisplay(component, true);
                Properties user = LsstMonitorPlugin.this.app.getUserProperties();
                String creator = "creator";
                ExportDialog dlg = new ExportDialog(creator, false);
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.setUserProperties(user);
                dlg.showExportDialog((Component)LsstMonitorPlugin.this.app, "Save As...", (Component)((Object)md), "monitor");
            }
            catch (ClassCastException | NullPointerException x) {
                LsstMonitorPlugin.this.app.error("No selected monitoring table", (Throwable)x);
            }
        }
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private MonitorPage.Descriptor[] currentViews;
        private MonitorPage.Descriptor[] recentViews;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public MonitorPage.Descriptor[] getCurrentViews() {
            return this.currentViews;
        }

        public void setCurrentViews(MonitorPage.Descriptor[] currentViews) {
            this.currentViews = currentViews;
        }

        public MonitorPage.Descriptor[] getRecentViews() {
            return this.recentViews;
        }

        public void setRecentViews(MonitorPage.Descriptor[] recentViews) {
            this.recentViews = recentViews;
        }
    }
}

