/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingSource;

public class CompoundTrendingSource
extends TrendingSource {
    private final Set<TrendingSource> sources = Collections.newSetFromMap(new IdentityHashMap());
    private Map<TrendingChannel, TrendingSource> chan2source = new HashMap<TrendingChannel, TrendingSource>();
    private final TrendingSource.Listener forwarder = e -> {
        ArrayList<TrendingChannel> removed;
        ArrayList<TrendingChannel> added;
        CompoundTrendingSource compoundTrendingSource = this;
        synchronized (compoundTrendingSource) {
            Set<TrendingChannel> before = this.chan2source.keySet();
            this.chan2source = new HashMap<TrendingChannel, TrendingSource>();
            this.sources.forEach(source -> source.getChannels().forEach(channel -> this.chan2source.put((TrendingChannel)channel, (TrendingSource)source)));
            HashSet<TrendingChannel> after = new HashSet<TrendingChannel>(this.chan2source.keySet());
            after.removeAll(before);
            added = new ArrayList<TrendingChannel>(after);
            before.removeAll(this.chan2source.keySet());
            removed = new ArrayList<TrendingChannel>(before);
        }
        this.fireEvent(removed, added);
    };

    public synchronized ArrayList<TrendingChannel> getChannels() {
        return new ArrayList<TrendingChannel>(this.chan2source.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrendData get(TrendingChannel channel, long begin, long end, EnumSet<Trend.Meta> extra, TrendData data) {
        TrendingSource source;
        CompoundTrendingSource compoundTrendingSource = this;
        synchronized (compoundTrendingSource) {
            source = this.chan2source.get(channel);
        }
        return source == null ? null : source.get(channel, begin, end, extra, data);
    }

    public boolean add(TrendingSource source) {
        return this.add(Collections.singletonList(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(List<TrendingSource> sourcesToAdd) {
        ArrayList<TrendingChannel> addedChannels = new ArrayList<TrendingChannel>();
        CompoundTrendingSource compoundTrendingSource = this;
        synchronized (compoundTrendingSource) {
            sourcesToAdd.forEach(source -> {
                if (this.sources.add((TrendingSource)source)) {
                    List<TrendingChannel> channels = source.getChannels();
                    channels.forEach(channel -> {
                        TrendingSource other = this.chan2source.put((TrendingChannel)channel, (TrendingSource)source);
                        if (other == null) {
                            addedChannels.add((TrendingChannel)channel);
                        }
                    });
                    source.addListener(this.forwarder);
                }
            });
        }
        if (!addedChannels.isEmpty()) {
            this.fireEvent(null, addedChannels);
            return true;
        }
        return false;
    }

    public boolean remove(TrendingSource source) {
        return this.remove(Collections.singletonList(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(List<TrendingSource> sourcesToRemove) {
        ArrayList<TrendingChannel> removedChannels = new ArrayList<TrendingChannel>();
        CompoundTrendingSource compoundTrendingSource = this;
        synchronized (compoundTrendingSource) {
            sourcesToRemove.forEach(source -> {
                if (this.sources.remove(source)) {
                    List<TrendingChannel> channels = source.getChannels();
                    channels.forEach(channel -> this.chan2source.remove(channel));
                    source.removeListener(this.forwarder);
                }
            });
            if (!removedChannels.isEmpty()) {
                this.sources.forEach(source -> source.getChannels().forEach(channel -> {
                    if (removedChannels.remove(channel)) {
                        this.chan2source.put((TrendingChannel)channel, (TrendingSource)source);
                    }
                }));
            }
        }
        if (!removedChannels.isEmpty()) {
            this.fireEvent(null, removedChannels);
            return true;
        }
        return false;
    }

    public boolean set(TrendingSource source) {
        return this.set(Collections.singletonList(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(List<TrendingSource> sourcesToSet) {
        ArrayList<TrendingChannel> addedChannels;
        List removedChannels;
        CompoundTrendingSource compoundTrendingSource = this;
        synchronized (compoundTrendingSource) {
            removedChannels = this.getChannels();
            this.sources.forEach(source -> source.removeListener(this.forwarder));
            this.sources.clear();
            this.chan2source.clear();
            addedChannels = new ArrayList<TrendingChannel>();
            sourcesToSet.forEach(source -> {
                if (this.sources.add((TrendingSource)source)) {
                    List<TrendingChannel> channels = source.getChannels();
                    channels.forEach(channel -> {
                        TrendingSource other = this.chan2source.put((TrendingChannel)channel, (TrendingSource)source);
                        if (other == null) {
                            addedChannels.add((TrendingChannel)channel);
                        }
                    });
                    source.addListener(this.forwarder);
                }
            });
        }
        if (!addedChannels.isEmpty() || !((ArrayList)removedChannels).isEmpty()) {
            this.fireEvent(removedChannels, addedChannels);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear() {
        List removedChannels;
        CompoundTrendingSource compoundTrendingSource = this;
        synchronized (compoundTrendingSource) {
            removedChannels = this.getChannels();
            this.sources.forEach(source -> source.removeListener(this.forwarder));
            this.sources.clear();
            this.chan2source.clear();
        }
        if (!((ArrayList)removedChannels).isEmpty()) {
            this.fireEvent(removedChannels, null);
            return true;
        }
        return false;
    }
}

