/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;

public class MeshTable
extends MonitorTable {
    private List<MonitorField> extraColumns;
    private int firstExtraColumn;
    private List<MonitorField> updatableFields;
    private LinkedHashMap<String, List<Map.Entry<String[], ChannelHandle>>> sections;

    public static MeshTable getInstance(Collection<Map.Entry<String, ChannelHandle>> channels, List<MonitorField> fields) {
        MeshTable instance = new MeshTable();
        instance.init(channels, fields);
        return instance;
    }

    private MeshTable() {
    }

    /*
     * WARNING - void declaration
     */
    public void init(Collection<Map.Entry<String, ChannelHandle>> channels, List<MonitorField> fields) {
        void var9_17;
        List<ChannelHandle> handles = channels.stream().map(e -> (ChannelHandle)e.getValue()).collect(Collectors.toList());
        this.extraColumns = MeshTable.trimAbsentFields(fields, handles, Arrays.asList(MonitorField.NAME, MonitorField.VALUE));
        if (this.extraColumns.isEmpty()) {
            this.updatableFields = Collections.singletonList(MonitorField.VALUE);
        } else {
            this.updatableFields = new ArrayList<MonitorField>();
            this.updatableFields.add(MonitorField.VALUE);
            this.extraColumns.stream().filter(MonitorField::isUpdatable).forEach(f -> this.updatableFields.add((MonitorField)f));
            ((ArrayList)this.updatableFields).trimToSize();
        }
        this.sections = new LinkedHashMap();
        ArrayList<AbstractMap.SimpleImmutableEntry<String[], ChannelHandle>> defSection = new ArrayList<AbstractMap.SimpleImmutableEntry<String[], ChannelHandle>>();
        this.sections.put("", defSection);
        for (Map.Entry<String, ChannelHandle> e2 : channels) {
            void var9_10;
            String[] ss = e2.getKey().split("/+");
            if (ss.length == 2) {
                defSection.add(new AbstractMap.SimpleImmutableEntry<String[], ChannelHandle>(ss, e2.getValue()));
                continue;
            }
            if (ss.length != 3) continue;
            String section = ss[0];
            List<Map.Entry<String[], ChannelHandle>> list = this.sections.get(section);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                this.sections.put(section, arrayList);
            }
            var9_10.add(new AbstractMap.SimpleImmutableEntry<String[], ChannelHandle>(Arrays.copyOfRange(ss, 1, 3), e2.getValue()));
        }
        ArrayList<String> columns = new ArrayList<String>();
        this.cells = new ArrayList();
        ArrayList<MonitorCell> columnNamesRow = new ArrayList<MonitorCell>();
        columnNamesRow.add(MonitorCell.EMPTY);
        this.cells.add(columnNamesRow);
        int rowOffset = 1;
        for (Map.Entry entry : this.sections.entrySet()) {
            String section = (String)entry.getKey();
            if (!section.isEmpty()) {
                ArrayList<SectionTitleCell> sectionTitleRow = new ArrayList<SectionTitleCell>();
                sectionTitleRow.add(new SectionTitleCell(section));
                this.cells.add(sectionTitleRow);
                ++rowOffset;
            }
            ArrayList<String> rows = new ArrayList<String>();
            for (Map.Entry e3 : (List)entry.getValue()) {
                ArrayList<MonitorCell> row;
                String rowName = ((String[])e3.getKey())[0];
                String columnName = ((String[])e3.getKey())[1];
                int rowIndex = rows.indexOf(rowName);
                if (rowIndex == -1) {
                    rows.add(rowName);
                    rowIndex = rows.size() - 1 + rowOffset;
                    row = new ArrayList<MonitorCell>();
                    row.add(new MonitorCell(null, null, new FormattedValue(rowName, 2)));
                    this.cells.add(row);
                } else {
                    row = (ArrayList<MonitorCell>)this.cells.get(rowIndex += rowOffset);
                }
                int columnIndex = columns.indexOf(columnName);
                if (columnIndex == -1) {
                    columns.add(columnName);
                    columnNamesRow.add(new MonitorCell(null, null, new FormattedValue(columnName, 0)));
                    columnIndex = columns.size();
                } else {
                    ++columnIndex;
                }
                while (row.size() <= columnIndex) {
                    row.add(MonitorCell.EMPTY);
                }
                ValueCell cell = new ValueCell((ChannelHandle)e3.getValue(), rowIndex);
                ((ChannelHandle)e3.getValue()).setTarget(cell);
                this.format.format(cell);
                row.set(columnIndex, cell);
            }
            rowOffset += rows.size();
        }
        this.cells.trimToSize();
        this.nRows = this.cells.size();
        this.nColumns = 1 + columns.size() + this.extraColumns.size();
        this.firstExtraColumn = columns.size();
        ArrayList titleRow = (ArrayList)this.cells.get(0);
        for (MonitorField f2 : this.extraColumns) {
            titleRow.add(new MonitorCell(null, null, new FormattedValue(f2.getTitle(), 0)));
        }
        boolean bl = true;
        while (var9_17 < this.nRows) {
            ArrayList row = (ArrayList)this.cells.get((int)var9_17);
            ArrayList<ChannelHandle> items = new ArrayList<ChannelHandle>(row.size());
            for (MonitorCell cell : row) {
                items.addAll(cell.getChannels());
            }
            items.trimToSize();
            while (row.size() < columns.size() + 1) {
                row.add(MonitorCell.EMPTY);
            }
            for (MonitorField f3 : this.extraColumns) {
                if (items.isEmpty()) {
                    row.add(MonitorCell.EMPTY);
                    continue;
                }
                MonitorCell cell = new MonitorCell(items, f3);
                this.format.format(cell);
                row.add(cell);
            }
            row.trimToSize();
            ++var9_17;
        }
    }

    @Override
    public void destroy() {
        this.sections.values().forEach(items -> items.forEach(e -> ((ChannelHandle)e.getValue()).setTarget(null)));
    }

    @Override
    public boolean showHeader() {
        return false;
    }

    private class ValueCell
    extends MonitorCell
    implements Updatable {
        final int row;

        ValueCell(ChannelHandle channelHandle, int row) {
            super(channelHandle, MonitorField.VALUE);
            this.row = row;
        }

        @Override
        public void update(ChannelHandle channelHandle, List<MonitorField> fields) {
            for (MonitorField f : fields) {
                if (MonitorField.VALUE.equals(f)) {
                    MeshTable.this.format.format(this);
                    continue;
                }
                int column = MeshTable.this.extraColumns.indexOf(f);
                if (column == -1) continue;
                MeshTable.this.format.format((MonitorCell)((ArrayList)MeshTable.this.cells.get(this.row)).get(column + MeshTable.this.firstExtraColumn), channelHandle);
            }
            MeshTable.this.fireTableRowsUpdated(this.row, this.row);
            MeshTable.this.fireChangeEvent(MeshTable.this.CELLS_EVENT);
        }

        @Override
        public void update(ChannelHandle channelHandle) {
            MeshTable.this.format.format(this);
            for (int column = 0; column < MeshTable.this.extraColumns.size(); ++column) {
                MonitorField f = (MonitorField)MeshTable.this.extraColumns.get(this.row);
                if (!f.isUpdatable()) continue;
                MeshTable.this.format.format((MonitorCell)((ArrayList)MeshTable.this.cells.get(this.row)).get(column + MeshTable.this.firstExtraColumn), channelHandle);
            }
            MeshTable.this.fireTableRowsUpdated(this.row, this.row);
            MeshTable.this.fireChangeEvent(MeshTable.this.CELLS_EVENT);
        }

        @Override
        public List<MonitorField> getAffectedFields(List<String> attributes) {
            return MonitorField.getAffectedFields(attributes, MeshTable.this.updatableFields);
        }
    }

    private class SectionTitleCell
    extends MonitorCell {
        final String title;

        SectionTitleCell(String title) {
            super(null, null, new FormattedValue("<html><b> " + title, 2));
            this.title = title;
        }

        String getTitle() {
            return this.title;
        }
    }
}

