/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSFullState;
import org.lsst.ccs.subsystem.teststand.data.TSState;

public class TSGUI
implements StatusMessageListener,
AgentPresenceListener {
    private String teststand_dest = "ts2";
    private MonitorTrendingTable table;
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    private boolean enabled = false;
    private static final long serialVersionUID = -8352262068369045572L;
    private static final Map<Integer, String> pStateMap = new HashMap<Integer, String>();
    private static final String NB_SPACE = "\u00a0";
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    static final Font f = new Font("Tahoma", 1, 14);
    static final Font bigf = new Font("Tahoma", 1, 16);
    private static final JLabel lbteststand = new JLabel("Subsystem Status");
    private static final JLabel lbteststandstate = new JLabel("STATE");
    private static final JLabel lbteststanderr = new JLabel("ERRORS");
    private static final JButton btteststandcfg = new JButton("IDLE");
    private static final JButton btteststandabrt = new JButton("ABORT ACQ!");
    private static final JLabel lbteststandacqtyp = new JLabel("ACQ TYPE");
    private static final JLabel lbBias = new JLabel("Bias/PD");
    private static final JLabel lbBiasState = new JLabel("State");
    private static final JLabel lbBiasV = new JLabel("Bias V/I");
    private static final JLabel lbPDI = new JLabel("PD I");
    private static final JLabel lbBiasVacq = new JLabel("Acq. BiasV Set Point");
    private static final JLabel lbCryo = new JLabel("Cryogenics");
    private static final JLabel lbCryoState = new JLabel("State");
    private static final JLabel lbCryoTemp = new JLabel("Temperature (C)");
    private static final JLabel lbCryoTacq = new JLabel("Acq. CryoT Set Point");
    private static final JLabel lbVac = new JLabel("Vacuum");
    private static final JLabel lbVacState = new JLabel("State");
    private static final JLabel lbVacPres = new JLabel("Pressure (Torr)");
    private static final JLabel lbVacPacq = new JLabel("Acq. Vac Set Point");
    private static final JLabel lbLmp = new JLabel("Lamp");
    private static final JLabel lbLmpState = new JLabel("State");
    private static final JLabel lbLmpCurr = new JLabel("Power (Watts)");
    private static final JLabel lbXED = new JLabel("XED");
    private static final JLabel lbXEDState = new JLabel("State");
    private static final JLabel lbMono = new JLabel("MonoChromator");
    private static final JLabel lbMonoState = new JLabel("State");
    private static final JLabel lbMonoWL = new JLabel("Wavelength (nm)");
    private static final JLabel lbMonoSW1 = new JLabel("Slit1 Size (um)");
    private static final JLabel lbMonoSW2 = new JLabel("Slit2 Size (um)");
    private static final JLabel lbMonoFL = new JLabel("Filter");
    private static final JButton btMonoSH = new JButton("shutter");
    private static final JButton btMonoFL1 = new JButton("position 1");
    private static final JButton btMonoFL2 = new JButton("position 2");
    private static final JButton btMonoFL3 = new JButton("position 3");
    private static final JButton btMonoFL4 = new JButton("position 4");
    private static final JButton btMonoFL5 = new JButton("position 5");
    private static final JButton btMonoFL6 = new JButton("position 6");
    private static final JButton btacqimage = new JButton("acquire");
    private static final JButton btds9 = new JButton("view");
    private static final JButton btetrv = new JButton("eTraveler");
    private static final JLabel lbSens = new JLabel("Sensor Controller");
    private static final JLabel lbSensState = new JLabel("State");
    private static final JLabel lbSensCT = new JLabel("#images");
    private static final JLabel lbext = new JLabel("Image Functions");
    private static final JLabel lbconfig = new JLabel("Configuration");
    private static final JButton btSaveConfig = new JButton("Save Config");
    private final JLabel lbMessage = new JLabel("\u00a0");
    private final JPanel panel = new JPanel();
    private final JPanel teststandPanel = new JPanel();
    private final JPanel bssPanel = new JPanel();
    private final JPanel cryoPanel = new JPanel();
    private final JPanel vacPanel = new JPanel();
    private final JPanel lmpPanel = new JPanel();
    private final JPanel xedPanel = new JPanel();
    private final JPanel monoPanel = new JPanel();
    private final JPanel extPanel = new JPanel();
    private final NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
    private final NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.##"));
    private final NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.####E00"));
    private final JFormattedTextField tfState = new JFormattedTextField();
    private final JFormattedTextField tfErr = new JFormattedTextField();
    private final JFormattedTextField tfAcqTyp = new JFormattedTextField();
    private final JFormattedTextField tfBiasState = new JFormattedTextField();
    private final JFormattedTextField tfBiasV = new JFormattedTextField();
    private final JFormattedTextField tfBiasVacq = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfPDI = new JFormattedTextField(this.fmt5e);
    private final JFormattedTextField tfCryoState = new JFormattedTextField();
    private final JFormattedTextField tfCryoTemp = new JFormattedTextField();
    private final JFormattedTextField tfCryoTacq = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfVacState = new JFormattedTextField();
    private final JFormattedTextField tfVacP = new JFormattedTextField(this.fmt5e);
    private final JFormattedTextField tfLmpState = new JFormattedTextField();
    private final JFormattedTextField tfLmpC = new JFormattedTextField(this.fmt5);
    private final JFormattedTextField tfXEDState = new JFormattedTextField();
    private final JFormattedTextField tfMonoState = new JFormattedTextField();
    private final JFormattedTextField tfMonoWL = new JFormattedTextField(this.fmt5);
    private final JFormattedTextField tfMonoSW1 = new JFormattedTextField(this.fmt5);
    private final JFormattedTextField tfMonoSW2 = new JFormattedTextField(this.fmt5);
    private final JFormattedTextField tfMonoFL = new JFormattedTextField();
    private final JFormattedTextField tfVacPacq = new JFormattedTextField(this.fmt5e);
    private final JFormattedTextField tfR = new JFormattedTextField(this.fmt5);
    private static final String archon_dest = "archon";
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    static final Color BLUE = new Color(0, 0, 150);
    static final Color WHITE = new Color(150, 150, 150);
    static final Color YELLOW = new Color(200, 200, 0);
    static final Color BLACK = new Color(0, 0, 0);
    static final Color GREY = new Color(80, 80, 80);
    private static final Map<String, Color> typeMap = new HashMap<String, Color>();
    private JFrame pl = null;
    private JFrame plcfg = null;
    private int cfgstate = TSConfig.operating_states.IDLE.ordinal();
    Integer fltpos = 1;
    boolean shstate = false;
    String lastpath = "";
    String[] Filter = new String[]{"blue", "white", "red", "white", "green", "yellow"};
    private final AgentMessagingLayer agentMessagingLayer;
    private final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.teststand.ui.TSGUI");

    public TSGUI(AgentMessagingLayer agentMessagingLayer) {
        System.out.println("TSGUI: Retrieving teststand name on the bus from property lsst.ccs.teststand.tsguidest");
        this.teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.agentMessagingLayer = agentMessagingLayer;
    }

    public void main(String[] args) throws ClassNotFoundException {
        System.out.println("starting TSGUI main");
        this.teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.initGui();
        System.out.println("past initGui");
        JPanel xpane = new JPanel();
        xpane.setLayout(new BorderLayout());
        xpane.add((Component)this.getPanel(), "Center");
        JFrame f = new JFrame("Test Stand Console");
        f.setContentPane(xpane);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public void initGui() {
        System.out.println("initGui: Retrieving teststand name on the bus from property lsst.ccs.teststand.tsguidest");
        this.teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        System.out.println("teststand_dest = " + this.teststand_dest);
        this.initComponents();
        this.agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.teststand_dest).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, filter);
    }

    public void connecting(AgentInfo agent) {
        if (agent.getName().equals(this.teststand_dest)) {
            this.initConfigs();
        }
    }

    public void disconnecting(AgentInfo agent) {
    }

    private CommandOriginator getCommandOriginator() {
        CommandOriginator originator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processResult(CommandResult result) {
                TSFullState r = (TSFullState)result.getReply();
                TSGUI.this.log.fine("TSGUI received TSFullState reply");
                TSGUI.this.UpdateTSStatus(r.getTSState());
                TSGUI.this.enabled = true;
            }
        };
        return originator;
    }

    public void UpdateTSStatus(TSState rs) {
        if (rs != null) {
            int st = rs.getSystemState();
            this.tfState.setText(TSConfig.operating_states.values()[rs.getOperState()].name());
            if ((st & 2) != 0) {
                this.tfState.setForeground(GREEN);
            } else {
                this.tfState.setForeground(BLACK);
            }
            String acqtyp = (String)this.sendSyncArchonCommand("getLastTestType", new Object[0]);
            if (acqtyp != null && !acqtyp.isEmpty()) {
                this.tfAcqTyp.setText(acqtyp);
            }
            String strerr = "unknown";
            Color colbkg = this.panel.getBackground();
            if ((st & 2) != 0) {
                strerr = "READY";
                this.tfErr.setForeground(Color.BLACK);
            }
            if ((st & 0x380) != 0) {
                strerr = "TRIPPED";
                this.toolkit.beep();
                this.panel.setBackground(Color.RED);
                try {
                    Thread.sleep(1000L);
                    this.toolkit.beep();
                    this.panel.setBackground(colbkg);
                    this.panel.setBackground(Color.RED);
                    this.toolkit.beep();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    System.out.println("sleep interrupted!");
                }
                this.panel.setBackground(colbkg);
                this.panel.setBackground(Color.RED);
                this.tfErr.setForeground(Color.RED);
            }
            if ((st & (TSState.CRYO_DEV_WARNING | TSState.VAC_DEV_WARNING)) != 0) {
                strerr = "WARNING";
                this.toolkit.beep();
                this.panel.setBackground(Color.MAGENTA);
                this.tfErr.setForeground(Color.MAGENTA);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    this.log.info("sleep interrupted");
                }
            }
            this.panel.setBackground(colbkg);
            this.panel.repaint();
            this.tfErr.setEditable(false);
            if ((st & 0x80) != 0) {
                this.tfBiasState.setText("TRIPPED");
                this.tfBiasState.setForeground(RED);
                this.tfBiasState.repaint();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(TSGUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.tfBiasState.setText("OK");
                this.tfBiasState.setForeground(GREEN);
            }
            double bias = rs.getVolts();
            double bias_curr = rs.getBIAS_curr();
            this.tfBiasV.setValue(String.valueOf(bias) + "/" + String.format("%6.1e", bias_curr));
            this.tfBiasV.setEditable(false);
            Color biasbgclr = Color.GREEN;
            if (bias > -20.0) {
                biasbgclr = Color.PINK;
            }
            if ((st & 0x400) == 0) {
                biasbgclr = Color.GRAY;
            }
            lbBiasV.setBackground(biasbgclr);
            lbBiasV.repaint();
            double curr = rs.getCurr();
            this.tfPDI.setValue(curr);
            this.tfPDI.setEditable(false);
            Color pdbgclr = Color.GREEN;
            if (Math.abs(curr) > 0.1) {
                pdbgclr = Color.PINK;
            }
            if ((st & 0x40000) == 0) {
                pdbgclr = Color.RED;
            }
            lbPDI.setBackground(pdbgclr);
            lbPDI.repaint();
            boolean c_on = (st & 0x800) != 0;
            this.tfCryoState.setText(c_on ? "OK" : "OFF");
            this.tfCryoState.setForeground((st & 0x800) != 0 ? GREEN : RED);
            this.tfCryoState.setEditable(false);
            double temp = rs.getTemp();
            double temp2 = rs.getTemp2();
            Color cryobgclr = Color.GREEN;
            if (temp > -80.0 && temp2 > -80.0) {
                cryobgclr = Color.PINK;
            }
            if ((st & 0x800) == 0) {
                cryobgclr = Color.GRAY;
            }
            lbCryo.setBackground(cryobgclr);
            lbCryo.repaint();
            this.tfCryoTemp.setValue(String.format("%5.1f", temp) + "/" + String.format("%5.1f", temp2));
            this.tfCryoTemp.setEditable(false);
            boolean v_on = (st & 0x81000) != 0;
            this.tfVacState.setText(v_on ? "OK" : "OFF");
            this.tfVacState.setForeground((st & 0x81000) != 0 ? GREEN : RED);
            this.tfVacState.setEditable(false);
            double pres = -999.0;
            if (rs.getVac() > 0.0) {
                pres = rs.getVac();
            }
            if (pres <= 0.0) {
                pres = rs.getVac2();
            }
            Color vacbgclr = Color.GREEN;
            if (pres > 1.0E-5) {
                vacbgclr = Color.PINK;
            }
            if ((st & 0x1000) == 0 && pres < 0.0) {
                vacbgclr = Color.RED;
            }
            lbVac.setBackground(vacbgclr);
            lbVac.repaint();
            this.tfVacP.setValue(pres);
            this.tfVacP.setEditable(false);
            this.tfMonoFL.setText("Filt" + this.fltpos + ": " + this.Filter[this.fltpos - 1]);
            this.tfMonoWL.setValue(rs.getWl());
            this.tfMonoSW1.setValue(rs.getSw1());
            this.tfMonoSW2.setValue(rs.getSw2());
            if (rs.getWl() >= 0.0) {
                this.tfMonoState.setValue("ON");
                lbMono.setBackground(Color.GREEN);
            } else {
                this.tfMonoState.setValue("OFF");
                lbMono.setBackground(Color.RED);
            }
            lbMono.repaint();
            this.tfLmpC.setValue(rs.getLmppwr());
            if (rs.getLmppwr() > 0.0) {
                this.tfLmpState.setValue("ON");
                lbLmp.setBackground(Color.GREEN);
            } else {
                this.tfLmpState.setValue("OFF");
                lbLmp.setBackground(Color.RED);
            }
            lbLmp.repaint();
            if (rs.getXedpos() == 0) {
                this.tfXEDState.setValue("retracted");
                lbXEDState.setBackground(Color.GREEN);
            } else if (rs.getXedpos() == 1) {
                this.tfXEDState.setValue("extended");
                lbXEDState.setBackground(Color.GREEN);
            } else {
                this.tfXEDState.setValue("unknown");
                lbXEDState.setBackground(Color.RED);
            }
            String last_warning = rs.getWarning();
            if (last_warning == null) {
                last_warning = "";
            }
            this.display("<html>Last heart beat at - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(this.lastHeartBeat)) + "<br>" + last_warning + "</html>");
            this.display("Last heart beat at - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(this.lastHeartBeat)));
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        block4: {
            try {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                KeyValueData msgObject = ssd.getSubsystemData();
                if (msgObject instanceof KeyValueData) {
                    KeyValueData d = msgObject;
                    System.out.println("TSGUI: In onDataArrival method. KEY=" + d.getKey());
                    if (d.getKey().equals("TSState")) {
                        this.UpdateTSStatus((TSState)d.getValue());
                    }
                }
            }
            catch (RuntimeException e) {
                if (e.toString().contains("de-serializing")) break block4;
                this.log.info("Problem unpacking message:" + e);
            }
        }
        this.lastHeartBeat = msg.getTimeStamp();
    }

    private void display(String message) {
        this.lbMessage.setFont(bigf);
        this.lbMessage.setForeground(WHITE);
        this.lbMessage.setText(message);
    }

    private void initConfigs() {
        System.out.println("Now in initConfigs");
        btteststandcfg.setText("cfg:" + TSConfig.operating_states.values()[this.cfgstate].name());
        boolean do_update = false;
        for (int idx = 0; idx < 6; ++idx) {
            Object response = this.sendSyncTSCommand("Monochromator", "getFilterLabel", idx + 1);
            this.Filter[idx] = "empty";
            if (response == null) continue;
            if (!((String)response).equals(this.Filter[idx])) {
                do_update = true;
                System.out.println("Filter label #" + idx + " = " + this.Filter[idx]);
            }
            this.Filter[idx] = (String)response;
        }
        if (do_update) {
            btMonoFL1.setBackground(typeMap.get(this.Filter[0]));
            btMonoFL2.setBackground(typeMap.get(this.Filter[1]));
            btMonoFL3.setBackground(typeMap.get(this.Filter[2]));
            btMonoFL4.setBackground(typeMap.get(this.Filter[3]));
            btMonoFL5.setBackground(typeMap.get(this.Filter[4]));
            btMonoFL6.setBackground(typeMap.get(this.Filter[5]));
        }
        Object response = this.sendSyncTSCommand("Bias", "getRunBias", this.cfgstate);
        double runBias = 0.0;
        if (response != null) {
            runBias = (Double)response;
        }
        this.tfBiasVacq.setValue(runBias);
        response = this.sendSyncTSCommand("Cryo", "getRunTemp", this.cfgstate);
        double runTemp = -999.0;
        if (response != null) {
            runTemp = (Double)response;
        }
        this.tfCryoTacq.setValue(runTemp);
        response = this.sendSyncTSCommand("VacuumGauge", "getRunVac", this.cfgstate);
        double runVac = 0.0;
        if (response != null) {
            runVac = (Double)response;
        }
        this.tfVacPacq.setValue(runVac);
    }

    private void initComponents() {
        lbteststand.setFont(bigf);
        lbteststandstate.setFont(f);
        lbteststanderr.setFont(f);
        btteststandcfg.setFont(f);
        lbteststandacqtyp.setFont(f);
        btteststandabrt.setFont(f);
        btteststandabrt.setForeground(RED);
        btteststandabrt.setBackground(BLACK);
        lbBias.setFont(bigf);
        lbBiasState.setFont(f);
        lbBiasV.setFont(f);
        lbBiasV.setOpaque(true);
        lbPDI.setFont(f);
        lbPDI.setOpaque(true);
        lbCryo.setFont(bigf);
        lbCryo.setOpaque(true);
        lbCryoState.setFont(f);
        lbCryoTemp.setFont(f);
        lbVac.setFont(bigf);
        lbVac.setOpaque(true);
        lbVacState.setFont(f);
        lbVacPres.setFont(f);
        lbLmp.setFont(bigf);
        lbLmp.setOpaque(true);
        lbLmpState.setFont(f);
        lbLmpCurr.setFont(f);
        lbMono.setFont(bigf);
        lbMono.setOpaque(true);
        lbMonoState.setFont(f);
        lbMonoWL.setFont(f);
        lbMonoFL.setFont(f);
        this.teststandPanel.setBorder(BorderFactory.createTitledBorder("SUBSYSTEM"));
        this.teststandPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcTS = new GridBagConstraints();
        gbcTS.insets = new Insets(4, 4, 4, 4);
        gbcTS.anchor = 11;
        gbcTS.gridx = 0;
        gbcTS.gridy = 0;
        ++gbcTS.gridy;
        BufferedImage img = null;
        try {
            img = ImageIO.read(BootstrapResourceUtils.getBootstrapResource((String)"LSST-logo.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Image dimg = img.getScaledInstance(150, 60, 4);
        gbcTS.gridheight = 3;
        this.teststandPanel.add((Component)new JLabel(new ImageIcon(dimg)), gbcTS);
        gbcTS.gridy += gbcTS.gridheight;
        gbcTS.gridheight = 1;
        this.teststandPanel.add((Component)new JLabel("Test Stand"), gbcTS);
        ++gbcTS.gridy;
        this.teststandPanel.add((Component)new JLabel("Camera Ctrl Software"), gbcTS);
        ++gbcTS.gridy;
        this.teststandPanel.add((Component)new JLabel("ccs@kipac.stanford.edu"), gbcTS);
        gbcTS.gridy = 0;
        ++gbcTS.gridx;
        this.teststandPanel.add((Component)lbteststand, gbcTS);
        ++gbcTS.gridy;
        this.teststandPanel.add((Component)lbteststandstate, gbcTS);
        ++gbcTS.gridy;
        Dimension d = this.tfState.getPreferredSize();
        d.width = 100;
        d.height = 30;
        this.tfState.setPreferredSize(d);
        this.tfState.setValue("IDLE");
        this.tfState.setFont(bigf);
        this.tfState.setEditable(false);
        this.teststandPanel.add((Component)this.tfState, gbcTS);
        ++gbcTS.gridy;
        ++gbcTS.gridy;
        this.teststandPanel.add((Component)lbteststandacqtyp, gbcTS);
        ++gbcTS.gridy;
        d = this.tfAcqTyp.getPreferredSize();
        d.width = 100;
        d.height = 30;
        this.tfAcqTyp.setPreferredSize(d);
        this.tfAcqTyp.setValue("UNKNOWN");
        this.tfAcqTyp.setEditable(false);
        this.teststandPanel.add((Component)this.tfAcqTyp, gbcTS);
        ++gbcTS.gridy;
        this.teststandPanel.add((Component)btteststandabrt, gbcTS);
        btteststandabrt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btteststandabrt.setForeground(BLACK);
                btteststandabrt.setBackground(RED);
                TSGUI.this.sendSyncTSCommand(null, "abortInterpreter", new Object[0]);
                TSGUI.this.sendSyncTSCommand(null, "stopsubsys", new Object[0]);
            }
        });
        this.bssPanel.setBorder(BorderFactory.createTitledBorder("BIAS"));
        this.bssPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcBss = new GridBagConstraints();
        gbcBss.insets = new Insets(4, 4, 4, 4);
        gbcBss.anchor = 11;
        gbcBss.gridx = 0;
        gbcBss.gridy = 0;
        this.bssPanel.add((Component)lbBias, gbcBss);
        ++gbcBss.gridy;
        this.bssPanel.add((Component)lbBiasV, gbcBss);
        ++gbcBss.gridy;
        d = this.tfBiasV.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfBiasV.setPreferredSize(d);
        this.tfBiasV.setValue("0.0/0.0");
        this.tfBiasV.setEditable(false);
        this.bssPanel.add((Component)this.tfBiasV, gbcBss);
        ++gbcBss.gridy;
        this.bssPanel.add((Component)lbPDI, gbcBss);
        ++gbcBss.gridy;
        d = this.tfPDI.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfPDI.setPreferredSize(d);
        this.tfPDI.setValue(0.0);
        this.tfPDI.setEditable(false);
        this.bssPanel.add((Component)this.tfPDI, gbcBss);
        ++gbcBss.gridy;
        this.bssPanel.add((Component)lbBiasVacq, gbcBss);
        ++gbcBss.gridy;
        d = this.tfBiasVacq.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfBiasVacq.setPreferredSize(d);
        this.bssPanel.add((Component)this.tfBiasVacq, gbcBss);
        this.tfBiasVacq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.sendSyncTSCommand("Bias", "setrunbias", TSGUI.this.tfBiasVacq.getValue(), TSGUI.this.cfgstate);
                TSGUI.this.initConfigs();
            }
        });
        this.cryoPanel.setBorder(BorderFactory.createTitledBorder("CRYOGENICS"));
        this.cryoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcCryo = new GridBagConstraints();
        gbcCryo.insets = new Insets(4, 4, 4, 4);
        gbcCryo.anchor = 11;
        gbcCryo.gridx = 0;
        gbcCryo.gridy = 0;
        this.cryoPanel.add((Component)lbCryo, gbcCryo);
        ++gbcCryo.gridy;
        this.cryoPanel.add((Component)lbCryoState, gbcCryo);
        ++gbcCryo.gridy;
        d = this.tfCryoState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfCryoState.setPreferredSize(d);
        this.tfCryoState.setValue("DISCONNECTED");
        this.tfCryoState.setEditable(false);
        this.cryoPanel.add((Component)this.tfCryoState, gbcCryo);
        ++gbcCryo.gridy;
        this.cryoPanel.add((Component)lbCryoTemp, gbcCryo);
        ++gbcCryo.gridy;
        d = this.tfCryoTemp.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfCryoTemp.setPreferredSize(d);
        this.tfCryoTemp.setValue("0.0/0.0");
        this.tfCryoTemp.setEditable(false);
        this.cryoPanel.add((Component)this.tfCryoTemp, gbcCryo);
        ++gbcCryo.gridy;
        this.cryoPanel.add((Component)lbCryoTacq, gbcCryo);
        ++gbcCryo.gridy;
        d = this.tfCryoTacq.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfCryoTacq.setPreferredSize(d);
        this.cryoPanel.add((Component)this.tfCryoTacq, gbcCryo);
        this.tfCryoTacq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.sendSyncTSCommand("Cryo", "setRunTemp", TSGUI.this.tfCryoTacq.getValue(), TSGUI.this.cfgstate);
                TSGUI.this.initConfigs();
            }
        });
        this.vacPanel.setBorder(BorderFactory.createTitledBorder("VACUUM"));
        this.vacPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcVac = new GridBagConstraints();
        gbcVac.insets = new Insets(4, 4, 4, 4);
        gbcVac.anchor = 11;
        gbcVac.gridx = 0;
        gbcVac.gridy = 0;
        this.vacPanel.add((Component)lbVac, gbcVac);
        ++gbcVac.gridy;
        this.vacPanel.add((Component)lbVacState, gbcVac);
        ++gbcVac.gridy;
        d = this.tfVacState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfVacState.setPreferredSize(d);
        this.tfVacState.setValue("DISCONNECTED");
        this.tfVacState.setEditable(false);
        this.vacPanel.add((Component)this.tfVacState, gbcVac);
        ++gbcVac.gridy;
        this.vacPanel.add((Component)lbVacPres, gbcVac);
        ++gbcVac.gridy;
        d = this.tfVacP.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfVacP.setPreferredSize(d);
        this.tfVacP.setValue(0.0);
        this.tfVacP.setEditable(false);
        this.vacPanel.add((Component)this.tfVacP, gbcVac);
        ++gbcVac.gridy;
        this.vacPanel.add((Component)lbVacPacq, gbcVac);
        ++gbcVac.gridy;
        d = this.tfVacPacq.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfVacPacq.setPreferredSize(d);
        this.vacPanel.add((Component)this.tfVacPacq, gbcVac);
        this.tfVacPacq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.sendSyncTSCommand("VacuumGauge", "setRunVac", TSGUI.this.tfVacPacq.getValue(), TSGUI.this.cfgstate);
                TSGUI.this.initConfigs();
            }
        });
        this.lmpPanel.setBorder(BorderFactory.createTitledBorder("LAMP"));
        this.lmpPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcLmp = new GridBagConstraints();
        gbcLmp.insets = new Insets(4, 4, 4, 4);
        gbcLmp.anchor = 11;
        gbcLmp.gridx = 0;
        gbcLmp.gridy = 0;
        this.lmpPanel.add((Component)lbLmp, gbcLmp);
        ++gbcLmp.gridy;
        this.lmpPanel.add((Component)lbLmpState, gbcLmp);
        ++gbcLmp.gridy;
        d = this.tfLmpState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfLmpState.setPreferredSize(d);
        this.tfLmpState.setValue("DISCONNECTED");
        this.tfLmpState.setEditable(false);
        this.lmpPanel.add((Component)this.tfLmpState, gbcLmp);
        ++gbcLmp.gridy;
        this.lmpPanel.add((Component)lbLmpCurr, gbcLmp);
        ++gbcLmp.gridy;
        d = this.tfLmpC.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfLmpC.setPreferredSize(d);
        this.tfLmpC.setValue(0.0);
        this.tfLmpC.setEditable(false);
        this.lmpPanel.add((Component)this.tfLmpC, gbcLmp);
        this.xedPanel.setBorder(BorderFactory.createTitledBorder("XED"));
        this.xedPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcXED = new GridBagConstraints();
        gbcXED.insets = new Insets(4, 4, 4, 4);
        gbcXED.anchor = 11;
        gbcXED.gridx = 0;
        gbcXED.gridy = 0;
        this.xedPanel.add((Component)lbXED, gbcXED);
        ++gbcXED.gridy;
        this.xedPanel.add((Component)lbXEDState, gbcXED);
        ++gbcXED.gridy;
        d = this.tfXEDState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfXEDState.setPreferredSize(d);
        this.tfXEDState.setValue("UNKNOWN");
        this.tfXEDState.setEditable(false);
        this.xedPanel.add((Component)this.tfXEDState, gbcXED);
        this.monoPanel.setBorder(BorderFactory.createTitledBorder("MONOCHROMATOR"));
        this.monoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcMono = new GridBagConstraints();
        gbcMono.insets = new Insets(4, 4, 4, 4);
        gbcMono.anchor = 11;
        gbcMono.gridx = 0;
        gbcMono.gridy = 0;
        this.monoPanel.add((Component)lbMono, gbcMono);
        ++gbcMono.gridy;
        this.monoPanel.add((Component)lbMonoState, gbcMono);
        ++gbcMono.gridy;
        d = this.tfMonoState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfMonoState.setPreferredSize(d);
        this.tfMonoState.setValue("DISCONNECTED");
        this.tfMonoState.setEditable(false);
        this.monoPanel.add((Component)this.tfMonoState, gbcMono);
        ++gbcMono.gridy;
        this.monoPanel.add((Component)lbMonoWL, gbcMono);
        ++gbcMono.gridy;
        d = this.tfMonoWL.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfMonoWL.setPreferredSize(d);
        this.tfMonoWL.setValue(0.0);
        this.tfMonoWL.setEditable(false);
        this.monoPanel.add((Component)this.tfMonoWL, gbcMono);
        ++gbcMono.gridx;
        gbcMono.gridy = 0;
        d = this.tfMonoFL.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfMonoFL.setPreferredSize(d);
        this.tfMonoFL.setText("Filter Position" + this.fltpos);
        this.monoPanel.add((Component)this.tfMonoFL, gbcMono);
        ++gbcMono.gridy;
        this.monoPanel.add((Component)lbMonoSW1, gbcMono);
        ++gbcMono.gridy;
        d = this.tfMonoSW1.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfMonoSW1.setPreferredSize(d);
        this.tfMonoSW1.setValue(0.0);
        this.tfMonoSW1.setEditable(false);
        this.monoPanel.add((Component)this.tfMonoSW1, gbcMono);
        ++gbcMono.gridy;
        this.monoPanel.add((Component)lbMonoSW2, gbcMono);
        ++gbcMono.gridy;
        d = this.tfMonoSW2.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfMonoSW2.setPreferredSize(d);
        this.tfMonoSW2.setValue(0.0);
        this.tfMonoSW2.setEditable(false);
        this.monoPanel.add((Component)this.tfMonoSW2, gbcMono);
        btMonoFL1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.fltpos = 1;
                TSGUI.this.tfMonoFL.setText(TSGUI.this.fltpos + ": " + TSGUI.this.Filter[TSGUI.this.fltpos - 1]);
                TSGUI.this.sendSyncTSCommand("Monochromator", "setFilter", TSGUI.this.fltpos);
            }
        });
        btMonoFL2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.fltpos = 2;
                TSGUI.this.tfMonoFL.setText(TSGUI.this.fltpos + ": " + TSGUI.this.Filter[TSGUI.this.fltpos - 1]);
                TSGUI.this.sendSyncTSCommand("Monochromator", "setFilter", TSGUI.this.fltpos);
            }
        });
        btMonoFL3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.fltpos = 3;
                TSGUI.this.tfMonoFL.setText(TSGUI.this.fltpos + ": " + TSGUI.this.Filter[TSGUI.this.fltpos - 1]);
                TSGUI.this.sendSyncTSCommand("Monochromator", "setFilter", TSGUI.this.fltpos);
            }
        });
        btMonoFL4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.fltpos = 4;
                TSGUI.this.tfMonoFL.setText(TSGUI.this.fltpos + ": " + TSGUI.this.Filter[TSGUI.this.fltpos - 1]);
                TSGUI.this.sendSyncTSCommand("Monochromator", "setFilter", TSGUI.this.fltpos);
            }
        });
        btMonoFL5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.fltpos = 5;
                TSGUI.this.tfMonoFL.setText(TSGUI.this.fltpos + ": " + TSGUI.this.Filter[TSGUI.this.fltpos - 1]);
                TSGUI.this.sendSyncTSCommand("Monochromator", "setFilter", TSGUI.this.fltpos);
            }
        });
        btMonoFL6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.fltpos = 6;
                TSGUI.this.tfMonoFL.setText(TSGUI.this.fltpos + ": " + TSGUI.this.Filter[TSGUI.this.fltpos - 1]);
                TSGUI.this.sendSyncTSCommand("Monochromator", "setFilter", TSGUI.this.fltpos);
            }
        });
        this.extPanel.setBorder(BorderFactory.createTitledBorder("Image & Config."));
        this.extPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcExt = new GridBagConstraints();
        gbcExt.insets = new Insets(4, 4, 4, 4);
        gbcExt.anchor = 11;
        gbcExt.gridx = 0;
        gbcExt.gridy = 0;
        this.initConfigs();
        this.extPanel.add((Component)lbext, gbcExt);
        ++gbcExt.gridy;
        btacqimage.setForeground(BLUE);
        btacqimage.setBackground(WHITE);
        this.extPanel.add((Component)btacqimage, gbcExt);
        btacqimage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TSGUI.this.sendSyncArchonCommand("setFitsFileDirectory", "/tmp/");
                TSGUI.this.sendSyncArchonCommand("exposeAcquireAndSaveImage", new Object[0]);
            }
        });
        ++gbcExt.gridy;
        btds9.setForeground(BLUE);
        btds9.setBackground(WHITE);
        this.extPanel.add((Component)btds9, gbcExt);
        btds9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] paths = null;
                Long highindex = -1L;
                try {
                    TSGUI.this.log.info("Getting list of available .fits files");
                    File f = new File("/tmp/");
                    TSGUI.this.log.info("The paths are: " + f.getAbsolutePath());
                    TSGUI.this.log.info("The list of all files is: " + f.list());
                    FilenameFilter fileNameFilter = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            int lastIndex;
                            String str;
                            TSGUI.this.log.info("fileNameFilter: dir=" + dir + " name=" + name);
                            return name.lastIndexOf(46) > 0 && (str = name.substring(lastIndex = name.lastIndexOf(46))).equals(".fits");
                        }
                    };
                    paths = f.list(fileNameFilter);
                }
                catch (Exception t) {
                    t.printStackTrace();
                }
                if (paths != null) {
                    DefaultListModel<void> listModel = new DefaultListModel<void>();
                    for (void var9_10 : paths) {
                        TSGUI.this.log.info((String)var9_10);
                        listModel.addElement(var9_10);
                        int istrt = var9_10.indexOf(95) + 1;
                        int iend = var9_10.indexOf(46);
                        String psub = var9_10.substring(istrt, iend);
                        Long index = Long.valueOf(psub);
                        if (index == null || index <= highindex) continue;
                        TSGUI.this.lastpath = var9_10;
                        highindex = index;
                    }
                    TSGUI.this.display("Last heart beat at - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(TSGUI.this.lastHeartBeat) + " Last image acquired = " + TSGUI.this.lastpath));
                    final JList pathList = new JList(listModel);
                    pathList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (!e.getValueIsAdjusting()) {
                                List selectedValuesList = pathList.getSelectedValuesList();
                                System.out.println(selectedValuesList);
                                TSGUI.this.lastpath = (String)selectedValuesList.get(0);
                                try {
                                    TSGUI.this.log.info("Executing: ds9 " + TSGUI.this.lastpath);
                                    Runtime.getRuntime().exec("ds9 -tile " + TSGUI.this.lastpath);
                                    TSGUI.this.pl.dispose();
                                }
                                catch (Exception g) {
                                    TSGUI.this.log.info("DS9 startup failed");
                                }
                            }
                        }
                    });
                    TSGUI.this.pl = new JFrame("Available FITs files");
                    TSGUI.this.pl.add(pathList);
                    TSGUI.this.pl.setDefaultCloseOperation(2);
                    TSGUI.this.pl.setTitle("Available FITs files");
                    TSGUI.this.pl.setSize(200, 200);
                    TSGUI.this.pl.setLocationRelativeTo(null);
                    TSGUI.this.pl.add(new JScrollPane(pathList));
                    pathList.setSelectionMode(0);
                    TSGUI.this.pl.setVisible(true);
                }
            }
        });
        ++gbcExt.gridy;
        this.extPanel.add((Component)lbconfig, gbcExt);
        ++gbcExt.gridy;
        this.extPanel.add((Component)btteststandcfg, gbcExt);
        btteststandcfg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] states = new String[TSConfig.operating_states.values().length];
                for (TSConfig.operating_states iwstate : TSConfig.operating_states.values()) {
                    states[iwstate.ordinal()] = iwstate.name();
                }
                if (states != null) {
                    DefaultListModel<String> listModel = new DefaultListModel<String>();
                    for (String state : states) {
                        listModel.addElement(state);
                    }
                    final JList stateList = new JList(listModel);
                    stateList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (!e.getValueIsAdjusting()) {
                                List selectedValuesList = stateList.getSelectedValuesList();
                                System.out.println(selectedValuesList);
                                String selectedstate = (String)selectedValuesList.get(0);
                                try {
                                    TSGUI.this.log.info("Switching to " + selectedstate);
                                    TSGUI.this.cfgstate = TSConfig.operating_states.valueOf((String)selectedstate).ordinal();
                                    TSGUI.this.initConfigs();
                                    TSGUI.this.plcfg.dispose();
                                }
                                catch (Exception g) {
                                    TSGUI.this.log.info("State change failed");
                                }
                            }
                        }
                    });
                    TSGUI.this.plcfg = new JFrame("Select a state:");
                    TSGUI.this.plcfg.add(stateList);
                    TSGUI.this.plcfg.setDefaultCloseOperation(2);
                    TSGUI.this.plcfg.setTitle("Config State");
                    TSGUI.this.plcfg.setSize(200, 200);
                    TSGUI.this.plcfg.setLocationRelativeTo(null);
                    TSGUI.this.plcfg.add(new JScrollPane(stateList));
                    stateList.setSelectionMode(0);
                    TSGUI.this.plcfg.setVisible(true);
                }
            }
        });
        ++gbcExt.gridy;
        btSaveConfig.setForeground(BLUE);
        btSaveConfig.setBackground(WHITE);
        this.extPanel.add((Component)btSaveConfig, gbcExt);
        btSaveConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String cmnd = "writeconfig";
                    TSGUI.this.log.info("invoking command - " + cmnd);
                    TSGUI.this.sendSyncTSCommand(null, cmnd, new Object[0]);
                }
                catch (Exception g) {
                    TSGUI.this.log.info("Failed to write configuration file!");
                }
            }
        });
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.panel.setBackground(new Color(40, 40, 60));
        this.panel.add((Component)this.teststandPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.bssPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.cryoPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.vacPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.panel.add((Component)this.monoPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.lmpPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.xedPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.extPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.anchor = 11;
        this.panel.add((Component)this.lbMessage, gbc);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JComponent getGuiLayout() {
        return this.panel;
    }

    public void resetGui() {
    }

    protected Object sendSyncArchonCommand(String name, Object ... params) {
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(archon_dest, name, params);
        try {
            return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(10000L));
        }
        catch (Exception e) {
            this.log.warning("Unable to perform jgroup communication with destination + archon - Exception " + e);
            return null;
        }
    }

    protected Object sendSyncTSCommand(String target, String name, Object ... params) {
        String dest = target == null ? this.teststand_dest : this.teststand_dest + "/" + target;
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(dest, name, params);
        System.out.println("teststand_dest = " + dest);
        try {
            return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(10000L));
        }
        catch (Exception e) {
            this.log.warning("Unable to perform jgroup communication with destination + " + this.teststand_dest + " - Exception " + e);
            return null;
        }
    }

    void updateConfig() {
        this.sendSyncTSCommand("Bias", "setrunbias", this.tfBiasVacq.getValue());
        this.sendSyncTSCommand("Cryo", "setruntemp", this.tfCryoTacq.getValue());
        this.sendSyncTSCommand("VacuumGauge", "setrunvac", this.tfVacPacq.getValue());
        this.sendSyncTSCommand("Monochromator", "setrunwave" + this.tfMonoWL.getValue(), new Object[0]);
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Failed to launch the link, your computer is likely misconfigured.", "Cannot Launch Link", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Java is not able to launch links on your computer.", "Cannot Launch Link", 2);
        }
    }

    static {
        typeMap.put("red", RED);
        typeMap.put("green", GREEN);
        typeMap.put("blue", BLUE);
        typeMap.put("yellow", YELLOW);
        typeMap.put("empty", WHITE);
        typeMap.put("RED", RED);
        typeMap.put("GREEN", GREEN);
        typeMap.put("BLUE", BLUE);
        typeMap.put("YELLOW", YELLOW);
        typeMap.put("EMPTY", WHITE);
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

