package org.lsst.ccs.subsystem.teststand.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.teststand.data.TSFullState;
import org.lsst.ccs.subsystem.teststand.data.TSState;

/**
 *  Implements the teststand control panel / monitor panel assembly.
 *
 *  @author Owen Saxton
 */
public class TSMonitorAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    TSMonitorPanel panel;
    
    public TSMonitorAssembly(TSMonitorGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
        panel = new TSMonitorPanel(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystem(String name) {
        mon.setSubsystems(name);
        panel.setSubsystem(name);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem(id);
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof TSFullState) {
            TSFullState r = (TSFullState)d;
            mon.updateTableModel(name, r.getMonitorFullState());
            panel.updateControlPanel(id, r.getTSState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key,
                                 Object d) {
        if (key.equals(TSState.KEY)) {
            panel.updateControlPanel(id, (TSState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
