package org.lsst.ccs.subsystem.teststand.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
//import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

/**
 *
 * @author The LSST CCS Team
 */
public class TSConfigurableSubsystemMainPanel extends JPanel {

    private static final long serialVersionUID = 1L;
//    private static final String[] COMPONENT_NAMES = {"IDLE","READY","TEST","ACQ1","WARM"};
    private static final Map<String, TSConfigurablePanel> panelMap = new TreeMap<>();
    private static AgentMessagingLayer agentMessagingLayer;
    private final JLabel descriptionNameLbl = new JLabel();
    private static String teststand_dest = "ts";
    private static final Logger LOGGER = Logger.getLogger("org.lsst.ccs.subsystem.teststand.ui.TSGUI");

    static {
        for (String componentName : TSConfig.COMPONENT_NAMES) {
            panelMap.put(componentName, new TSConfigurablePanel(componentName));
        }
    }

    public TSConfigurableSubsystemMainPanel(AgentMessagingLayer aml, String DEST) {
        agentMessagingLayer = aml;
        teststand_dest = DEST;
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(descriptionNameLbl);
        for (TSConfigurablePanel panel : panelMap.values()) {
            add(panel);
        }
//        teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");

    }

    public void updateWithConfigInfo(ConfigurationInfo configurationInfo) {
        for (Map.Entry<String, TSConfigurablePanel> entry : panelMap.entrySet()) {
            Map<String, String> configForComponent = configurationInfo.getCurrentValuesFor(entry.getKey());
            if (!configForComponent.isEmpty()) {
                entry.getValue().updateWithConfigInfo(configForComponent);
            }
        }
    }

    public void setDescriptionName(String descriptionName) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                descriptionNameLbl.setText(descriptionName);
            }
        });
    }

    private static class TSConfigurablePanel extends JPanel {

        private static final long serialVersionUID = 1L;
        private final String componentName;
        private final JLabel stateLbl = new JLabel();
//        private final JLabel biasLbl = new JLabel();
        private final JFormattedTextField biasLbl = new JFormattedTextField();
//        private final JLabel cryoLbl = new JLabel();
        private final JFormattedTextField cryoLbl = new JFormattedTextField();
//        private final JLabel cryotolLbl = new JLabel();
        private final JFormattedTextField cryotolLbl = new JFormattedTextField();
        private final JLabel minlmpLbl = new JLabel();
        private final JLabel maxvacLbl = new JLabel();
        private final JLabel lambdaLbl = new JLabel();
        private static final JButton btsavechanges = new JButton("Save Changes");

        private TSConfigurablePanel(String componentName) {
            super(new GridBagLayout());
            this.componentName = componentName;
            setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = GridBagConstraints.WEST;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0;
            gbc.weighty = 0;
            gbc.fill = GridBagConstraints.NONE;

            /*
             filters empty:blue:green:empty:empty:empty
             filteredges 0.:200.:560.:0.:0.:0.
             pdtype KEITHLEY-INSTRUMENTS-INC.,MODEL-6487
             biastype KEITHLEY-INSTRUMENTS-INC.,MODEL-6487
             srctype Newport-Xenon-Arc-Lamp
             monotype Cornerstone260

             state IDLE
             bias 0.
             cryo -95.
             vac 1000.
             lambda 500.
             minlmppwr 0.
             cryotol 200.

             state READY
             */
            add(new JLabel("State : "), gbc);

            gbc.gridy = 1;
            add(new JLabel("Backplane BIAS target : "), gbc);

            gbc.gridy = 2;
            add(new JLabel("Temperature target : "), gbc);

            gbc.gridy = 3;
            add(new JLabel("temperature tolerence : "), gbc);

            gbc.gridy = 4;
            add(new JLabel("minimum lamp power : "), gbc);

            gbc.gridy = 5;
            add(new JLabel("Vacuum upper limit : "), gbc);

            gbc.gridy = 6;
            add(new JLabel("default wavelength : "), gbc);

            gbc.gridy = 8;
            add(btsavechanges, gbc);
            btsavechanges.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncTSCommand(null, "saveAllChanges");
                }
            });

            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1;
            add(stateLbl, gbc);

            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            add(biasLbl, gbc);

            gbc.gridy = 2;
            gbc.gridwidth = 1;
            add(cryoLbl, gbc);

            gbc.gridy = 3;
            gbc.gridwidth = 1;
            add(cryotolLbl, gbc);

            gbc.gridy = 4;
            add(minlmpLbl, gbc);

            gbc.gridy = 5;
            add(maxvacLbl, gbc);

            gbc.gridy = 6;
            add(lambdaLbl, gbc);

            biasLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncTSCommand(componentName, "change", "bias", biasLbl.getText());
                    try {
                        sendSyncTSCommand(null, "setCfgBiasVAcq", Double.parseDouble(biasLbl.getText()), TSConfig.operating_states.valueOf(componentName).ordinal());
                    } catch (Exception ex) {
                        System.out.println("Failed to execute setrunbias");
                    }
                }
            });
            cryoLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncTSCommand(componentName, "change", "cryo", cryoLbl.getText());
                    try {
                        sendSyncTSCommand(null, "setCfgCryoTAcq", Double.valueOf(cryoLbl.getText()), TSConfig.operating_states.valueOf(componentName).ordinal());
                    } catch (Exception ex) {
                        System.out.println("Failed to execute setRunTemp");
                    }
                }
            });
            cryotolLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncTSCommand(componentName, "change", "cryotol", cryotolLbl.getText());
//                  sendSyncTSCommand("Cryo", "setRunTemptol", Double.valueOf(cryotolLbl.getText()), TSConfig.operating_states.valueOf(componentName));
                }
            }
            );

        }

        private void updateWithConfigInfo(Map<String, String> configForComponent) {
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    stateLbl.setText(configForComponent.get("state"));
                    biasLbl.setText(configForComponent.get("bias"));
                    Dimension d = biasLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    biasLbl.setPreferredSize(d);

                    cryoLbl.setText(configForComponent.get("cryo"));
                    d = cryoLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    cryoLbl.setPreferredSize(d);

                    cryotolLbl.setText(configForComponent.get("cryotol"));
                    d = cryotolLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    cryotolLbl.setPreferredSize(d);

                    minlmpLbl.setText(configForComponent.get("minlmppwr"));
                    d = minlmpLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    minlmpLbl.setPreferredSize(d);

                    maxvacLbl.setText(configForComponent.get("vac"));
                    d = maxvacLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    maxvacLbl.setPreferredSize(d);

                    lambdaLbl.setText(configForComponent.get("lambda"));
                    d = lambdaLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    lambdaLbl.setPreferredSize(d);

//                    Map<String, Integer> currentMap = (Map<String, Integer>) Constraints.check("java.util.Map", configForComponent.get(componentName+"//currentParms"), null);
//                    Lbl.setText(String.valueOf(currentMap.get("continuousLimit")));
//                    outputLimitLbl.setText(String.valueOf(currentMap.get("outputLimit")));
//                    maxSpeedLbl.setText(String.valueOf(currentMap.get("maxSpeed")));
                }
            });
        }

        protected Object sendSyncTSCommand(String target, String name, Object... params) {
            String dest = target == null ? teststand_dest : teststand_dest + "/" + target;

            ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
            CommandRequest cmd = new CommandRequest(dest, name, params);
            System.out.println("teststand_dest = " + dest);
            try {
                return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(10000));
            } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
                LOGGER.warning("Unable to perform jgroup communication with destination + "
                        + teststand_dest + " - Exception " + e);
                return null;
            }
        }
    }

}
