/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

public class TSConfigurableSubsystemMainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Map<String, TSConfigurablePanel> panelMap = new TreeMap<String, TSConfigurablePanel>();
    private static AgentMessagingLayer agentMessagingLayer;
    private final JLabel descriptionNameLbl = new JLabel();
    private static String teststand_dest;
    private static final Logger LOGGER;

    public TSConfigurableSubsystemMainPanel(AgentMessagingLayer aml, String DEST) {
        agentMessagingLayer = aml;
        teststand_dest = DEST;
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.descriptionNameLbl);
        for (TSConfigurablePanel panel : panelMap.values()) {
            this.add(panel);
        }
    }

    public void updateWithConfigInfo(ConfigurationInfo configurationInfo) {
        for (Map.Entry<String, TSConfigurablePanel> entry : panelMap.entrySet()) {
            Map configForComponent = configurationInfo.getCurrentValuesFor(entry.getKey());
            if (configForComponent.isEmpty()) continue;
            entry.getValue().updateWithConfigInfo(configForComponent);
        }
    }

    public void setDescriptionName(final String descriptionName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TSConfigurableSubsystemMainPanel.this.descriptionNameLbl.setText(descriptionName);
            }
        });
    }

    static {
        teststand_dest = "ts";
        LOGGER = Logger.getLogger("org.lsst.ccs.subsystem.teststand.ui.TSGUI");
        for (String componentName : TSConfig.COMPONENT_NAMES) {
            panelMap.put(componentName, new TSConfigurablePanel(componentName));
        }
    }

    private static class TSConfigurablePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final String componentName;
        private final JLabel stateLbl = new JLabel();
        private final JFormattedTextField biasLbl = new JFormattedTextField();
        private final JFormattedTextField cryoLbl = new JFormattedTextField();
        private final JFormattedTextField cryotolLbl = new JFormattedTextField();
        private final JLabel minlmpLbl = new JLabel();
        private final JLabel maxvacLbl = new JLabel();
        private final JLabel lambdaLbl = new JLabel();
        private static final JButton btsavechanges = new JButton("Save Changes");

        private TSConfigurablePanel(final String componentName) {
            super(new GridBagLayout());
            this.componentName = componentName;
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            this.add((Component)new JLabel("State : "), gbc);
            gbc.gridy = 1;
            this.add((Component)new JLabel("Backplane BIAS target : "), gbc);
            gbc.gridy = 2;
            this.add((Component)new JLabel("Temperature target : "), gbc);
            gbc.gridy = 3;
            this.add((Component)new JLabel("temperature tolerence : "), gbc);
            gbc.gridy = 4;
            this.add((Component)new JLabel("minimum lamp power : "), gbc);
            gbc.gridy = 5;
            this.add((Component)new JLabel("Vacuum upper limit : "), gbc);
            gbc.gridy = 6;
            this.add((Component)new JLabel("default wavelength : "), gbc);
            gbc.gridy = 8;
            this.add((Component)btsavechanges, gbc);
            btsavechanges.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncTSCommand(null, "saveAllChanges", new Object[0]);
                }
            });
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            this.add((Component)this.stateLbl, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            this.add((Component)this.biasLbl, gbc);
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            this.add((Component)this.cryoLbl, gbc);
            gbc.gridy = 3;
            gbc.gridwidth = 1;
            this.add((Component)this.cryotolLbl, gbc);
            gbc.gridy = 4;
            this.add((Component)this.minlmpLbl, gbc);
            gbc.gridy = 5;
            this.add((Component)this.maxvacLbl, gbc);
            gbc.gridy = 6;
            this.add((Component)this.lambdaLbl, gbc);
            this.biasLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncTSCommand(componentName, "change", "bias", biasLbl.getText());
                    try {
                        this.sendSyncTSCommand(null, "setCfgBiasVAcq", Double.parseDouble(biasLbl.getText()), TSConfig.operating_states.valueOf(componentName).ordinal());
                    }
                    catch (Exception ex) {
                        System.out.println("Failed to execute setrunbias");
                    }
                }
            });
            this.cryoLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncTSCommand(componentName, "change", "cryo", cryoLbl.getText());
                    try {
                        this.sendSyncTSCommand(null, "setCfgCryoTAcq", Double.valueOf(cryoLbl.getText()), TSConfig.operating_states.valueOf(componentName).ordinal());
                    }
                    catch (Exception ex) {
                        System.out.println("Failed to execute setRunTemp");
                    }
                }
            });
            this.cryotolLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncTSCommand(componentName, "change", "cryotol", cryotolLbl.getText());
                }
            });
        }

        private void updateWithConfigInfo(final Map<String, String> configForComponent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    stateLbl.setText((String)configForComponent.get("state"));
                    biasLbl.setText((String)configForComponent.get("bias"));
                    Dimension d = biasLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    biasLbl.setPreferredSize(d);
                    cryoLbl.setText((String)configForComponent.get("cryo"));
                    d = cryoLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    cryoLbl.setPreferredSize(d);
                    cryotolLbl.setText((String)configForComponent.get("cryotol"));
                    d = cryotolLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    cryotolLbl.setPreferredSize(d);
                    minlmpLbl.setText((String)configForComponent.get("minlmppwr"));
                    d = minlmpLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    minlmpLbl.setPreferredSize(d);
                    maxvacLbl.setText((String)configForComponent.get("vac"));
                    d = maxvacLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    maxvacLbl.setPreferredSize(d);
                    lambdaLbl.setText((String)configForComponent.get("lambda"));
                    d = lambdaLbl.getPreferredSize();
                    d.width = 100;
                    d.height = 30;
                    lambdaLbl.setPreferredSize(d);
                }
            });
        }

        protected Object sendSyncTSCommand(String target, String name, Object ... params) {
            String dest = target == null ? teststand_dest : teststand_dest + "/" + target;
            ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
            CommandRequest cmd = new CommandRequest(dest, name, params);
            System.out.println("teststand_dest = " + dest);
            try {
                return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(10000L));
            }
            catch (Exception e) {
                LOGGER.warning("Unable to perform jgroup communication with destination + " + teststand_dest + " - Exception " + e);
                return null;
            }
        }
    }
}

