/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.plugins.alert.AlertListener;
import org.lsst.ccs.gconsole.plugins.alert.AlertService;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;

public class AlertHandler
implements AlertService {
    private final org.lsst.ccs.services.alert.AlertService alertService;

    public AlertHandler(LsstAlertPlugin plugin) {
        this.alertService = plugin.getConsole().getAlertService();
    }

    @Override
    public synchronized void submitAlert(String source, Alert alert, AlertState level, String cause) {
        if (source == null || source.isEmpty()) {
            source = "Local";
        } else if (!source.startsWith("Local")) {
            source = "Local : " + source;
        }
        if (level == AlertState.NOMINAL) {
            RaisedAlertSummary summary = this.alertService.getSummary(source);
            if (summary == null || summary.getRaisedAlert(alert.getAlertId()) == null) {
                return;
            }
            this.alertService.clearAlertsForSource(source, new String[]{alert.getAlertId()});
        } else {
            this.alertService.raiseAlert(source, alert, level, cause);
        }
    }

    @Override
    public void addListener(AlertListener listener) {
        this.alertService.addListener((org.lsst.ccs.services.alert.AlertListener)listener);
    }

    @Override
    public void removeListener(AlertListener listener) {
        this.alertService.removeListener((org.lsst.ccs.services.alert.AlertListener)listener);
    }

    @Override
    public RaisedAlertSummary getSummary(String source) {
        return this.alertService.getSummary(source);
    }
}

