/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent;

import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

public class AgentChannelState {
    private int state;

    public AgentChannelState(int state) {
        this.state = state;
    }

    public AgentChannelState(boolean isGood, boolean isOnline, boolean isLowLimitChange, boolean isHighLimitChange) {
        this.state = isGood ? 1 : 0;
        this.state <<= 1;
        this.state |= isOnline ? 1 : 0;
        this.state <<= 1;
        this.state |= isLowLimitChange ? 1 : 0;
        this.state <<= 1;
        this.state |= isHighLimitChange ? 1 : 0;
    }

    public boolean isGood() {
        return (this.state & 8) > 0;
    }

    public boolean isOnline() {
        return (this.state & 4) > 0;
    }

    public boolean isLowLimitChange() {
        return (this.state & 2) > 0;
    }

    public boolean isHighLimitChange() {
        return (this.state & 1) > 0;
    }

    static AgentChannelState packMonitorState(MonitorState ms, int channel) {
        return new AgentChannelState(ms.getGoodChans().get(channel), ms.getOnlineChans().get(channel), ms.getLowLimitChange().get(channel), ms.getHighLimitChange().get(channel));
    }

    static AgentChannelState merge(AgentChannelState state, DataProviderState channelState) {
        return new AgentChannelState(channelState == DataProviderState.NOMINAL, channelState != DataProviderState.OFF_LINE, state != null && state.isLowLimitChange(), state != null && state.isHighLimitChange());
    }

    static AgentChannelState merge(AgentChannelState state, boolean isLowLimitChange, boolean isHighLimitChange) {
        return new AgentChannelState(state == null || state.isGood(), state == null || state.isOnline(), isLowLimitChange, isHighLimitChange);
    }

    static boolean isGood(int flag) {
        return (flag & 8) > 0;
    }

    static boolean isOnline(int flag) {
        return (flag & 4) > 0;
    }

    static boolean isLowLimitChange(int flag) {
        return (flag & 2) > 0;
    }

    static boolean isHighLimitChange(int flag) {
        return (flag & 1) > 0;
    }
}

