package org.lsst.ccs.subsystem.teststand.ui.jas;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.filter.GenericFilter;

/**
 * Teststand monitoring filter.
 *
 * @author The LSST CCS Team
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Teststand monitor filter",
               path="Subsystems/Teststand/Monitor",
               description="Teststand subsystem monitor filter.")
public class TeststandMonitorFilter extends GenericFilter {


// -- Life cycle : -------------------------------------------------------------
    
    public TeststandMonitorFilter(String agents) {
        super("Teststand",agents,"/main/,/state/", "", true, "");
    }

    
    @Override
    public List<String> getDisplayPath(String originPath) {
        int i1 = originPath.indexOf("/");
        int i2 = originPath.indexOf("/", i1+1);
        if (i1 == -1 || i2 == -1) return Collections.emptyList();
        String displayPath = originPath.substring(i1 + 1, i2) +"//"+ originPath.substring(i2 + 1);
        return Collections.singletonList(displayPath);
    }
           
}
