package org.lsst.ccs.subsystem.teststand.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;

/**
 *
 * @author homer
 */
@Plugin(name = "TestStand new plugin", description = "Displays monitor tables for test stands")
public class TSMonitorPluginNew extends ConsolePlugin {

    private final OptionalPage teststandOptionalPage = new TSMonitorPluginNew.TestStandOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().addOptionalPage(teststandOptionalPage);
    }

    static class TestStandOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPath() {
            return "CCS Subsystems/TeststandNew";
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY) != null) {
                return agent.getName();
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TabbedView view = new TabbedView();
            TeststandMonitorFilter filter = new TeststandMonitorFilter(agent.getName());
            view.setFilter(filter);
            view.install();
            return view.getPanel();
        }

    }
}
