package org.lsst.ccs.subsystem.teststand.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.subsystem.teststand.ui.TSMonitorGui;

/**
 *
 * @author homer
 */
@Plugin(name="TestStand plugin", description="Displays monitor tables for test stands")
public class TSMonitorPlugin extends ConsolePlugin {

    private final OptionalPage teststandOptionalPage = new TSMonitorPlugin.TestStandOptionalPage();

    @Override
    public void initialize() {        
        Console.getConsole().addOptionalPage(teststandOptionalPage);
    }
    
    static class TestStandOptionalPage implements OptionalPage {

        @Override
        public String getPath() {
            return "CCS Subsystems/Teststand";
        }

        @Override
        public boolean isAutoOpen() {
            return true;
        }

        @Override
        public String getPage(AgentInfo agent) {
            if ( agent.getAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY) != null ) {
                return agent.getName();
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TSMonitorGui gui = new TSMonitorGui(agent.getName());
            gui.initGui();
            return gui.getGuiLayout();
        }

    }
}
