package org.lsst.ccs.subsystem.teststand.ui;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import java.io.IOException;
import java.io.FilenameFilter;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Toolkit;

import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
//import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;

import org.lsst.ccs.subsystem.teststand.data.TSFullState;
import org.lsst.ccs.subsystem.teststand.data.TSState;

import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

/**
 ***************************************************************************
 **
 ** GUI for the teststand subsystem
 *
 * @author Homer Neal
 * **************************************************************************
 */
public class TSGUI implements StatusMessageListener, AgentPresenceListener {

    private String teststand_dest = "ts2";
//    private PrintWriter out = new PrintWriter(System.out, true);
    private MonitorTrendingTable table;
    private long lastHeartBeat = 0, lastStateRequest = 0;
    private boolean enabled = false;
//    String stateCorrelId;

    private static final long serialVersionUID = -8352262068369045572L;
    private static final Map<Integer, String> pStateMap = new HashMap<>();

    private static final String NB_SPACE = "\u00a0";

    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    final static Font f = new java.awt.Font("Tahoma", 1, 14);
    final static Font bigf = new java.awt.Font("Tahoma", 1, 16);

    private static final JLabel lbteststand = new JLabel("Subsystem Status");
    private static final JLabel lbteststandstate = new JLabel("STATE");
    private static final JLabel lbteststanderr = new JLabel("ERRORS");
    private static final JButton btteststandcfg = new JButton("IDLE");
    private static final JButton btteststandabrt = new JButton("ABORT ACQ!");
    private static final JLabel lbteststandacqtyp = new JLabel("ACQ TYPE");

    private static final JLabel lbBias = new JLabel("Bias/PD");
    private static final JLabel lbBiasState = new JLabel("State");
    private static final JLabel lbBiasV = new JLabel("Bias V/I");
    private static final JLabel lbPDI = new JLabel("PD I");
    private static final JLabel lbBiasVacq = new JLabel("Acq. BiasV Set Point");

    private static final JLabel lbCryo = new JLabel("Cryogenics");
    private static final JLabel lbCryoState = new JLabel("State");
    private static final JLabel lbCryoTemp = new JLabel("Temperature (C)");
    private static final JLabel lbCryoTacq = new JLabel("Acq. CryoT Set Point");

    private static final JLabel lbVac = new JLabel("Vacuum");
    private static final JLabel lbVacState = new JLabel("State");
    private static final JLabel lbVacPres = new JLabel("Pressure (Torr)");
    private static final JLabel lbVacPacq = new JLabel("Acq. Vac Set Point");

    private static final JLabel lbLmp = new JLabel("Lamp");
    private static final JLabel lbLmpState = new JLabel("State");
    private static final JLabel lbLmpCurr = new JLabel("Power (Watts)");

    private static final JLabel lbXED = new JLabel("XED");
    private static final JLabel lbXEDState = new JLabel("State");

    private static final JLabel lbMono = new JLabel("MonoChromator");
    private static final JLabel lbMonoState = new JLabel("State");
    private static final JLabel lbMonoWL = new JLabel("Wavelength (nm)");
    private static final JLabel lbMonoSW1 = new JLabel("Slit1 Size (um)");
    private static final JLabel lbMonoSW2 = new JLabel("Slit2 Size (um)");
    private static final JLabel lbMonoFL = new JLabel("Filter");
    private static final JButton btMonoSH = new JButton("shutter");
    private static final JButton btMonoFL1 = new JButton("position 1");
    private static final JButton btMonoFL2 = new JButton("position 2");
    private static final JButton btMonoFL3 = new JButton("position 3");
    private static final JButton btMonoFL4 = new JButton("position 4");
    private static final JButton btMonoFL5 = new JButton("position 5");
    private static final JButton btMonoFL6 = new JButton("position 6");
    private static final JButton btacqimage = new JButton("acquire");
    private static final JButton btds9 = new JButton("view");
    private static final JButton btetrv = new JButton("eTraveler");

    private static final JLabel lbSens = new JLabel("Sensor Controller");
    private static final JLabel lbSensState = new JLabel("State");
    private static final JLabel lbSensCT = new JLabel("#images");

    private static final JLabel lbext = new JLabel("Image Functions");

    private static final JLabel lbconfig = new JLabel("Configuration");

    private static final JButton btSaveConfig = new JButton("Save Config");

    final private JLabel lbMessage = new JLabel(NB_SPACE);
//    private SynchronousCommandAgent ca;
    final private JPanel panel = new JPanel();
    final private JPanel teststandPanel = new JPanel();
    final private JPanel bssPanel = new JPanel();
    final private JPanel cryoPanel = new JPanel();
    final private JPanel vacPanel = new JPanel();
    final private JPanel lmpPanel = new JPanel();
    final private JPanel xedPanel = new JPanel();
    final private JPanel monoPanel = new JPanel();
    final private JPanel extPanel = new JPanel();

    final private NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
    final private NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.##"));
    final private NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.####E00"));
    final private JFormattedTextField tfState = new JFormattedTextField();
    final private JFormattedTextField tfErr = new JFormattedTextField();
    final private JFormattedTextField tfAcqTyp = new JFormattedTextField();
    final private JFormattedTextField tfBiasState = new JFormattedTextField();
    final private JFormattedTextField tfBiasV = new JFormattedTextField();
//    final private JFormattedTextField tfBiasV = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfBiasVacq = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfPDI = new JFormattedTextField(fmt5e);
    final private JFormattedTextField tfCryoState = new JFormattedTextField();
//    final private JFormattedTextField tfCryoTemp = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfCryoTemp = new JFormattedTextField();
    final private JFormattedTextField tfCryoTacq = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfVacState = new JFormattedTextField();
    final private JFormattedTextField tfVacP = new JFormattedTextField(fmt5e);
    final private JFormattedTextField tfLmpState = new JFormattedTextField();
    final private JFormattedTextField tfLmpC = new JFormattedTextField(fmt5);
    final private JFormattedTextField tfXEDState = new JFormattedTextField();
    final private JFormattedTextField tfMonoState = new JFormattedTextField();
    final private JFormattedTextField tfMonoWL = new JFormattedTextField(fmt5);
    final private JFormattedTextField tfMonoSW1 = new JFormattedTextField(fmt5);
    final private JFormattedTextField tfMonoSW2 = new JFormattedTextField(fmt5);
    final private JFormattedTextField tfMonoFL = new JFormattedTextField();
    final private JFormattedTextField tfVacPacq = new JFormattedTextField(fmt5e);
    final private JFormattedTextField tfR = new JFormattedTextField(fmt5);

    private static final String archon_dest = "archon";

//    private final SynchronousCommandAgent ca;
    //  = new SynchronousCommandAgent(fac);
//    private final MonitorAssembly mon;
    final static Color RED = new Color(150, 0, 0), GREEN = new Color(0, 150, 0),
            BLUE = new Color(0, 0, 150), WHITE = new Color(150, 150, 150),
            YELLOW = new Color(200, 200, 0),
            BLACK = new Color(0, 0, 0), GREY = new Color(80, 80, 80);

    private final static Map<String, Color> typeMap = new HashMap<>();

    private JFrame pl = null;
    private JFrame plcfg = null;

    static {
        typeMap.put("red", RED);
        typeMap.put("green", GREEN);
        typeMap.put("blue", BLUE);
        typeMap.put("yellow", YELLOW);
        typeMap.put("empty", WHITE);
        typeMap.put("RED", RED);
        typeMap.put("GREEN", GREEN);
        typeMap.put("BLUE", BLUE);
        typeMap.put("YELLOW", YELLOW);
        typeMap.put("EMPTY", WHITE);
    }

    public enum onOff {

        OFF, ON;
    }

    private int cfgstate = TSConfig.operating_states.IDLE.ordinal();

    Integer fltpos = 1;
    boolean shstate = false;
    String lastpath = "";

    String[] Filter = {"blue", "white", "red", "white", "green", "yellow"};

    private final AgentMessagingLayer agentMessagingLayer;
    private final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.teststand.ui.TSGUI");

    /**
     ***************************************************************************
     **
     ** Constructor *
     * **************************************************************************
     */
    public TSGUI(AgentMessagingLayer agentMessagingLayer) {
        System.out.println("TSGUI: Retrieving teststand name on the bus from property lsst.ccs.teststand.tsguidest");
        teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.agentMessagingLayer = agentMessagingLayer;
//        mon = new MonitorAssembly(this);
    }

    public void main(String[] args) throws ClassNotFoundException {
        System.out.println("starting TSGUI main");

        teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");

        initGui();
        System.out.println("past initGui");

        JPanel xpane = new JPanel();
        xpane.setLayout(new BorderLayout());
        xpane.add(getPanel(), BorderLayout.CENTER);

        final JFrame f = new JFrame("Test Stand Console");
        f.setContentPane(xpane);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        f.pack();
        f.setVisible(true);

    }

    public void initGui() {
        System.out.println("initGui: Retrieving teststand name on the bus from property lsst.ccs.teststand.tsguidest");
        teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        System.out.println("teststand_dest = " + teststand_dest);
//        mon.setSubsystems(teststand_dest);

        initComponents();

//        table = new MonitorTrendingTable(this);
//        agentMessagingLayer.addStatusMessageListener(guiStatusListener);
        // register ourselves as a status listener of StatusSubsystemData coming from teststand_dest only
//        BusMessageFilter filterConfig = BusMessageFilter.messageOrigin(teststand_dest).and(BusMessageFilter.messageClass(StatusConfigurationInfo.class));
        agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener(this);
        Predicate<BusMessage<? extends Serializable, ?>> filter = BusMessageFilterFactory.messageOrigin(teststand_dest).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        agentMessagingLayer.addStatusMessageListener(this, filter);

    }

    @Override
    public void connecting(AgentInfo agent) {
        //Initialize the GUI when the teststand subsystem connects to the buses
        if (agent.getName().equals(teststand_dest)) {
            initConfigs();
        }
    }

    @Override
    public void disconnecting(AgentInfo agent) {
        //Put code here to reset the GUI when the teststand subsystem disconnects from the buses
    }

    private CommandOriginator getCommandOriginator() {
        CommandOriginator originator = new CommandOriginator() {

            @Override
            public void processAck(CommandAck ack) {
            }

            /*
            @Override
            public void processError(CommandError nack) {
            }
             */
            @Override
            public void processNack(CommandNack nack) {
            }

            @Override
            public void processResult(CommandResult result) {
                TSFullState r = (TSFullState) result.getReply();
                log.fine("TSGUI received TSFullState reply");
                UpdateTSStatus(r.getTSState());
//        panel.updateTime();
                enabled = true;
            }

        };
        return originator;
    }

    /*
    @Override
    public String sendCommand(String dest, String target, String cmnd,
            Object... args) {
        String dst = (dest == null ? teststand_dest : dest)
                + (target == null ? "" : "/" + target);
        CommandRequest cmd = new CommandRequest(dst, cmnd, args);
        agentMessagingLayer.sendCommandRequest(cmd, getCommandOriginator());
        return cmd.getCorrelId();
    }
     */
//    public void sendCommandx(String dest, String target, String cmnd,
//            Object... args) {
//        stateCorrelId = sendCommand(dest, target, cmnd,
//                args);
//    }
//    @Override
//    public void sendCommand(String target, Command cmd) {
//        String dest = target == null ? teststand_dest : teststand_dest + "/" + target;
//        cmd.setDestination(dest);
////        Command cmd = new ModuleInvokerCommand("", 0, dest, cmnd, args);
//        updateCurrentSubsystem();
//        fac.sendCommand(cmd);
//        stateCorrelId = cmd.getCorrelId();
//    }
    public void UpdateTSStatus(TSState rs) {
//        System.out.println("UpdateTSStatus called");
        if (rs != null) {
            int st = rs.getSystemState();

            tfState.setText(TSConfig.operating_states.values()[rs.getOperState()].name());
            /* 
             boolean t_on = (st & TSState.READY) != 0;
             tfState.setText(t_on ? "READY" : "IDLE");
             tfState.setEditable(false);

             if ((st & TSState.ACQ1) != 0) {
             tfState.setText("ACQ1");
             }
             if ((st & TSState.ACQ2) != 0) {
             tfState.setText("ACQ2");
             }
             */
            if ((st & TSState.READY) != 0) {
                tfState.setForeground(GREEN);
            } else {
                tfState.setForeground(BLACK);
            }

            String acqtyp = (String) sendSyncArchonCommand("getLastTestType");

            if (acqtyp != null) {
                if (!acqtyp.isEmpty()) {
                    tfAcqTyp.setText(acqtyp);
                }
            }

            String strerr = "unknown";
            Color colbkg = panel.getBackground();
            if ((st & TSState.READY) != 0) {
                strerr = "READY";
                tfErr.setForeground(Color.BLACK);

            }
            if ((st & (TSState.PWRDEVC_TRIPPED | TSState.CRYODEVC_TRIPPED | TSState.VACDEVC_TRIPPED)) != 0) {
                strerr = "TRIPPED";
                toolkit.beep();
                panel.setBackground(Color.RED);
                try {
                    Thread.sleep(1000);
                    toolkit.beep();
                    panel.setBackground(colbkg);
                    panel.setBackground(Color.RED);
                    toolkit.beep();
                    Thread.sleep(1000);
                } catch (InterruptedException ex) {
                    System.out.println("sleep interrupted!");
                }
                panel.setBackground(colbkg);
                panel.setBackground(Color.RED);
                tfErr.setForeground(Color.RED);
            }
            if ((st & (TSState.CRYO_DEV_WARNING | TSState.VAC_DEV_WARNING)) != 0) {
                strerr = "WARNING";
                toolkit.beep();
                panel.setBackground(Color.MAGENTA);
                tfErr.setForeground(Color.MAGENTA);

                try {
                    Thread.sleep(1000);
                } catch (InterruptedException ex) {
                    log.info("sleep interrupted");
                }
            }
            panel.setBackground(colbkg);
            panel.repaint();
            tfErr.setEditable(false);

            if ((st & TSState.PWRDEVC_TRIPPED) != 0) {
                tfBiasState.setText("TRIPPED");
                tfBiasState.setForeground(RED);
                tfBiasState.repaint();
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException ex) {
                    Logger.getLogger(TSGUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                tfBiasState.setText("OK");
                tfBiasState.setForeground(GREEN);

            }
            double bias = rs.getVolts();
            double bias_curr = rs.getBIAS_curr();
            tfBiasV.setValue(String.valueOf(bias) + "/" + String.format("%6.1e", bias_curr));
            tfBiasV.setEditable(false);
            Color biasbgclr = Color.GREEN;
            if (bias > -20.) {
                biasbgclr = Color.PINK;
            }
            if ((st & TSState.PWRDEVC_ON) == 0) {
                biasbgclr = Color.GRAY;
            }
            lbBiasV.setBackground(biasbgclr);
            lbBiasV.repaint();

            double curr = rs.getCurr();
            tfPDI.setValue(curr);
            tfPDI.setEditable(false);
            Color pdbgclr = Color.GREEN;
            if (Math.abs(curr) > 0.1) {
                pdbgclr = Color.PINK;
            }
            if ((st & TSState.PDDEVC_ON) == 0) {
                pdbgclr = Color.RED;
            }
            lbPDI.setBackground(pdbgclr);
            lbPDI.repaint();

            boolean c_on = (st & TSState.CRYODEVC_ON) != 0;
            tfCryoState.setText(c_on ? "OK" : "OFF");
            tfCryoState.setForeground(((st & TSState.CRYODEVC_ON) != 0) ? GREEN : RED);
            tfCryoState.setEditable(false);
            double temp  = rs.getTemp();
            double temp2 = rs.getTemp2();
            Color cryobgclr = Color.GREEN;
            if (temp > -80. && temp2 > -80.) {
                cryobgclr = Color.PINK;
            }
            if ((st & TSState.CRYODEVC_ON) == 0) {
                cryobgclr = Color.GRAY;
            }
            lbCryo.setBackground(cryobgclr);
            lbCryo.repaint();
            tfCryoTemp.setValue(String.format("%5.1f", temp) + "/" + String.format("%5.1f", temp2));

            tfCryoTemp.setEditable(false);

            boolean v_on = (st & (TSState.VACDEVC_ON | TSState.VQMDEVC_ON)) != 0;
            tfVacState.setText(v_on ? "OK" : "OFF");
            tfVacState.setForeground(((st & (TSState.VACDEVC_ON | TSState.VQMDEVC_ON)) != 0) ? GREEN : RED);
            tfVacState.setEditable(false);
            double pres = -999.0;
            if (rs.getVac()>0.) pres = rs.getVac();
            if (pres<=0.) pres = rs.getVac2();
            Color vacbgclr = Color.GREEN;
            if (pres > 1.e-5) {
                vacbgclr = Color.PINK;
            }
            if ((st & TSState.VACDEVC_ON) == 0 && pres < 0.) {
                vacbgclr = Color.RED;
            }
            lbVac.setBackground(vacbgclr);
            lbVac.repaint();

            tfVacP.setValue(pres);
            tfVacP.setEditable(false);

            tfMonoFL.setText("Filt" + fltpos + ": " + Filter[fltpos - 1]);
            tfMonoWL.setValue(rs.getWl());
            tfMonoSW1.setValue(rs.getSw1());
            tfMonoSW2.setValue(rs.getSw2());
            if (rs.getWl() >= 0) {
                tfMonoState.setValue("ON");
                lbMono.setBackground(Color.GREEN);
            } else {
                tfMonoState.setValue("OFF");
                lbMono.setBackground(Color.RED);
            }
            lbMono.repaint();

            tfLmpC.setValue(rs.getLmppwr());
            if (rs.getLmppwr() > 0.) {
                tfLmpState.setValue("ON");
                lbLmp.setBackground(Color.GREEN);
            } else {
                tfLmpState.setValue("OFF");
                lbLmp.setBackground(Color.RED);
            }
            lbLmp.repaint();

            if (rs.getXedpos() == 0) {
                tfXEDState.setValue("retracted");
                lbXEDState.setBackground(Color.GREEN);
            } else if (rs.getXedpos() == 1) {
                tfXEDState.setValue("extended");
                lbXEDState.setBackground(Color.GREEN);
            } else {
                tfXEDState.setValue("unknown");
                lbXEDState.setBackground(Color.RED);
            }

//            display("Last heart beat at - " + Long.toString(lastHeartBeat));
            String last_warning = rs.getWarning();
            if (last_warning == null) {
                last_warning = "";
            }
            display("<html>Last heart beat at - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(lastHeartBeat)) + "<br>"
                    + last_warning + "</html>");
            display("Last heart beat at - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(lastHeartBeat)));
        }
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
//        System.out.println("GUI: In onDataArrival method and the source is "+source);
        try {

            StatusSubsystemData ssd = (StatusSubsystemData) msg;
            Object msgObject = ssd.getSubsystemData();
            if (msgObject instanceof KeyValueData) {
                KeyValueData d = (KeyValueData) msgObject;
                System.out.println("TSGUI: In onDataArrival method. KEY=" + d.getKey());
                if (d.getKey().equals(TSState.KEY)) {
//            System.out.println("TSGui received TSState message");
//            UpdateTSStatus(((TSStateStatus) d).getTSState());
                    UpdateTSStatus((TSState) d.getValue());
                }

            }
        } catch (RuntimeException e) {
            if (!e.toString().contains("de-serializing")) {
               log.info("Problem unpacking message:"+e); 
            }
        }
//        mon.handleData(teststand_dest, ssd.getDataKey(), ssd.getSubsystemData());
        lastHeartBeat = msg.getTimeStamp();
    }

    private void display(String message) {
        lbMessage.setFont(bigf);
        lbMessage.setForeground(WHITE);

        lbMessage.setText(message);
    }

    private void initConfigs() {
        System.out.println("Now in initConfigs");
        btteststandcfg.setText("cfg:" + TSConfig.operating_states.values()[cfgstate].name());

        boolean do_update = false;
        for (int idx = 0; idx < 6; idx++) {
            Object response = sendSyncTSCommand("Monochromator", "getFilterLabel", idx + 1);
            Filter[idx] = "empty";
            if (response != null) {
                if (!((String) response).equals(Filter[idx])) {
                    do_update = true;
                    System.out.println("Filter label #" + idx + " = " + Filter[idx]);
                }
                Filter[idx] = (String) response;
            }
        }
        if (do_update) {
            btMonoFL1.setBackground(typeMap.get(Filter[0]));
            btMonoFL2.setBackground(typeMap.get(Filter[1]));
            btMonoFL3.setBackground(typeMap.get(Filter[2]));
            btMonoFL4.setBackground(typeMap.get(Filter[3]));
            btMonoFL5.setBackground(typeMap.get(Filter[4]));
            btMonoFL6.setBackground(typeMap.get(Filter[5]));
        }

        Object response = sendSyncTSCommand("Bias", "getRunBias", cfgstate);
        double runBias = 0.0;
        if (response != null) {
            runBias = (double) response;
        }
        tfBiasVacq.setValue(runBias);

        response = sendSyncTSCommand("Cryo", "getRunTemp", cfgstate);
        double runTemp = -999.0;
        if (response != null) {
            runTemp = (double) response;
        }
        tfCryoTacq.setValue(runTemp);

        response = sendSyncTSCommand("VacuumGauge", "getRunVac", cfgstate);
        double runVac = 0.0;
        if (response != null) {
            runVac = (double) response;
        }
        tfVacPacq.setValue(runVac);

    }

    private void initComponents() {

        lbteststand.setFont(bigf);
        lbteststandstate.setFont(f);
        lbteststanderr.setFont(f);
        btteststandcfg.setFont(f);
        lbteststandacqtyp.setFont(f);
//        btteststandcfg.setForeground(BLACK);
//        btteststandcfg.setBackground(WHITE);
        btteststandabrt.setFont(f);
        btteststandabrt.setForeground(RED);
        btteststandabrt.setBackground(BLACK);

        lbBias.setFont(bigf);
        lbBiasState.setFont(f);
        lbBiasV.setFont(f);
        lbBiasV.setOpaque(true);
        lbPDI.setFont(f);
        lbPDI.setOpaque(true);

        lbCryo.setFont(bigf);
        lbCryo.setOpaque(true);
        lbCryoState.setFont(f);
        lbCryoTemp.setFont(f);

        lbVac.setFont(bigf);
        lbVac.setOpaque(true);
        lbVacState.setFont(f);
        lbVacPres.setFont(f);

        lbLmp.setFont(bigf);
        lbLmp.setOpaque(true);
        lbLmpState.setFont(f);
        lbLmpCurr.setFont(f);

        lbMono.setFont(bigf);
        lbMono.setOpaque(true);
        lbMonoState.setFont(f);
        lbMonoWL.setFont(f);
        lbMonoFL.setFont(f);


        /*
         **  TS overall state sub-panel
         */
        teststandPanel.setBorder(BorderFactory.createTitledBorder("SUBSYSTEM"));
        teststandPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcTS = new GridBagConstraints();
        gbcTS.insets = new Insets(4, 4, 4, 4);
        gbcTS.anchor = GridBagConstraints.NORTH;
        gbcTS.gridx = 0;
        gbcTS.gridy = 0;

        gbcTS.gridy++;

        BufferedImage img = null;
        try {
            img = ImageIO.read(BootstrapResourceUtils.getBootstrapResource("LSST-logo.png"));
        } catch (IOException e) {
            e.printStackTrace();
        }

        Image dimg = img.getScaledInstance(150, 60, Image.SCALE_SMOOTH);
        gbcTS.gridheight = 3;
        teststandPanel.add(new JLabel(new ImageIcon(dimg)), gbcTS);
        gbcTS.gridy += gbcTS.gridheight;
        gbcTS.gridheight = 1;
        teststandPanel.add(new JLabel("Test Stand"), gbcTS);
        gbcTS.gridy++;
        teststandPanel.add(new JLabel("Camera Ctrl Software"), gbcTS);
        gbcTS.gridy++;
        teststandPanel.add(new JLabel("ccs@kipac.stanford.edu"), gbcTS);

        gbcTS.gridy = 0;
        gbcTS.gridx++;

        teststandPanel.add(lbteststand, gbcTS);

        /* ******* TS state ******* */
        gbcTS.gridy++;
        teststandPanel.add(lbteststandstate, gbcTS);
        gbcTS.gridy++;
        Dimension d = tfState.getPreferredSize();
        d.width = 100;
        d.height = 30;
        tfState.setPreferredSize(d);
        tfState.setValue("IDLE");
        tfState.setFont(bigf);
        tfState.setEditable(false);
        teststandPanel.add(tfState, gbcTS);

        gbcTS.gridy++;

        /* ******* TS error ******* */
//        gbcTS.gridy++;
/*
teststandPanel.add(lbteststanderr, gbcTS);
        gbcTS.gridy++;
        d = tfErr.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfErr.setPreferredSize(d);
        tfErr.setValue("NONE");
        tfErr.setEditable(false);
        tfErr.setForeground(Color.BLACK);
        tfErr.setOpaque(true);

        teststandPanel.add(tfErr, gbcTS);
         */

 /* ******* TS ACQ Type ******* */
        gbcTS.gridy++;
        teststandPanel.add(lbteststandacqtyp, gbcTS);
        gbcTS.gridy++;
        d = tfAcqTyp.getPreferredSize();
        d.width = 100;
        d.height = 30;
        tfAcqTyp.setPreferredSize(d);
        tfAcqTyp.setValue("UNKNOWN");
        tfAcqTyp.setEditable(false);
        teststandPanel.add(tfAcqTyp, gbcTS);

        /* ******* TS abort button ***** */
        gbcTS.gridy++;
        teststandPanel.add(btteststandabrt, gbcTS);
        btteststandabrt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                cfgCnx();
                btteststandabrt.setForeground(BLACK);
                btteststandabrt.setBackground(RED);
                sendSyncTSCommand(null, "abortInterpreter");
                sendSyncTSCommand(null, "stopsubsys");
            }
        });

        /*
         **  bias and current measurement sub-panel
         */
        bssPanel.setBorder(BorderFactory.createTitledBorder("BIAS"));
        bssPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcBss = new GridBagConstraints();
        gbcBss.insets = new Insets(4, 4, 4, 4);
        gbcBss.anchor = GridBagConstraints.NORTH;
        gbcBss.gridx = 0;
        gbcBss.gridy = 0;

        bssPanel.add(lbBias, gbcBss);

        /* ******* Bias voltage ******* */
        gbcBss.gridy++;
        bssPanel.add(lbBiasV, gbcBss);
        gbcBss.gridy++;
        d = tfBiasV.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfBiasV.setPreferredSize(d);
        //       tfBiasV.setColumns(10);
        tfBiasV.setValue("0.0/0.0");
        tfBiasV.setEditable(false);
        bssPanel.add(tfBiasV, gbcBss);


        /* ******* Bias current ******* */
        gbcBss.gridy++;
        bssPanel.add(lbPDI, gbcBss);
        gbcBss.gridy++;
        d = tfPDI.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfPDI.setPreferredSize(d);
        tfPDI.setValue(0.0);
        tfPDI.setEditable(false);
        bssPanel.add(tfPDI, gbcBss);

        /* ******* Bias set point ******* */
        gbcBss.gridy++;
        bssPanel.add(lbBiasVacq, gbcBss);
        gbcBss.gridy++;
        d = tfBiasVacq.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfBiasVacq.setPreferredSize(d);
        bssPanel.add(tfBiasVacq, gbcBss);
        tfBiasVacq.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncTSCommand("Bias", "setrunbias", tfBiasVacq.getValue(), cfgstate);
                initConfigs();
//                SetBiasVacq();
//                cfgTTY();
            }
        });

        /* ----- cryogenics section ------ */
        cryoPanel.setBorder(BorderFactory.createTitledBorder("CRYOGENICS"));
        cryoPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcCryo = new GridBagConstraints();
        gbcCryo.insets = new Insets(4, 4, 4, 4);
        gbcCryo.anchor = GridBagConstraints.NORTH;
        gbcCryo.gridx = 0;
        gbcCryo.gridy = 0;

        cryoPanel.add(lbCryo, gbcCryo);

        /* ******* show cryo state ******* */
        gbcCryo.gridy++;
        cryoPanel.add(lbCryoState, gbcCryo);
        gbcCryo.gridy++;
        d = tfCryoState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfCryoState.setPreferredSize(d);
        tfCryoState.setValue("DISCONNECTED");
        tfCryoState.setEditable(false);
        cryoPanel.add(tfCryoState, gbcCryo);

        /* ******* show cryo temp ******* */
        gbcCryo.gridy++;
        cryoPanel.add(lbCryoTemp, gbcCryo);
        gbcCryo.gridy++;
        d = tfCryoTemp.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfCryoTemp.setPreferredSize(d);
        tfCryoTemp.setValue("0.0/0.0");
        tfCryoTemp.setEditable(false);
        cryoPanel.add(tfCryoTemp, gbcCryo);

        /* ******* cryo set point ******* */
        gbcCryo.gridy++;
        cryoPanel.add(lbCryoTacq, gbcCryo);
        gbcCryo.gridy++;
        d = tfCryoTacq.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfCryoTacq.setPreferredSize(d);
        cryoPanel.add(tfCryoTacq, gbcCryo);
        tfCryoTacq.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncTSCommand("Cryo", "setRunTemp", tfCryoTacq.getValue(), cfgstate);
                initConfigs();
//                SetCryoTacq();
//                cfgTTY();
            }
        });

        /* ----- vacuum section ------*/
        vacPanel.setBorder(BorderFactory.createTitledBorder("VACUUM"));
        vacPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcVac = new GridBagConstraints();
        gbcVac.insets = new Insets(4, 4, 4, 4);
        gbcVac.anchor = GridBagConstraints.NORTH;
        gbcVac.gridx = 0;
        gbcVac.gridy = 0;

        vacPanel.add(lbVac, gbcVac);

        /* ******* show vac state ******* */
        gbcVac.gridy++;
        vacPanel.add(lbVacState, gbcVac);
        gbcVac.gridy++;
        d = tfVacState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfVacState.setPreferredSize(d);
        tfVacState.setValue("DISCONNECTED");
        tfVacState.setEditable(false);
        vacPanel.add(tfVacState, gbcVac);

        /* ******* show vac pressure ******* */
        gbcVac.gridy++;
        vacPanel.add(lbVacPres, gbcVac);
        gbcVac.gridy++;
        d = tfVacP.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfVacP.setPreferredSize(d);
        tfVacP.setValue(0.0);
        tfVacP.setEditable(false);
        vacPanel.add(tfVacP, gbcVac);

        /* ******* vac set point ******* */
        gbcVac.gridy++;
        vacPanel.add(lbVacPacq, gbcVac);
        gbcVac.gridy++;
        d = tfVacPacq.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfVacPacq.setPreferredSize(d);
        vacPanel.add(tfVacPacq, gbcVac);
        tfVacPacq.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncTSCommand("VacuumGauge", "setRunVac", tfVacPacq.getValue(), cfgstate);
                initConfigs();
            }
        });

        /* ----- lamp section ------*/
        lmpPanel.setBorder(BorderFactory.createTitledBorder("LAMP"));
        lmpPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcLmp = new GridBagConstraints();
        gbcLmp.insets = new Insets(4, 4, 4, 4);
        gbcLmp.anchor = GridBagConstraints.NORTH;
        gbcLmp.gridx = 0;
        gbcLmp.gridy = 0;

        lmpPanel.add(lbLmp, gbcLmp);

        /* ******* show lmp state ******* */
        gbcLmp.gridy++;
        lmpPanel.add(lbLmpState, gbcLmp);
        gbcLmp.gridy++;
        d = tfLmpState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfLmpState.setPreferredSize(d);
        tfLmpState.setValue("DISCONNECTED");
        tfLmpState.setEditable(false);
        lmpPanel.add(tfLmpState, gbcLmp);

        /* ******* show lamp current ******* */
        gbcLmp.gridy++;
        lmpPanel.add(lbLmpCurr, gbcLmp);
        gbcLmp.gridy++;
        d = tfLmpC.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfLmpC.setPreferredSize(d);
        tfLmpC.setValue(0.0);
        tfLmpC.setEditable(false);
        lmpPanel.add(tfLmpC, gbcLmp);

        /* ----- XED section ------*/
        xedPanel.setBorder(BorderFactory.createTitledBorder("XED"));
        xedPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcXED = new GridBagConstraints();
        gbcXED.insets = new Insets(4, 4, 4, 4);
        gbcXED.anchor = GridBagConstraints.NORTH;
        gbcXED.gridx = 0;
        gbcXED.gridy = 0;

        xedPanel.add(lbXED, gbcXED);

        /* ******* show xed state ******* */
        gbcXED.gridy++;
        xedPanel.add(lbXEDState, gbcXED);
        gbcXED.gridy++;
        d = tfXEDState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfXEDState.setPreferredSize(d);
        tfXEDState.setValue("UNKNOWN");
        tfXEDState.setEditable(false);
        xedPanel.add(tfXEDState, gbcXED);


        /* ----- monochromator section ------*/
        monoPanel.setBorder(BorderFactory.createTitledBorder("MONOCHROMATOR"));
        monoPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcMono = new GridBagConstraints();
        gbcMono.insets = new Insets(4, 4, 4, 4);
        gbcMono.anchor = GridBagConstraints.NORTH;
        gbcMono.gridx = 0;
        gbcMono.gridy = 0;

        monoPanel.add(lbMono, gbcMono);

        /* ******* show mono state ******* */
        gbcMono.gridy++;
        monoPanel.add(lbMonoState, gbcMono);
        gbcMono.gridy++;
        d = tfMonoState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfMonoState.setPreferredSize(d);
        tfMonoState.setValue("DISCONNECTED");
        tfMonoState.setEditable(false);
        monoPanel.add(tfMonoState, gbcMono);

        /* ******* show monochromator wavelength ******* */
        gbcMono.gridy++;
        monoPanel.add(lbMonoWL, gbcMono);
        gbcMono.gridy++;
        d = tfMonoWL.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfMonoWL.setPreferredSize(d);
        tfMonoWL.setValue(0.);
        tfMonoWL.setEditable(false);
        monoPanel.add(tfMonoWL, gbcMono);

        gbcMono.gridx++;
        gbcMono.gridy = 0;
        /* ******* show monochromator filter status ******* */
//        gbcMono.gridy++;
        d = tfMonoFL.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfMonoFL.setPreferredSize(d);
        tfMonoFL.setText("Filter Position" + fltpos);
        monoPanel.add(tfMonoFL, gbcMono);

        /* ******* show monochromator slit widths ******* */
        gbcMono.gridy++;
        monoPanel.add(lbMonoSW1, gbcMono);
        gbcMono.gridy++;
        d = tfMonoSW1.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfMonoSW1.setPreferredSize(d);
        tfMonoSW1.setValue(0.);
        tfMonoSW1.setEditable(false);
        monoPanel.add(tfMonoSW1, gbcMono);
        gbcMono.gridy++;
        monoPanel.add(lbMonoSW2, gbcMono);
        gbcMono.gridy++;
        d = tfMonoSW2.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfMonoSW2.setPreferredSize(d);
        tfMonoSW2.setValue(0.);
        tfMonoSW2.setEditable(false);
        monoPanel.add(tfMonoSW2, gbcMono);
        // The buttons
/*
         gbcMono.gridy++;
         monoPanel.add(btMonoFL1, gbcMono);
         gbcMono.gridy++;
         monoPanel.add(btMonoFL2, gbcMono);
         gbcMono.gridy++;
         monoPanel.add(btMonoFL3, gbcMono);
         gbcMono.gridy -= 2;
   
         gbcMono.gridx++;
         monoPanel.add(btMonoFL4, gbcMono);
         gbcMono.gridy++;
         monoPanel.add(btMonoFL5, gbcMono);
         gbcMono.gridy++;
         monoPanel.add(btMonoFL6, gbcMono);
         */
        // Their actions
        btMonoFL1.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fltpos = 1;
                tfMonoFL.setText(fltpos + ": " + Filter[fltpos - 1]);
                sendSyncTSCommand("Monochromator", "setFilter", fltpos);
            }
        });
        btMonoFL2.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fltpos = 2;
                tfMonoFL.setText(fltpos + ": " + Filter[fltpos - 1]);
                sendSyncTSCommand("Monochromator", "setFilter", fltpos);
            }
        });
        btMonoFL3.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fltpos = 3;
                tfMonoFL.setText(fltpos + ": " + Filter[fltpos - 1]);
                sendSyncTSCommand("Monochromator", "setFilter", fltpos);
            }
        });
        btMonoFL4.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fltpos = 4;
                tfMonoFL.setText(fltpos + ": " + Filter[fltpos - 1]);
                sendSyncTSCommand("Monochromator", "setFilter", fltpos);
            }
        });
        btMonoFL5.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fltpos = 5;
                tfMonoFL.setText(fltpos + ": " + Filter[fltpos - 1]);
                sendSyncTSCommand("Monochromator", "setFilter", fltpos);
            }
        });
        btMonoFL6.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fltpos = 6;
                tfMonoFL.setText(fltpos + ": " + Filter[fltpos - 1]);
                sendSyncTSCommand("Monochromator", "setFilter", fltpos);
            }
        });

        /*
         **  TS Other sub-panel
         */
        extPanel.setBorder(BorderFactory.createTitledBorder("Image & Config."));
        extPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcExt = new GridBagConstraints();
        gbcExt.insets = new Insets(4, 4, 4, 4);
        gbcExt.anchor = GridBagConstraints.NORTH;
        gbcExt.gridx = 0;
        gbcExt.gridy = 0;

        initConfigs(); // initialize configurable values
// ----------------------------------------------
        /* ******* open eTraveler ***** */
 /*
        btetrv.setForeground(GREEN);
        btetrv.setBackground(WHITE);
        extPanel.add(btetrv, gbcExt);
        btetrv.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
//                    log.info("Executing: firefox for eTrav ");
                    java.lang.Runtime.getRuntime().exec("firefox -new-window http://lsst-camera.slac.stanford.edu/eTraveler/listTravelerTypes.jsp");
                } catch (Exception g) {
                    log.warning("eTraveler startup failed");
                }
            }
        });
        gbcExt.gridy++;
         */
// -------------------------------------------
        extPanel.add(lbext, gbcExt);

        /* ******* acquire sensor image ***** */
        gbcExt.gridy++;
        btacqimage.setForeground(BLUE);
        btacqimage.setBackground(WHITE);
        extPanel.add(btacqimage, gbcExt);
        btacqimage.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                cfgCnx();
                sendSyncArchonCommand("setFitsFileDirectory", "/tmp/");
                sendSyncArchonCommand("exposeAcquireAndSaveImage");
            }
        });

        /* ******* display image ***** */
        gbcExt.gridy++;
        btds9.setForeground(BLUE);
        btds9.setBackground(WHITE);
        extPanel.add(btds9, gbcExt);

        btds9.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String[] paths = null;
                Long highindex = -1L;

                try {
                    log.info("Getting list of available .fits files");
                    File f = new File("/tmp/");
                    log.info("The paths are: " + f.getAbsolutePath());
                    log.info("The list of all files is: " + f.list());
                    // create new filename filter
                    FilenameFilter fileNameFilter = new FilenameFilter() {

                        @Override
                        public boolean accept(File dir, String name) {
                            log.info("fileNameFilter: dir=" + dir + " name=" + name);
                            if (name.lastIndexOf('.') > 0) {
                                int lastIndex = name.lastIndexOf('.');
                                // get extension
                                String str = name.substring(lastIndex);
                                // match path name extension
                                if (str.equals(".fits")) {
                                    return true;
                                }
                            }
                            return false;
                        }
                    };
                    // returns pathnames for files and directory
                    paths = f.list(fileNameFilter);
                } catch (Exception t) {
                    // if any error occurs
                    t.printStackTrace();
                }

                // for each name in the path array
                if (paths != null) {
                    JList<String> pathList;
                    DefaultListModel<String> listModel = new DefaultListModel<>();
                    for (String path : paths) {
                        // prints filename and directory name
                        log.info(path);
                        listModel.addElement(path);

                        int istrt = path.indexOf('_') + 1;
                        int iend = path.indexOf('.');
                        String psub = path.substring(istrt, iend);
//                        log.info("istrt="+istrt+" iend="+iend+" psub=("+psub+")");
                        Long index = Long.valueOf(psub);
//                        log.info("index = "+index);
                        if (index != null) {
                            if (index > highindex) {
                                lastpath = path;
                                highindex = index;
                            }
                        }
                    }

//                    display("Last heart beat at - " + Long.toString(lastHeartBeat) + " Last image acquired = " + lastpath);
                    display("Last heart beat at - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(lastHeartBeat) + " Last image acquired = " + lastpath));
                    //create the list
                    pathList = new JList<>(listModel);
                    pathList.addListSelectionListener(new ListSelectionListener() {
                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (!e.getValueIsAdjusting()) {
                                final List<String> selectedValuesList = pathList.getSelectedValuesList();
                                System.out.println(selectedValuesList);
                                lastpath = selectedValuesList.get(0);
                                try {
//                  java.lang.Runtime.getRuntime().exec("ds9 `ls -1rt *.fits | tail -1`");         
                                    log.info("Executing: ds9 " + lastpath);
                                    java.lang.Runtime.getRuntime().exec("ds9 -tile " + lastpath);
                                    pl.dispose();
                                } catch (Exception g) {
                                    log.info("DS9 startup failed");
                                }

                            }
                        }
                    });

                    pl = new JFrame("Available FITs files");
                    pl.add(pathList);

                    pl.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    pl.setTitle("Available FITs files");
                    pl.setSize(200, 200);
                    pl.setLocationRelativeTo(null);
                    pl.add(new JScrollPane(pathList));
                    pathList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
                    pl.setVisible(true);
                }
            }
        });

        gbcExt.gridy++;
        extPanel.add(lbconfig, gbcExt);

        /* ******* TS change state button ***** */
        gbcExt.gridy++;
        extPanel.add(btteststandcfg, gbcExt);
        btteststandcfg.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                String[] states = new String[TSConfig.operating_states.values().length];
                for (TSConfig.operating_states iwstate : TSConfig.operating_states.values()) {
                    states[iwstate.ordinal()] = iwstate.name();
                }
//                Long highindex = -1L;

                // for each name in the path array
                if (states != null) {
                    JList<String> stateList;
                    DefaultListModel<String> listModel = new DefaultListModel<>();
                    for (String state : states) {
                        listModel.addElement(state);
                    }

                    //create the list
                    stateList = new JList<>(listModel);
                    stateList.addListSelectionListener(new ListSelectionListener() {
                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (!e.getValueIsAdjusting()) {
                                final List<String> selectedValuesList = stateList.getSelectedValuesList();
                                System.out.println(selectedValuesList);
                                String selectedstate = selectedValuesList.get(0);
                                try {
                                    log.info("Switching to " + selectedstate);
                                    cfgstate = TSConfig.operating_states.valueOf(selectedstate).ordinal();
                                    initConfigs();
                                    plcfg.dispose();
                                } catch (Exception g) {
                                    log.info("State change failed");
                                }

                            }
                        }
                    });

                    plcfg = new JFrame("Select a state:");
                    plcfg.add(stateList);

                    plcfg.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    plcfg.setTitle("Config State");
                    plcfg.setSize(200, 200);
                    plcfg.setLocationRelativeTo(null);
                    plcfg.add(new JScrollPane(stateList));
                    stateList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
                    plcfg.setVisible(true);
                }

// *************************************
//                btteststandcfg.setForeground(BLACK);
//                btteststandcfg.setBackground(RED);
            }
        });

        /* ******* save configuration ***** */
        gbcExt.gridy++;
        btSaveConfig.setForeground(BLUE);
        btSaveConfig.setBackground(WHITE);
        extPanel.add(btSaveConfig, gbcExt);
        btSaveConfig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String cmnd = "writeconfig";
                    log.info("invoking command - " + cmnd);

                    sendSyncTSCommand(null, cmnd);

//                    teststand.writeConfig(log);
                } catch (Exception g) {
                    log.info("Failed to write configuration file!");
                }
//                cfgStore();
            }
        });

        /* -------------------------------------------------------------------- */
 /*
         **  Main panel
         */
        panel.setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.setBackground(new Color(40, 40, 60));

        panel.add(teststandPanel, gbc);
        gbc.gridx++;
        panel.add(bssPanel, gbc);
        gbc.gridx++;
        panel.add(cryoPanel, gbc);
        gbc.gridx++;
        panel.add(vacPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy++;
        panel.add(monoPanel, gbc);
        gbc.gridx++;
        panel.add(lmpPanel, gbc);
        gbc.gridx++;
        panel.add(xedPanel, gbc);
        gbc.gridx++;
        panel.add(extPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.NORTH;
        panel.add(lbMessage, gbc);
    }

    public JPanel getPanel() {
        return panel;
    }

    public JComponent getGuiLayout() {
        return panel;
    }

    public void resetGui() {
    }

    protected Object sendSyncArchonCommand(String name, Object... params) {
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(archon_dest, name, params);
        try {
            return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(10000));
        } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
            log.warning("Unable to perform jgroup communication with destination + "
                    + archon_dest + " - Exception " + e);
            return null;
        }
    }

    protected Object sendSyncTSCommand(String target, String name, Object... params) {
        String dest = target == null ? teststand_dest : teststand_dest + "/" + target;

        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(dest, name, params);
        System.out.println("teststand_dest = " + dest);
        try {
            return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(10000));
        } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
            log.warning("Unable to perform jgroup communication with destination + "
                    + teststand_dest + " - Exception " + e);
            return null;
        }
    }

    /**
     * ******************************************************
     **
     **
     ** read text fields and send updates to the subsystem *
     * ***********************************************************
     */
    void updateConfig() {
        sendSyncTSCommand("Bias", "setrunbias", tfBiasVacq.getValue());
        sendSyncTSCommand("Cryo", "setruntemp", tfCryoTacq.getValue());
        sendSyncTSCommand("VacuumGauge", "setrunvac", tfVacPacq.getValue());
        sendSyncTSCommand("Monochromator", "setrunwave" + tfMonoWL.getValue());
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            } catch (IOException e) {
                JOptionPane.showMessageDialog(null,
                        "Failed to launch the link, "
                        + "your computer is likely misconfigured.",
                        "Cannot Launch Link", JOptionPane.WARNING_MESSAGE);
            }
        } else {
            JOptionPane.showMessageDialog(null,
                    "Java is not able to launch links on your computer.",
                    "Cannot Launch Link", JOptionPane.WARNING_MESSAGE);
        }
    }
}
