/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.plugins.dictionary.HintTextField;

public class ArgInputPanel
extends JPanel
implements ListSelectionListener {
    private JLabel[] argName;
    private ArgumentValueSelection[] argInput;
    private final JPanel formPane;
    private final JEditorPane commandDesc;

    public ArgInputPanel() {
        this.setLayout(new BorderLayout());
        this.commandDesc = new JEditorPane();
        this.commandDesc.setBackground(new Color(237, 236, 235));
        this.commandDesc.setEditable(false);
        this.commandDesc.setContentType("text/html");
        this.commandDesc.setText("      ");
        this.add((Component)this.commandDesc, "Center");
        this.formPane = new JPanel();
        this.add((Component)this.formPane, "South");
    }

    public void clearForm() {
        this.formPane.removeAll();
        this.commandDesc.setText("       ");
    }

    public final void fillFormPane(DictionaryCommand cmd) {
        this.clearForm();
        int nbArgs = cmd.getArguments().length;
        this.formPane.setLayout(new GridLayout(nbArgs, 2));
        this.argName = new JLabel[nbArgs];
        this.argInput = new ArgumentValueSelection[nbArgs];
        for (int i = 0; i < nbArgs; ++i) {
            DictionaryArgument da = cmd.getArguments()[i];
            this.argName[i] = new JLabel(da.getName());
            this.formPane.add(this.argName[i]);
            if (da.getAllowedValues().isEmpty()) {
                HintTextField htf = new HintTextField(cmd.getArguments()[i].getSimpleType());
                this.argInput[i] = () -> htf.getText();
                this.formPane.add(htf);
                continue;
            }
            JComboBox<String> allowedValuesBox = new JComboBox<String>(da.getAllowedValues().toArray(new String[0]));
            this.argInput[i] = () -> allowedValuesBox.getSelectedItem().toString();
            this.formPane.add(allowedValuesBox);
        }
        String cmdDescString = cmd.getDescription() + "<br>";
        DictionaryArgument[] argTable = cmd.getArguments();
        String cmdArguments = "";
        for (int i = 0; i < argTable.length; ++i) {
            cmdArguments = cmdArguments + " <b>" + argTable[i].getSimpleType() + "</b> " + argTable[i].getName() + " : " + argTable[i].getDescription() + "<br>";
        }
        this.commandDesc.setText("<html><h3>" + cmdDescString + "</h3><p>" + cmdArguments + "</p>");
        this.repaint();
        this.validate();
    }

    public String getFormattedArgumentValues() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.argInput.length; ++i) {
            res.append(this.argInput[i].getArgumentValue()).append(" ");
        }
        return res.toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        DictionaryCommand cmd = (DictionaryCommand)((JList)lse.getSource()).getSelectedValue();
        this.clearForm();
        if (cmd == null) {
            return;
        }
        this.fillFormPane(cmd);
    }

    private static interface ArgumentValueSelection {
        public String getArgumentValue();
    }
}

