package org.lsst.ccs.subsystem.teststand.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 ***************************************************************************
 **
 ** Provides access to the flux calibration tables
 *
 * @author Homer Neal *
 * **************************************************************************
 */
public class TSFluxCalib {

    double MINWL = 300.;
    double MAXWL = 1200.;
    double NWLSTEPS = 0.;
    double MINSW = 6.;
    double MAXSW = 2000.;
    double NSWSTEPS = 100.;

//    private double[][] swtab = new double[(int)NWLSTEPS+1][(int)NSWSTEPS+1];
    private double[] swtab = new double[2000];
    private double[] wltab = new double[2000];

    private List swtabary[][] = new List[3000][2];

    private String configFile;

    int wl_idx(double wl) {
        int widx;
        for (widx = 0; widx < NWLSTEPS; widx++) {
            if (wl > wltab[widx]) {
                break;
            }
        }
        /*
         int widx = (int)((wl-MINWL)/(MAXWL-MINWL)*NWLSTEPS);
         if (widx<0) widx = 0;
         if (widx>((int)NWLSTEPS-1)) widx = (int)NWLSTEPS;
         */
        return widx;
    }

    int sw_idx(double sw) {
        return ((int) ((sw - MINSW) / (MAXSW - MINSW) * NSWSTEPS));
    }

    double grid_wl(int iwl) {
//        return(iwl/NWLSTEPS * (MAXWL-MINWL) + MINWL);
        return (wltab[iwl]);
    }

    double grid_sw(int isw) {
        return (isw / NSWSTEPS * (MAXSW - MINSW) + MINSW);
    }

    public TSFluxCalib() {
        this.configFile = System.getProperty("lsst.ccs.teststand.fluxcalfile", "TS3FluxCalData.dat");
        System.out.println("Flux Calibration File path is " + configFile);
        TSFluxCalibReader();

    }

    public void setTSFluxCalibFile(String cfgfile) {
        this.configFile = cfgfile;
        System.out.println("Flux Calibration File path is " + configFile);
        TSFluxCalibReader();
    }

    public void TSFluxCalibReader() {
        System.out.println("TSFluxCalibReader called");

//             log.error("reading config file");
        File cfgFl = new File(configFile);
        if (cfgFl.exists()) {

        FileReader fstream = null;
        try {
            fstream = new FileReader(cfgFl);
        } catch (IOException e) {
            e.printStackTrace();
        }
//        InputStream fstream = BootstrapResourceUtils.getBootstrapResource(configFile);
        if (fstream != null) {

            String line = null;

            try {
//                BufferedReader in = new BufferedReader(new FileReader(cfgFl));
//                BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
                BufferedReader in = new BufferedReader(fstream);
                int istate = 0; // state for which to apply the setting 
                int iwl = 0;
                while (in.ready()) {
                    line = in.readLine();
                    if (line.startsWith("//")) continue;
                    double wl = Double.valueOf(line.split(" ")[0]);
                    double sw = Double.valueOf(line.split(" ")[1]);
//                     int iwl = wl_idx(wl); 
                    swtab[iwl] = sw;
                    wltab[iwl] = wl;
//                    System.out.println("TSFluxCalib: index = " + iwl + " wl = " + wltab[iwl] + " sw = " + swtab[iwl]);
                    iwl++;
                }
                NWLSTEPS = iwl;

                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        } else {
            System.out.println("File "+configFile+" doesn't exist. Use of the slit width calibration will not be possible.");
        }
    }

//    double getRequiredSlitWidth(double wl, double sw) {
    public int getRequiredSlitWidth(double wl) {
        double resp = -1;
        int iminwlidx = ((wl_idx(wl) - 1) >= 0) ? wl_idx(wl) - 1 : 0;
        int imaxwlidx = ((wl_idx(wl) + 1) >= ((int) NWLSTEPS - 1)) ? wl_idx(wl) + 1 : (int) NWLSTEPS - 1;

        double sw1 = swtab[wl_idx(wl)];
        double wl1 = wl;
        double sw2 = sw1;
        double wl2 = wl;
        if (wl_idx(wl) < imaxwlidx) {
            sw2 = swtab[wl_idx(wl) + 1];
            wl2 = wltab[wl_idx(wl) + 1];
        }
        if (wl2 == wl1) {
            resp = sw1;
        } else {
            resp = (wl - wl1) / (wl2 - wl1) * (sw2 - sw1) + sw1;
        }
        return ((int) resp);
    }
}
