package org.lsst.ccs.subsystem.teststand.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 ** Contains the state of the test stand subsystem * * @author Homer Neal *
 * **************************************************************************
 */
public class TSState implements Serializable {

    private static final long serialVersionUID = -7596686997197536530L;

    public static final String KEY = "TSState";

    static int ibit = 19;
    static int LEDDEVC_ON_BIT,ACCUM_DONE_BIT,FE55_ON_BIT,CRYO_DEV_WARNING_BIT,VAC_DEV_WARNING_BIT;
    public final static int STARTUP_BIT = 0,
            READY_BIT = 1,
            ACQ1_BIT = 2,
            WARM_BIT = 3,
            SHUTDOWN_BIT = 4,
            IDLE_BIT = 5,
            STOP_BIT = 6,
            PWRDEVC_TRIPPED_BIT = 7,
            CRYODEVC_TRIPPED_BIT = 8,
            VACDEVC_TRIPPED_BIT = 9,
            PWRDEVC_ON_BIT = 10,
            CRYODEVC_ON_BIT = 11,
            VACDEVC_ON_BIT = 12,
            LAMPDEVC_ON_BIT = 13,
            MONODEVC_ON_BIT = 14,
            ENVDEVC_ON_BIT = 15,
            TEST_BIT = 16,
            EXPERT_BIT = 17,
            PDDEVC_ON_BIT = 18,
            VQMDEVC_ON_BIT = 19,
            LEDDEVC_ON = (1 << (LEDDEVC_ON_BIT = ibit++)),
            ACCUM_DONE = (1 << (ACCUM_DONE_BIT = ibit++)),
            FE55_ON_DEV = (1 << (FE55_ON_BIT = ibit++)),
            CRYO_DEV_WARNING = (1 << (CRYO_DEV_WARNING_BIT = ibit++)),
            VAC_DEV_WARNING = (1 << (VAC_DEV_WARNING_BIT = ibit++)),
            STARTUP = 1 << STARTUP_BIT,
            READY = 1 << READY_BIT,
            ACQ1 = 1 << ACQ1_BIT,
            WARM = 1 << WARM_BIT,
            SHUTDOWN = 1 << SHUTDOWN_BIT,
            IDLE = 1 << IDLE_BIT,
            STOP = 1 << STOP_BIT,
            PWRDEVC_TRIPPED = 1 << PWRDEVC_TRIPPED_BIT,
            CRYODEVC_TRIPPED = 1 << CRYODEVC_TRIPPED_BIT,
            VACDEVC_TRIPPED = 1 << VACDEVC_TRIPPED_BIT,
            PWRDEVC_ON = 1 << PWRDEVC_ON_BIT,
            CRYODEVC_ON = 1 << CRYODEVC_ON_BIT,
            VACDEVC_ON = 1 << VACDEVC_ON_BIT,
            LAMPDEVC_ON = 1 << LAMPDEVC_ON_BIT,
            MONODEVC_ON = 1 << MONODEVC_ON_BIT,
            ENVDEVC_ON = 1 << ENVDEVC_ON_BIT,
            TEST = 1 << TEST_BIT,
            EXPERT = 1 << EXPERT_BIT,
            PDDEVC_ON = 1 << PDDEVC_ON_BIT,
            VQMDEVC_ON = 1 << VQMDEVC_ON_BIT;

    int systemState;           // Mask of state bits
    int operState;             // ordinal operating state (READY,IDLE,ACQ1,...)
    int tickMillis;            // Data status update period (ms)
    double volts;              // Bias volts
    double bias_curr;          // Bias device current
    double curr;               // current
    double temp;               // cryo temp
    double vac;                // pressure
    double temp2;               // cryo temp
    double vac2;                // pressure
    double lmppwr;            // lamp power
    double wl;                 // wavelength
    double sw1;                // slit 1 width
    double sw2;                // slit 2 width
    int fltpos;             // filter position
    int shutpos;            // shutter position
    int xedpos;             // xed extended or retracted

    String srctype;            // lamp source type
    String monotype;           // monochromator type
    String pdtype;             // photo diode type
    String biastype;             // bias dev type
    int    pdcnt=0;              // # readings
    double pdnplc=1.0;           // nplc (measurement rate)
    int    biason;               // is the bias output on
    String filter;             // description of filter being used
    String warning;            // any current warning string
    double picocurrent;

    public enum onOff {

        OFF, ON;
    }

    public enum pwrstates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED,
        ACCUM,
        ACCUMDONE;
    }

    public enum cryostates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED;
    }

    public enum vacstates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED;
    }

    public TSState(int systemState, int operState, int tickMillis) {
        this(systemState, operState, tickMillis, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0,  0,  0, "", "", "", "","", 0, 0., 0, 0., 0., 0., "");
    }

    public TSState(int systemState, int operState, int tickMillis, double volts, double bias_curr, double curr, double temp, double vac, double temp2, double vac2,
            double lmppwr, double wl, int fltpos, int shutpos, int xedpos, String srctype, String monotype, String pdtype, String filter,
            String biastype, int pdcnt, double pdnplc, int biason, double sw1, double sw2, double picocurrent, String warning) {
        this.systemState = systemState;
        this.operState = operState;
        this.tickMillis = tickMillis;
        this.volts = volts;
        this.bias_curr = curr;
        this.curr = curr;
        this.temp = temp;
        this.vac = vac;
        this.temp2 = temp2;
        this.vac2 = vac2;
        this.lmppwr = lmppwr;
        this.wl = wl;
        this.fltpos = fltpos;
        this.shutpos = shutpos;
        this.xedpos = xedpos;
        this.srctype = srctype;
        this.monotype = monotype;
        this.pdtype = pdtype;
        this.biastype = biastype;
        this.pdcnt    = pdcnt;
        this.pdnplc   = pdnplc;
        this.biason   = biason;
        this.filter = filter;
        this.sw1      = sw1;
        this.sw2      = sw2;
        this.picocurrent = picocurrent;
        this.warning  = warning;
    }

    public int getSystemState() {
        return systemState;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public double getVolts() {
        return volts;
    }

    public void setVolts(double volts) {
        this.volts = volts;
    }

    public double getBIAS_curr() {
        return bias_curr;
    }

    public void setBIAS_curr(double bias_curr) {
        this.bias_curr = bias_curr;
        this.picocurrent = bias_curr * 1.e12;
    }

    public double getCurr() {
        return curr;
    }

    public void setCurr(double curr) {
        this.curr = curr;
    }

    public double getTemp() {
        return temp;
    }

    public void setTemp(double temp) {
        this.temp = temp;
    }

    public double getVac() {
        return vac;
    }

    public void setVac(double vac) {
        this.vac = vac;
    }

    public double getTemp2() {
        return temp2;
    }

    public void setTemp2(double temp2) {
        this.temp2 = temp2;
    }

    public double getVac2() {
        return vac2;
    }

    public void setVac2(double vac2) {
        this.vac2 = vac2;
    }

    public String getSrcType() {
        return srctype;
    }

    public void setSrctype(String srctype) {
        this.srctype = srctype;
    }

    public String getMonoType() {
        return monotype;
    }

    public void setMonotype(String monotype) {
        this.monotype = monotype;
    }

    public String getPDtype() {
        return pdtype;
    }

    public void setPDtype(String pdtype) {
        this.pdtype = pdtype;
    }

    public int getPDcnt() {
        return pdcnt;
    }

    public void setPDcnt(int pdcnt) {
        this.pdcnt = pdcnt;
    }

    public double getPDnplc() {
        return pdnplc;
    }

    public void setPDnplc(double pdnplc) {
        this.pdnplc = pdnplc;
    }

    public int getBIASon() {
        return biason;
    }

    public void setBIASon(int biason) {
        this.biason = biason;
    }

    public String getBIAStype() {
        return biastype;
    }

    public void setBIAStype(String biastype) {
        this.biastype = biastype;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public int getFltpos() {
        return fltpos;
    }

    public void setFltpos(int fltpos) {
        this.fltpos = fltpos;
    }

    public double getLmppwr() {
        return lmppwr;
    }

    public void setLmpPwr(double lmppwr) {
        this.lmppwr = lmppwr;
    }

    public String getMonotype() {
        return monotype;
    }

    public int getShutpos() {
        return shutpos;
    }

    public void setShutpos(int shutpos) {
        this.shutpos = shutpos;
    }

    public double getWl() {
        return wl;
    }

    public void setWl(double wl) {
        this.wl = wl;
    }

    public int getXedpos() {
        return xedpos;
    }

    public void setXedpos(int xedpos) {
        this.xedpos = xedpos;
    }

    public double getSw1() {
        return sw1;
    }

    public void setSw1(double sw1) {
        this.sw1 = sw1;
    }

    public double getSw2() {
        return sw2;
    }

    public void setSw2(double sw2) {
        this.sw2 = sw2;
    }

    public String getWarning() {
        return warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public int getOperState() {
        return operState;
    }

    public void setOperState(int operState) {
        this.operState = operState;
    }

    @Override
    public String toString() {
        return "systemState=" + systemState
                + ", tickMillis=" + tickMillis
                + ", bias volts=" + volts
                + ", PD current=" + curr
                + ", cryo temp=" + temp
                + ", pressure=" + vac
                + ", cryo temp2=" + temp2
                + ", pressure2=" + vac2
                + ", lamp current=" + lmppwr
                + ", shutter position=" + shutpos
                + ", filter position=" + fltpos
                + ", lamp type=" + srctype
                + ", monochromator type=" + monotype
                + ", photo diode type=" + pdtype
                + ", filter name=" + filter;
    }

}
