package org.lsst.ccs.subsystem.teststand.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 ** Contains the state of the test stand photodiode subsystem * 
 ** @author Homer Neal *
 * **************************************************************************
 */
public class PDState implements Serializable {

    private static final long serialVersionUID = -7596686997197536530L;

    public static final String KEY = "PDState";

    public final static int 
            ACCUM_DONE_BIT = 1,
            ACCUM_DONE = 1 << ACCUM_DONE_BIT;

    int systemState, // Mask of state bits
        tickMillis;         // Data status update period (ms)

    public enum pwrstates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED,
        ACCUM,
        ACCUMDONE;
    }
    public PDState(int systemState, int tickMillis) {
        this.systemState = systemState;
        this.tickMillis = tickMillis;
    }

    public int getSystemState() {
        return systemState;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    @Override
    public String toString() {
        return "systemState=" + systemState
                + ", tickMillis=" + tickMillis;
    }

}
