package org.lsst.ccs.subsystem.teststand.states;

/**
 * The vacuum target to be reached. The actual set points are set on 
 * the subsystem as configuration parameters.
 * 
 * @author The LSST CCS Team
 */
public enum VacuumTarget {

    /**
     * More information is needed to assess the VacuumTarget.
     */
    UNKNOWN,
    
    /**
     * Set the current values as the VacuumTarget.
     */
    CURRENT,

    /**
     * The system is at air pressure
     */
    AIR,
    
    /**
     * The system is running with roughing pumps only
     */
    ROUGH,
    
    /**
     * The system is running with turbo pumps.
     */
    TURBO;

}
