package org.lsst.ccs.subsystem.teststand.states;

/**
 * Vacuum State with respect to the VacuumTarget.
 * 
 * @author The LSST CCS Team
 */
public enum VacuumState {

    /**
     * The initial thermal state. Will migrate to a well defined state when
     * enough information is gathered.
     */
    UNKNOWN,
    
    /**
     * The VacuumTarget has been reached.
     */
    AT_TARGET,
    
    /**
     * The system is transitioning to a new VacuumTarget.
     */
    IN_TRANSITION,

    /**
     * The system is off the set VacuumTarget.
     */
    OFF_TARGET;

}
