package org.lsst.ccs.subsystem.teststand.states;

/**
 * Thermal State of Cold/Cryo device with respect to the ThermalTarget.
 * 
 * @author The LSST CCS Team
 */
public enum ThermalState {

    /**
     * The initial thermal state. Will migrate to a well defined state when
     * enough information is gathered.
     */
    UNKNOWN,
    
    /**
     * The ThermalTarget has been reached.
     */
    AT_TARGET,
    
    /**
     * The system is transitioning  to a new ThermalTarget.
     */
    IN_TRANSITION,

    /**
     * The system is off the set ThermalTarget.
     */
    OFF_TARGET;
}
