package org.lsst.ccs.subsystem.teststand.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 ***************************************************************************
 **
 **  Contains information describing the full test stand state.
 **
 **  <p>
 **  Sent on the status bus upon startup or upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class TSFullState implements Serializable {

    private static final long serialVersionUID = -1207498930489246631L;
    
    final private TSState teststandState;
    final private MonitorFullState monitorState;

    public TSFullState(TSState rState, MonitorFullState mState) {
        teststandState = rState;
        monitorState = mState;
    }

    public TSState getTSState() {
        return teststandState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

}
