package org.lsst.ccs.subsystem.teststand.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

import org.lsst.ccs.utilities.logging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 ***************************************************************************
 **
 ** Contains the state of the test stand 3 system * * @author Homer Neal *
 * **************************************************************************
 */
public class TSConfig implements Serializable {

    public enum operating_states {

        IDLE, READY, TEST, ACQ1, WARM, ACQ3, ACQ4, ACQ5, EXPERT;
    }
    public static final String[] COMPONENT_NAMES = {"IDLE", "READY", "TEST", "ACQ1", "WARM"};

/*
    public static final String[] COMPONENT_NAMES = {
        operating_states.values()[0].name(),
        operating_states.values()[1].name(),
        operating_states.values()[2].name(),
        operating_states.values()[3].name(),
        operating_states.values()[4].name(),
        operating_states.values()[5].name(),
        operating_states.values()[6].name(),
        operating_states.values()[7].name(),
        operating_states.values()[8].name()
    };
*/
    public enum EVENT_ID {

        BIAS,
        CRYO,
        VAC,
        PD,
        LMP;
    }

    public static int MAXSTATES = operating_states.values().length;
    private int cfgstate = 0;

    private double[] biasVAcq = new double[MAXSTATES];           // Bias volts during acquisition
    private double[] cryoTAcq = new double[MAXSTATES];           // cryo temp during acquisition
    private double[] vacPAcq = new double[MAXSTATES];            // pressure during acquisition
    private double[] lambdaAcq = new double[MAXSTATES];          // wavelength during acquisition
    private String[] filter_names;                 // names of the filters
    private double[] filter_edges = new double[6]; // wl edge at which filter should be selected
    private String srctype;              // lamp source type
    private String monotype;             // monochromator type
    private String pdtype;               // photodiode type
    private String biastype;             // bias dev type
    private int pdcnt = 0;              // # readings
    private double pdnplc = 1.0;           // nplc (measurement rate)
    private int biason;               // is the bias output on
    private double[] minLmpPwr = new double[MAXSTATES];         // min. lamp power for acquisition
    private double[] cryoTAcqTol = new double[MAXSTATES];        // tolerance on the CCD temp
    private String configFile;

    public TSConfig() {
//        this.configFile = System.getProperty("lsst.ccs.teststand.configFile", "TestStand.cfg");
//        System.out.println("Config file path is: " + configFile);
    }

    public TSConfig(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        update(biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        update(cfgstate, biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(int istate, double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.biasVAcq[istate] = biasVAcq;
        this.cryoTAcq[istate] = cryoTAcq;
        this.cryoTAcqTol[istate] = cryoTAcqTol;
        this.vacPAcq[istate] = vacPAcq;
        this.lambdaAcq[istate] = lambdaAcq;
        this.minLmpPwr[istate] = minLmpPwr;

    }

    public double getBiasVAcq() {
        return biasVAcq[cfgstate];
    }

    public double getCryoTAcq() {
        return cryoTAcq[cfgstate];
    }

    public void setCryoTAcq(double cryoTAcq, int istate) {
        this.cryoTAcq[istate] = cryoTAcq;
    }

    public double getVacPAcq() {
        return vacPAcq[cfgstate];
    }

    public double getLambdaAcq() {
        return lambdaAcq[cfgstate];
    }

    public String[] getFilters() {
        return filter_names;
    }

    public String getSrcType() {
        return srctype;
    }

    public String getMonoType() {
        return monotype;
    }

    public String getPDType() {
        return pdtype;
    }

    public String getBIASType() {
        return biastype;
    }

    public int getPDcnt() {
        return pdcnt;
    }

    public void setPDcnt(int pdcnt) {
        this.pdcnt = pdcnt;
    }

    public double getPDnplc() {
        return pdnplc;
    }

    public void setPDnplc(double pdnplc) {
        this.pdnplc = pdnplc;
    }

    public int getBiason() {
        return biason;
    }

    public void setBiason(int biason) {
        this.biason = biason;
    }

    public double getMinLmpPwr() {
        return minLmpPwr[cfgstate];
    }

    public void setCryoTAcqTol(double cryoTAcqTol) {
        this.cryoTAcqTol[cfgstate] = cryoTAcqTol;
    }

    public double getCryoTAcqTol() {
        return cryoTAcqTol[cfgstate];
    }

    public void setCfgState(int cfgstate) {
        this.cfgstate = cfgstate;
    }

    public int getCfgstate() {
        return cfgstate;
    }

    public double[] getFilter_edges() {
        return filter_edges;
    }

    public void setFilter_edges(double[] filter_edges) {
        this.filter_edges = filter_edges;
    }

    public void setBiasVAcq(double biasVAcq) {
        this.biasVAcq[cfgstate] = biasVAcq;
    }

    public void setBiasVAcq(double biasVAcq, int istate) {
        this.biasVAcq[istate] = biasVAcq;
    }

    public void setCryoTAcq(double cryoTAcq) {
        this.cryoTAcq[cfgstate] = cryoTAcq;
    }

    public void setVacPAcq(double vacPAcq) {
        this.vacPAcq[cfgstate] = vacPAcq;
    }

    public void setLambdaAcq(double lambdaAcq) {
        this.lambdaAcq[cfgstate] = lambdaAcq;
    }

    public void setFilter_names(String[] filter_names) {
        this.filter_names = filter_names;
    }

    public void setSrctype(String srctype) {
        this.srctype = srctype;
    }

    public void setMonotype(String monotype) {
        this.monotype = monotype;
    }

    public void setPdtype(String pdtype) {
        this.pdtype = pdtype;
    }

    public void setBiastype(String biastype) {
        this.biastype = biastype;
    }

    public void setMinLmpPwr(double minLmpPwr) {
        this.minLmpPwr[cfgstate] = minLmpPwr;
    }

    /*
     public void setCryoTAcqTol(double cryoTAcqTol) {
     this.cryoTAcqTol[cfgstate] = cryoTAcqTol;
     }
     */

    @Override
    public String toString() {
        String line = "";
        for (operating_states stat : operating_states.values()) {
            int icfg = stat.ordinal();
            line
                    += "state=" + stat.name()
                    + ", biasVAcq=" + biasVAcq[icfg]
                    + ", cryoTAcq=" + cryoTAcq[icfg]
                    + ", vacPAcq=" + vacPAcq[icfg]
                    + ", lambdaAcq=" + lambdaAcq[icfg];
        }
        line += ", filter_names=" + filter_names
                + ", srctype=" + srctype
                + ", monotype=" + monotype
                + ", pdtype=" + pdtype
                + ", biastype=" + biastype;
//                + ", possible states are IDLE = " + operating_states.values();
        return line;
    }

    public void TSConfigWriter_deprecated(Logger log) {
        log.error("TSConfigWriter called");
//  ignore     OutputStream fstream = BootstrapResourceUtils.getBootstrapResource("teststandconfig.spec");
        log.error("Resource directory path = " + BootstrapResourceUtils.getTopUserResourceDirectory());
        String fullpath = BootstrapResourceUtils.getTopUserResourceDirectory() + configFile;
        log.error("Full config file path is: " + fullpath);

        FileWriter fstream = null;
        File cfgFl = new File(configFile);
//        if (cfgFl.exists()) {
        try {
            if (cfgFl.exists()) {
                cfgFl.delete();
            }
            cfgFl.createNewFile();
            try {
                fstream = new FileWriter(cfgFl);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (fstream != null) {
                log.error("writing config file");
//            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(fstream));
                BufferedWriter out = new BufferedWriter(fstream);

                String line = null;
                //NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
                //DecimalFormat formatter = (DecimalFormat)nf;
                //NumberFormat formatter = new DecimalFormat("###.00");

//                operating_states wstate;
                for (operating_states wstate : operating_states.values()) {
                    int icfg = wstate.ordinal();
                    line = "state " + wstate.name() + "\n"
                            + "bias " + biasVAcq[icfg] + "\n"
                            + "cryo " + cryoTAcq[icfg] + "\n"
                            + "vac " + vacPAcq[icfg] + "\n"
                            + "lambda " + lambdaAcq[icfg] + "\n"
                            + "minlmppwr " + minLmpPwr[icfg] + "\n"
                            + "cryotol " + cryoTAcqTol[icfg] + "\n";

                    try {
                        out.write(line);
                        out.newLine();
                        out.flush();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    /*
                     try {
                     fstream.close();
                     } catch (IOException e) {
                     e.printStackTrace();
                     }
                     */
                }
                line = "filters "
                        + filter_names[0] + ":"
                        + filter_names[1] + ":"
                        + filter_names[2] + ":"
                        + filter_names[3] + ":"
                        + filter_names[4] + ":"
                        + filter_names[5] + "\n"
                        + "srctype " + srctype + "\n"
                        + "monotype " + monotype + "\n"
                        + "pdtype " + pdtype + "\n"
                        + "biastype " + biastype + "\n";
                try {
                    out.write(line);
                    out.flush();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    out.close();
                } catch (IOException e) {
                    log.error("Failed to close config file!");
                }

            }
        } catch (IOException ee) {
            log.error("Failed to remove and create a new cfg file.!");
        }

    }

    public void TSConfigReader_deprecated(Logger log) {
        log.error("TSConfigReader called");

//             log.error("reading config file");
//        File cfgFl = new File(configFile);
//        if (cfgFl.exists()) {
        InputStream fstream = BootstrapResourceUtils.getBootstrapResource(configFile);
        if (fstream != null) {

            String line = null;

            try {
//                BufferedReader in = new BufferedReader(new FileReader(cfgFl));
                BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
                int istate = 0; // state for which to apply the setting 
                while (in.ready()) {
                    line = in.readLine();

                    switch (line.split(" ")[0]) {
                        case "state":
                            istate = operating_states.valueOf(line.split(" ")[1]).ordinal();
                            break;
                        case "bias":
                            biasVAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + operating_states.values()[istate] + "): default acquisition bias setting is " + biasVAcq[istate]);
                            break;
                        case "cryo":
                            cryoTAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + operating_states.values()[istate] + "): default acquisition temperature setting is " + cryoTAcq[istate]);
                            break;
                        case "vac":
                            vacPAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + operating_states.values()[istate] + "): default acquisition vacuum setting is " + vacPAcq[istate]);
                            break;
                        case "lambda":
                            lambdaAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + operating_states.values()[istate] + "): default acquisition lambda setting is " + lambdaAcq[istate]);
                            break;
                        case "filters":
                            filter_names = line.substring(line.indexOf(" ")).split(":");
                            break;
                        case "filteredges":
                            String[] fedgstr = line.substring(line.indexOf(" ")).split(":");
                            for (int i = 0; i < fedgstr.length; i++) {
                                filter_edges[i] = Double.valueOf(fedgstr[i]);
                            }
                            break;
                        case "srctype":
                            srctype = line.split(" ")[1];
                            break;
                        case "monotype":
                            monotype = line.split(" ")[1];
                            break;
                        case "pdtype":
                            pdtype = line.split(" ")[1];
                            break;
                        case "biastype":
                            biastype = line.split(" ")[1];
                            break;
                        case "minlmpcurr":
                            minLmpPwr[istate] = Double.valueOf(line.split(" ")[1]);
                            break;
                        case "minlmppwr":
                            minLmpPwr[istate] = Double.valueOf(line.split(" ")[1]);
                            break;
                        case "cryotol":
                            cryoTAcqTol[istate] = Double.valueOf(line.split(" ")[1]);
                            break;
                        default:
                            System.out.println("Ignored entry: line = " + line);
                            break;
                    }
                }
                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
