package org.lsst.ccs.subsystem.teststand.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 * Raft level Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum TS7Alerts {

    /**
     * Alert raised when the cryo plate temperature is too high.
     */
    CRYO_PLATE_TEMPERATURE_TOO_HIGH("CryoPlateHighTemp","Alert for Cryo plate temperture too high"),
    /**
     * Alert raised when the cryo plate temperature is too low.
     */
    CRYO_PLATE_TEMPERATURE_TOO_LOW("CryoPlateLowTemp","Alert for Cryo plate temperture too low"),
    /**
     * Alert raised when the cold plate temperature is too high.
     */
    COLD_PLATE_TEMPERATURE_TOO_HIGH("ColdPlateHighTemp","Alert for Cold plate temperture too high"),
    /**
     * Alert raised when the cold plate temperature is too low.
     */
    COLD_PLATE_TEMPERATURE_TOO_LOW("ColdPlateLowTemp","Alert for Cold plate temperture too low"),
    /**
     * Alert raised when the pressure is too low.
     */
    PRESSURE_TOO_LOW("PressureLow","Alert raised when the pressure too low"),
    /**
     * Alert raised when the pressure is too high.
     */
    PRESSURE_TOO_HIGH("PressureHigh","Alert raised when the pressure too high"),
    /**
     * Alert raised when the vacuum valve is shut off.
     */
    VACUUM_VALVE_SHUT_OFF("VacuumValveShutOff","Alert raised when the vacuum valve is shut off"),
    /**
     * Alert raised when UPS goes onto battery.
     */
    UPS_ON_BATTERY("UPSOnBattery", "Alert raised when UPS goes onto battery"),
    /**
     * Alert raised when UPS becomes disconnected
     */
    UPS_DISCONNECTED("UPSDisconnected", "Alert raised when UPS becomes disconnected"),
    /**
     * Generic Alert.
     */
    GENERIC("GenericAlert","Generic Alert");
    
    
    private final String id, description;
    
    TS7Alerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return getAlert(null);
    }
    
    //Is this needed?
    private Alert getAlert(String prefix) {
        String aId = null;
        if ( prefix != null && ! prefix.isEmpty() ) {
            aId = prefix+"/"+id;
        } else {
            aId = id;
        }
        return new Alert(aId,description);
    }
    
}
