/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator.motor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;
import org.lsst.ccs.subsystems.shutter.simulator.motor.BladeSetSimulator;
import org.lsst.ccs.subsystems.shutter.simulator.motor.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;

public class ShutterSimulator {
    static final double MAXCLOSETIME = 2.0;
    private EventListenerList listeners = new EventListenerList();
    private List<BladeSetSimulator> bladeSetSimulators = new ArrayList<BladeSetSimulator>();

    public ShutterSimulator() {
        this.bladeSetSimulators.add(new BladeSetSimulator());
        this.bladeSetSimulators.get(0).setIndex(0);
        this.bladeSetSimulators.add(new BladeSetSimulator());
        this.bladeSetSimulators.get(1).setIndex(1);
    }

    public void start() {
        int i = 0;
        while (i <= 1) {
            this.addEncoderSimulatorListener(i, new EncoderSimulatorListener(){

                @Override
                public void encoderSimulatorReady(List<MotorPosition> h) {
                }
            });
            this.addHallSensorListener(i, new HallSensorListener(){

                @Override
                public void hallSensorTransition(HallTransitionImpl h) {
                }
            });
            ++i;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    public void addEncoderSimulatorListener(int index, EncoderSimulatorListener l) {
        this.bladeSetSimulators.get(index).addEncoderSimulatorListener(l);
    }

    public void removeEncoderSimulatorListener(int index, EncoderSimulatorListener l) {
        this.bladeSetSimulators.get(index).removeEncoderSimulatorListener(l);
    }

    public void addHallSensorListener(int index, HallSensorListener l) {
        this.bladeSetSimulators.get(index).addHallSensorListener(l);
    }

    public void removeHallSensorListener(int index, HallSensorListener l) {
        this.bladeSetSimulators.get(index).removeHallSensorListener(l);
    }

    public void moveToPosition(int index, float targetPosition, float moveTimeSeconds, boolean initialize) {
        double safeTargetPosition;
        boolean retractBladeSet;
        final BladeSetSimulator bladeSetSimulator = this.bladeSetSimulators.get(index);
        double currentPosition = bladeSetSimulator.getBladeSetPosition();
        boolean bl = retractBladeSet = (double)targetPosition < currentPosition;
        if (!retractBladeSet && initialize && (double)targetPosition > (safeTargetPosition = 1.0 - this.bladeSetSimulators.get(1 - index).getBladeSetPosition())) {
            System.out.println("********* Unsafe operation, end position modified ******* ");
            targetPosition = (float)safeTargetPosition;
            System.out.println("UI: currentPosition " + currentPosition + "targetPosition  " + targetPosition);
        }
        bladeSetSimulator.addEncoderSimulatorListener(new EncoderSimulatorListener(){

            @Override
            public void encoderSimulatorReady(List<MotorPosition> h) {
                bladeSetSimulator.removeEncoderSimulatorListener(this);
            }
        });
        bladeSetSimulator.addHallSensorListener(new HallSensorListener(){

            @Override
            public void hallSensorTransition(HallTransitionImpl h) {
                bladeSetSimulator.removeHallSensorListener(this);
            }
        });
        bladeSetSimulator.moveToPosition(targetPosition, moveTimeSeconds);
    }

    public void takeImage(int firstBladeSetIndex, final float moveTimeSeconds, float exposureTimeSeconds) {
        int exposureTime = (int)(1000.0f * exposureTimeSeconds);
        final int secondBladeSetIndex = 1 - firstBladeSetIndex;
        Timer timer1 = new Timer(exposureTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShutterSimulator.this.moveToPosition(secondBladeSetIndex, 1.0f, moveTimeSeconds, false);
            }
        });
        timer1.setRepeats(false);
        timer1.start();
        this.moveToPosition(firstBladeSetIndex, 0.0f, moveTimeSeconds, true);
    }

    public void takeImage(float moveTimeSeconds, float exposureTimeSeconds) {
        double position0 = this.bladeSetSimulators.get(0).getBladeSetPosition();
        double position1 = this.bladeSetSimulators.get(1).getBladeSetPosition();
        if (position0 == 0.0 && position1 == 1.0 || position0 == 1.0 && position1 == 0.0) {
            int firstBladeSetIndex = position0 < position1 ? 1 : 0;
            this.takeImage(firstBladeSetIndex, moveTimeSeconds, exposureTimeSeconds);
        } else {
            System.out.println("ShutterSimulator: reset positions***** ");
        }
    }

    public void closeShutter() {
        double position0 = this.bladeSetSimulators.get(0).getBladeSetPosition();
        double position1 = this.bladeSetSimulators.get(1).getBladeSetPosition();
        if (position0 == 0.0 && position1 == 1.0 || position0 == 1.0 && position1 == 0.0) {
            System.out.println("Shutter already closed ***** ");
        } else {
            int firstBladeSetIndex = position0 < position1 ? 0 : 1;
            final int secondBladeSetIndex = 1 - firstBladeSetIndex;
            if (position0 == 0.0 || position1 == 0.0) {
                this.moveToPosition(secondBladeSetIndex, 1.0f, 2.0f, true);
            } else {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ShutterSimulator.this.moveToPosition(secondBladeSetIndex, 1.0f, 2.0f, false);
                    }
                });
                t.start();
                this.moveToPosition(firstBladeSetIndex, 0.0f, 2.0f, true);
            }
        }
    }
}

