/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator.motor;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;
import org.lsst.ccs.subsystems.shutter.simulator.motor.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;

public class HallSensorSimulator {
    private ArrayList<HallSensorListener> hallListeners = new ArrayList();
    private final MotorSimulator simulator;
    private long transitionTime;
    private MotorPosition prevMotorPosition = null;
    private int transitionID;
    private boolean retracting = false;
    private SensorData sd;
    private double apperture = 800.0;
    private List<SensorData> sensorData = new ArrayList<SensorData>();

    public HallSensorSimulator(final MotorSimulator simulator) {
        System.out.println("HallSensorSimulator STARTED ************** ");
        this.simulator = simulator;
        double currentPosition = simulator.getInitialMotorPosition();
        System.out.println("HallSensorSimulator:  currentPosition = " + currentPosition);
        this.buildSensorData();
        this.transitionID = 0;
        while (this.transitionID < this.sensorData.size()) {
            if (currentPosition < this.sensorData.get(this.transitionID).getBladePosition()) break;
            ++this.transitionID;
        }
        if (this.transitionID == this.sensorData.size()) {
            --this.transitionID;
        }
        simulator.addMotorListener(new MotorListener(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void positionChanged(MotorPosition p) {
                block5: {
                    block6: {
                        if (HallSensorSimulator.access$0(HallSensorSimulator.this) == HallSensorSimulator.access$1(HallSensorSimulator.this).size() || HallSensorSimulator.access$0(HallSensorSimulator.this) < 0) {
                            return;
                        }
                        HallSensorSimulator.access$2(HallSensorSimulator.this, (SensorData)HallSensorSimulator.access$1(HallSensorSimulator.this).get(HallSensorSimulator.access$0(HallSensorSimulator.this)));
                        if (HallSensorSimulator.access$3(HallSensorSimulator.this) != null) ** GOTO lbl21
                        HallSensorSimulator.access$4(HallSensorSimulator.this, simulator.isRetracting());
                        if (!(HallSensorSimulator.access$5(HallSensorSimulator.this) ^ p.getPosition() > HallSensorSimulator.access$6(HallSensorSimulator.this).getBladePosition())) break block5;
                        HallSensorSimulator.access$7(HallSensorSimulator.this, HallSensorSimulator.access$5(HallSensorSimulator.this) != false ? HallSensorSimulator.access$0(HallSensorSimulator.this) - 1 : HallSensorSimulator.access$0(HallSensorSimulator.this) + 1);
                        if (HallSensorSimulator.access$0(HallSensorSimulator.this) >= 0) break block6;
                        HallSensorSimulator.access$7(HallSensorSimulator.this, 0);
                        break block5;
                    }
                    if (HallSensorSimulator.access$0(HallSensorSimulator.this) != HallSensorSimulator.access$1(HallSensorSimulator.this).size()) break block5;
                    v0 = HallSensorSimulator.this;
                    HallSensorSimulator.access$7(v0, HallSensorSimulator.access$0(v0) - 1);
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        HallSensorSimulator.access$8(HallSensorSimulator.this, HallSensorSimulator.this.getTransitionTime(p, HallSensorSimulator.access$6(HallSensorSimulator.this)));
                        HallSensorSimulator.access$11(HallSensorSimulator.this, new HallTransitionImpl(HallSensorSimulator.access$9(HallSensorSimulator.this), HallSensorSimulator.access$6(HallSensorSimulator.this).getSensorID(), HallSensorSimulator.access$5(HallSensorSimulator.this) ? !HallSensorSimulator.access$6(HallSensorSimulator.this).isOpen() : HallSensorSimulator.access$6(HallSensorSimulator.this).isOpen(), HallSensorSimulator.access$5(HallSensorSimulator.this), (float)HallSensorSimulator.access$6(HallSensorSimulator.this).getBladePosition(), (float)(HallSensorSimulator.access$6(HallSensorSimulator.this).getBladePosition() * HallSensorSimulator.access$10(HallSensorSimulator.this))));
                        HallSensorSimulator.access$7(HallSensorSimulator.this, HallSensorSimulator.access$5(HallSensorSimulator.this) != false ? HallSensorSimulator.access$0(HallSensorSimulator.this) - 1 : HallSensorSimulator.access$0(HallSensorSimulator.this) + 1);
                        if (HallSensorSimulator.access$0(HallSensorSimulator.this) == HallSensorSimulator.access$1(HallSensorSimulator.this).size() || HallSensorSimulator.access$0(HallSensorSimulator.this) < 0) break;
                        HallSensorSimulator.access$2(HallSensorSimulator.this, (SensorData)HallSensorSimulator.access$1(HallSensorSimulator.this).get(HallSensorSimulator.access$0(HallSensorSimulator.this)));
lbl21:
                        // 2 sources

                        ** while (HallSensorSimulator.access$5((HallSensorSimulator)HallSensorSimulator.this) ^ p.getPosition() > HallSensorSimulator.access$6((HallSensorSimulator)HallSensorSimulator.this).getBladePosition())
                    }
                }
                HallSensorSimulator.access$12(HallSensorSimulator.this, p);
            }

            @Override
            public void motorStopped() {
                HallSensorSimulator.this.prevMotorPosition = null;
                if (HallSensorSimulator.this.transitionID < 0) {
                    HallSensorSimulator.this.transitionID = 0;
                } else if (HallSensorSimulator.this.transitionID == HallSensorSimulator.this.sensorData.size()) {
                    HallSensorSimulator hallSensorSimulator = HallSensorSimulator.this;
                    hallSensorSimulator.transitionID = hallSensorSimulator.transitionID - 1;
                }
            }
        });
    }

    public MotorSimulator getMotorSimulator() {
        return this.simulator;
    }

    public void addHallSensorListener(HallSensorListener l) {
        this.hallListeners.add(l);
    }

    public void removeHallSensorListener(HallSensorListener l) {
        this.hallListeners.remove(l);
    }

    private void fireHallTransition(HallTransitionImpl h) {
        for (HallSensorListener l : new ArrayList<HallSensorListener>(this.hallListeners)) {
            l.hallSensorTransition(h);
        }
    }

    public void buildSensorData() {
        System.out.println("HallSensorSimulator building sensor data ************** ");
        boolean open = false;
        double offset = 10.0 / this.apperture;
        double transitionWidth = 5.0 / this.apperture;
        int nMagnet = 9;
        int nSensor = 4;
        int nTransition = nMagnet * nSensor;
        double transitionSpacing = (1.0 - 2.0 * offset - transitionWidth) / (double)(nTransition - 1);
        double bladePosition = offset;
        int id = 1;
        while (id <= nSensor) {
            int n = 1;
            while (n <= nMagnet) {
                this.sensorData.add(new SensorData(bladePosition, id, open));
                System.out.println("BuildSensorData: position " + bladePosition + " id " + id + " open " + open);
                this.sensorData.add(new SensorData(bladePosition + transitionWidth, id, !open));
                System.out.println("BuildSensorData: position " + (bladePosition + transitionWidth) + " id " + id + " open " + !open);
                bladePosition += transitionSpacing;
                ++n;
            }
            ++id;
        }
    }

    long getTransitionTime(MotorPosition p, SensorData sd) {
        long currentTime = p.getTime();
        long prevTime = this.prevMotorPosition.getTime();
        double prevPosition = this.prevMotorPosition.getPosition();
        double currentPosition = p.getPosition();
        double transitionPosition = sd.getBladePosition();
        return prevTime + (long)((double)(currentTime - prevTime) * (transitionPosition - prevPosition) / (currentPosition - prevPosition));
    }

    static /* synthetic */ void access$2(HallSensorSimulator hallSensorSimulator, SensorData sensorData) {
        hallSensorSimulator.sd = sensorData;
    }

    static /* synthetic */ MotorPosition access$3(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.prevMotorPosition;
    }

    static /* synthetic */ void access$4(HallSensorSimulator hallSensorSimulator, boolean bl) {
        hallSensorSimulator.retracting = bl;
    }

    static /* synthetic */ boolean access$5(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.retracting;
    }

    static /* synthetic */ SensorData access$6(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.sd;
    }

    static /* synthetic */ void access$8(HallSensorSimulator hallSensorSimulator, long l) {
        hallSensorSimulator.transitionTime = l;
    }

    static /* synthetic */ long access$9(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.transitionTime;
    }

    static /* synthetic */ double access$10(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.apperture;
    }

    static /* synthetic */ void access$11(HallSensorSimulator hallSensorSimulator, HallTransitionImpl hallTransitionImpl) {
        hallSensorSimulator.fireHallTransition(hallTransitionImpl);
    }

    private static class SensorData {
        double bladePosition;
        int sensorID;
        boolean open;

        public SensorData(double bladePosition, int sensorID, boolean open) {
            this.bladePosition = bladePosition;
            this.sensorID = sensorID;
            this.open = open;
        }

        public double getBladePosition() {
            return this.bladePosition;
        }

        public int getSensorID() {
            return this.sensorID;
        }

        public boolean isOpen() {
            return this.open;
        }
    }
}

