/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.shutter.common.MotorHistory;
import org.lsst.ccs.subsystems.shutter.common.MotorStatus;
import org.lsst.ccs.subsystems.shutter.status.DriverStatus;

public class ShutterSimulator
extends Module {
    private boolean exposureActive = false;
    private List<MotorHistory> histories = new ArrayList<MotorHistory>();
    private EventListenerList listeners = new EventListenerList();
    private boolean firstShutterInOpenPosition = true;

    public ShutterSimulator() {
        this.histories.add(new MotorHistory());
        this.histories.add(new MotorHistory());
    }

    public List<MotorHistory> getHistories() {
        return this.histories;
    }

    public boolean isExposureActive() {
        return this.exposureActive;
    }

    boolean getIsFirstShutterInOpenPosition() {
        return this.firstShutterInOpenPosition;
    }

    void setIsFirstShutterInOpenPosition(boolean isOpen) {
        this.firstShutterInOpenPosition = isOpen;
    }

    public void takeImage(final double exposureTimeSeconds, final double openTimeSeconds) {
        this.sendToStatus(new DriverStatus(exposureTimeSeconds, openTimeSeconds, this.firstShutterInOpenPosition));
        final long start = System.currentTimeMillis();
        int openTime = (int)(1000.0 * openTimeSeconds);
        int exposureTime = (int)(1000.0 * exposureTimeSeconds);
        for (MotorHistory history : this.histories) {
            history.reset();
        }
        final MotorController motor1 = new MotorController(this, openTime, "motor1");
        final MotorController motor2 = new MotorController(this, openTime, "motor2");
        boolean firstShutterInitiallyOpen = this.getIsFirstShutterInOpenPosition();
        MotorController firstMotor = firstShutterInitiallyOpen ? motor2 : motor1;
        final MotorController secondMotor = firstShutterInitiallyOpen ? motor1 : motor2;
        firstMotor.setRunInReverse(true);
        this.setIsFirstShutterInOpenPosition(!firstShutterInitiallyOpen);
        this.exposureActive = true;
        Timer timer1 = new Timer(exposureTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                secondMotor.start();
            }
        });
        timer1.setRepeats(false);
        Timer timer2 = new Timer(exposureTime + openTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShutterSimulator.this.exposureActive = false;
            }
        });
        timer2.setRepeats(false);
        Timer timer3 = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double t = (double)(System.currentTimeMillis() - start) / 1000.0;
                ((MotorHistory)ShutterSimulator.this.histories.get(0)).addData(t, motor1.getAcceleration(), motor1.getVelocity(), motor1.getPosition());
                ((MotorHistory)ShutterSimulator.this.histories.get(1)).addData(t, motor2.getAcceleration(), motor2.getVelocity(), motor2.getPosition());
                if (t > openTimeSeconds + exposureTimeSeconds) {
                    ((Timer)e.getSource()).stop();
                }
            }
        });
        timer1.start();
        timer2.start();
        timer3.start();
        firstMotor.start();
        while (timer1.isRunning() || timer2.isRunning() || timer3.isRunning()) {
        }
    }

    public void postMovementToStatusBus(String motorName) {
        int index = 0;
        if (motorName.contains("2")) {
            index = 1;
        }
        this.sendToStatus(new MotorStatus("motor" + index, this.histories.get(index)));
    }

    private static class MotorController {
        private long openTime;
        private long start;
        private long end;
        private Timer timer;
        private double xPrev;
        private double velocity;
        private double position;
        private double acceleration;
        private boolean reverse;
        private EventListenerList listeners = new EventListenerList();
        private String motorName;
        private ShutterSimulator simulator;

        MotorController(ShutterSimulator simulator, long openTime, String motorName) {
            this.openTime = openTime;
            this.motorName = motorName;
            this.simulator = simulator;
        }

        private void setRunInReverse(boolean reverse) {
            this.reverse = reverse;
            this.position = reverse ? 1 : 0;
        }

        void start() {
            this.start = System.currentTimeMillis();
            this.end = this.start + this.openTime;
            this.timer = new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long now = System.currentTimeMillis();
                    if (now > MotorController.this.end) {
                        MotorController.this.position = !MotorController.this.reverse ? 1 : 0;
                        MotorController.this.velocity = 0.0;
                        MotorController.this.acceleration = 0.0;
                        MotorController.this.timer.stop();
                        MotorController.this.simulator.postMovementToStatusBus(MotorController.this.motorName);
                    } else {
                        double x = (double)(now - MotorController.this.start) / (double)MotorController.this.openTime;
                        MotorController.this.acceleration = MotorController.calculateAcceleration(x);
                        double delta = x - MotorController.this.xPrev;
                        MotorController.this.xPrev = x;
                        MotorController motorController = MotorController.this;
                        motorController.velocity = motorController.velocity + 4.0 * MotorController.this.acceleration * delta;
                        MotorController motorController2 = MotorController.this;
                        motorController2.position = motorController2.position + (double)((MotorController.this.reverse ? -1 : 1) * 2) * MotorController.this.velocity * delta;
                    }
                }
            });
            this.timer.start();
        }

        private static double calculateAcceleration(double phase) {
            if (phase < 0.25) {
                return phase * 4.0;
            }
            if (phase < 0.75) {
                return 1.0 - (phase - 0.25) * 4.0;
            }
            return phase * 4.0 - 4.0;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public double getPosition() {
            return this.position;
        }

        public double getVelocity() {
            return this.velocity;
        }
    }
}

