/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lsst.ccs.subsystems.shutter.common.BladePositionImpl;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;
import org.lsst.ccs.subsystems.shutter.interfaces.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;

public class MotorEncoderSimulator {
    private List<BladePosition> history = new ArrayList<BladePosition>();
    private List<EncoderSimulatorListener> listeners = new ArrayList<EncoderSimulatorListener>();
    private final MotorSimulator simulator;
    private long nextPublishTime = 0L;
    private static long SAMPLINGINTERVAL = 100L;
    private boolean stopped = false;

    public MotorEncoderSimulator(MotorSimulator simulator) {
        System.out.println("MotorEncoderSimulator STARTED ************** ");
        this.simulator = simulator;
        simulator.addMotorListener(new MotorListener(){
            final Random random = new Random();

            @Override
            public void positionChanged(MotorPosition p) {
                if (MotorEncoderSimulator.this.stopped) {
                    MotorEncoderSimulator.this.history.clear();
                    MotorEncoderSimulator.this.stopped = false;
                }
                if (p.getTime() > MotorEncoderSimulator.this.nextPublishTime) {
                    System.out.println("&&&&&&&& MotorEncoderSimulator: Time " + p.getTime() + " position " + p.getPosition());
                    MotorEncoderSimulator.this.smearAndAdd(p, this.random);
                    MotorEncoderSimulator.this.nextPublishTime = p.getTime() + SAMPLINGINTERVAL;
                }
            }

            @Override
            public void motorStopped() {
                MotorEncoderSimulator.this.fireEncoderSimulatorReadyEvent();
                MotorEncoderSimulator.this.stopped = true;
                MotorEncoderSimulator.this.nextPublishTime = 0L;
            }
        });
    }

    private void smearAndAdd(MotorPosition p, Random random) {
        double delta = random.nextGaussian() * 0.02;
        double position = p.getPosition() + delta;
        BladePositionImpl bladePosition = new BladePositionImpl();
        bladePosition.setRelPosition((float)position);
        bladePosition.setTime(p.getTime());
        this.history.add(bladePosition);
    }

    public MotorSimulator getMotorSimulator() {
        return this.simulator;
    }

    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.listeners.add(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.listeners.remove(l);
    }

    private void fireEncoderSimulatorReadyEvent() {
        for (EncoderSimulatorListener l : new ArrayList<EncoderSimulatorListener>(this.listeners)) {
            l.encoderSimulatorReady(this.history);
        }
    }
}

