/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;
import org.lsst.ccs.subsystems.shutter.interfaces.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.interfaces.HallTransition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;

public class HallSensorSimulator {
    private List<HallTransition> history = new ArrayList<HallTransition>();
    private ArrayList<HallSensorListener> hallListeners = new ArrayList();
    private final MotorSimulator simulator;
    private long transitionTime;
    private MotorPosition prevMotorPosition = null;
    private int transitionID;
    private boolean retracting = false;
    private SensorData sd;
    private double apperture = 800.0;
    private List<SensorData> sensorData = new ArrayList<SensorData>();
    private boolean stopped = false;

    public HallSensorSimulator(final MotorSimulator simulator) {
        System.out.println("HallSensorSimulator STARTED ************** ");
        this.simulator = simulator;
        double currentPosition = simulator.getInitialMotorPosition();
        System.out.println("HallSensorSimulator:  currentPosition = " + currentPosition);
        this.buildSensorData();
        this.transitionID = 0;
        while (this.transitionID < this.sensorData.size()) {
            if (currentPosition < this.sensorData.get(this.transitionID).getBladePosition()) break;
            ++this.transitionID;
        }
        if (this.transitionID == this.sensorData.size()) {
            --this.transitionID;
        }
        simulator.addMotorListener(new MotorListener(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void positionChanged(MotorPosition p) {
                block7: {
                    if (HallSensorSimulator.access$0(HallSensorSimulator.this)) {
                        HallSensorSimulator.access$1(HallSensorSimulator.this).clear();
                        HallSensorSimulator.access$2(HallSensorSimulator.this, false);
                    }
                    if (HallSensorSimulator.access$3(HallSensorSimulator.this) == HallSensorSimulator.access$4(HallSensorSimulator.this).size() || HallSensorSimulator.access$3(HallSensorSimulator.this) < 0) {
                        return;
                    }
                    HallSensorSimulator.access$5(HallSensorSimulator.this, (SensorData)HallSensorSimulator.access$4(HallSensorSimulator.this).get(HallSensorSimulator.access$3(HallSensorSimulator.this)));
                    if (HallSensorSimulator.access$6(HallSensorSimulator.this) != null) ** GOTO lbl30
                    HallSensorSimulator.access$7(HallSensorSimulator.this, simulator.isRetracting());
                    if (HallSensorSimulator.access$8(HallSensorSimulator.this) ^ p.getPosition() > HallSensorSimulator.access$9(HallSensorSimulator.this).getBladePosition()) {
                        HallSensorSimulator.access$10(HallSensorSimulator.this, HallSensorSimulator.access$8(HallSensorSimulator.this) != false ? HallSensorSimulator.access$3(HallSensorSimulator.this) - 1 : HallSensorSimulator.access$3(HallSensorSimulator.this) + 1);
                        if (HallSensorSimulator.access$3(HallSensorSimulator.this) < 0) {
                            HallSensorSimulator.access$10(HallSensorSimulator.this, 0);
                        } else if (HallSensorSimulator.access$3(HallSensorSimulator.this) == HallSensorSimulator.access$4(HallSensorSimulator.this).size()) {
                            v0 = HallSensorSimulator.this;
                            HallSensorSimulator.access$10(v0, HallSensorSimulator.access$3(v0) - 1);
                        }
                    }
                    ht = new HallTransitionImpl(p.getTime(), 0, false, HallSensorSimulator.access$8(HallSensorSimulator.this), (float)p.getPosition(), (float)(p.getPosition() * HallSensorSimulator.access$11(HallSensorSimulator.this)));
                    HallSensorSimulator.access$12(HallSensorSimulator.this, ht);
                    HallSensorSimulator.access$1(HallSensorSimulator.this).add(ht);
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        HallSensorSimulator.access$13(HallSensorSimulator.this, HallSensorSimulator.this.getTransitionTime(p, HallSensorSimulator.access$9(HallSensorSimulator.this)));
                        ht = new HallTransitionImpl(HallSensorSimulator.access$14(HallSensorSimulator.this), HallSensorSimulator.access$9(HallSensorSimulator.this).getSensorID(), HallSensorSimulator.access$8(HallSensorSimulator.this) ? !HallSensorSimulator.access$9(HallSensorSimulator.this).isOpen() : HallSensorSimulator.access$9(HallSensorSimulator.this).isOpen(), HallSensorSimulator.access$8(HallSensorSimulator.this), (float)HallSensorSimulator.access$9(HallSensorSimulator.this).getBladePosition(), (float)(HallSensorSimulator.access$9(HallSensorSimulator.this).getBladePosition() * HallSensorSimulator.access$11(HallSensorSimulator.this)));
                        HallSensorSimulator.access$12(HallSensorSimulator.this, ht);
                        HallSensorSimulator.access$1(HallSensorSimulator.this).add(ht);
                        HallSensorSimulator.access$10(HallSensorSimulator.this, HallSensorSimulator.access$8(HallSensorSimulator.this) != false ? HallSensorSimulator.access$3(HallSensorSimulator.this) - 1 : HallSensorSimulator.access$3(HallSensorSimulator.this) + 1);
                        if (HallSensorSimulator.access$3(HallSensorSimulator.this) == HallSensorSimulator.access$4(HallSensorSimulator.this).size() || HallSensorSimulator.access$3(HallSensorSimulator.this) < 0) break;
                        HallSensorSimulator.access$5(HallSensorSimulator.this, (SensorData)HallSensorSimulator.access$4(HallSensorSimulator.this).get(HallSensorSimulator.access$3(HallSensorSimulator.this)));
lbl30:
                        // 2 sources

                        ** while (HallSensorSimulator.access$8((HallSensorSimulator)HallSensorSimulator.this) ^ p.getPosition() > HallSensorSimulator.access$9((HallSensorSimulator)HallSensorSimulator.this).getBladePosition())
                    }
                }
                HallSensorSimulator.access$15(HallSensorSimulator.this, p);
            }

            @Override
            public void motorStopped() {
                HallSensorSimulator.this.fireHallSensorTransitionReady(HallSensorSimulator.this.history);
                HallSensorSimulator.this.stopped = true;
                HallSensorSimulator.this.prevMotorPosition = null;
                if (HallSensorSimulator.this.transitionID < 0) {
                    HallSensorSimulator.this.transitionID = 0;
                } else if (HallSensorSimulator.this.transitionID == HallSensorSimulator.this.sensorData.size()) {
                    HallSensorSimulator hallSensorSimulator = HallSensorSimulator.this;
                    hallSensorSimulator.transitionID = hallSensorSimulator.transitionID - 1;
                }
            }
        });
    }

    public MotorSimulator getMotorSimulator() {
        return this.simulator;
    }

    public void addHallSensorListener(HallSensorListener l) {
        this.hallListeners.add(l);
    }

    public void removeHallSensorListener(HallSensorListener l) {
        this.hallListeners.remove(l);
    }

    private void fireHallTransition(HallTransitionImpl h) {
        for (HallSensorListener l : new ArrayList<HallSensorListener>(this.hallListeners)) {
            l.hallSensorTransition(h);
        }
    }

    private void fireHallSensorTransitionReady(List<HallTransition> history) {
        for (HallSensorListener l : new ArrayList<HallSensorListener>(this.hallListeners)) {
            l.hallSensorDataReady(history);
        }
    }

    public void buildSensorData() {
        System.out.println("HallSensorSimulator building sensor data ************** ");
        boolean open = false;
        double offset = 10.0 / this.apperture;
        double transitionWidth = 5.0 / this.apperture;
        int nMagnet = 9;
        int nSensor = 4;
        int nTransition = nMagnet * nSensor;
        double transitionSpacing = (1.0 - 2.0 * offset - transitionWidth) / (double)(nTransition - 1);
        double bladePosition = offset;
        int id = 1;
        while (id <= nSensor) {
            int n = 1;
            while (n <= nMagnet) {
                this.sensorData.add(new SensorData(bladePosition, id, open));
                System.out.println("BuildSensorData: position " + bladePosition + " id " + id + " open " + open);
                this.sensorData.add(new SensorData(bladePosition + transitionWidth, id, !open));
                System.out.println("BuildSensorData: position " + (bladePosition + transitionWidth) + " id " + id + " open " + !open);
                bladePosition += transitionSpacing;
                ++n;
            }
            ++id;
        }
    }

    long getTransitionTime(MotorPosition p, SensorData sd) {
        long currentTime = p.getTime();
        long prevTime = this.prevMotorPosition.getTime();
        double prevPosition = this.prevMotorPosition.getPosition();
        double currentPosition = p.getPosition();
        double transitionPosition = sd.getBladePosition();
        return prevTime + (long)((double)(currentTime - prevTime) * (transitionPosition - prevPosition) / (currentPosition - prevPosition));
    }

    static /* synthetic */ boolean access$0(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.stopped;
    }

    static /* synthetic */ void access$5(HallSensorSimulator hallSensorSimulator, SensorData sensorData) {
        hallSensorSimulator.sd = sensorData;
    }

    static /* synthetic */ MotorPosition access$6(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.prevMotorPosition;
    }

    static /* synthetic */ void access$7(HallSensorSimulator hallSensorSimulator, boolean bl) {
        hallSensorSimulator.retracting = bl;
    }

    static /* synthetic */ boolean access$8(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.retracting;
    }

    static /* synthetic */ SensorData access$9(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.sd;
    }

    static /* synthetic */ double access$11(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.apperture;
    }

    static /* synthetic */ void access$12(HallSensorSimulator hallSensorSimulator, HallTransitionImpl hallTransitionImpl) {
        hallSensorSimulator.fireHallTransition(hallTransitionImpl);
    }

    static /* synthetic */ void access$13(HallSensorSimulator hallSensorSimulator, long l) {
        hallSensorSimulator.transitionTime = l;
    }

    static /* synthetic */ long access$14(HallSensorSimulator hallSensorSimulator) {
        return hallSensorSimulator.transitionTime;
    }

    private static class SensorData {
        double bladePosition;
        int sensorID;
        boolean open;

        public SensorData(double bladePosition, int sensorID, boolean open) {
            this.bladePosition = bladePosition;
            this.sensorID = sensorID;
            this.open = open;
        }

        public double getBladePosition() {
            return this.bladePosition;
        }

        public int getSensorID() {
            return this.sensorID;
        }

        public boolean isOpen() {
            return this.open;
        }
    }
}

