/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.lsst.ccs.subsystems.shutter.common.MovementHistoryImpl;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSet;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.interfaces.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.interfaces.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.interfaces.HallTransition;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistory;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistoryListener;
import org.lsst.ccs.subsystems.shutter.simulator.HallSensorSimulator;
import org.lsst.ccs.subsystems.shutter.simulator.MotorEncoderSimulator;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;

public class BladeSetSimulator
implements BladeSet {
    private List<MovementHistoryListener> mvhListeners = new ArrayList<MovementHistoryListener>();
    private EventListenerList listeners = new EventListenerList();
    private MotorSimulator motorSimulator = new MotorSimulator();
    private MotorEncoderSimulator encoderSimulator;
    private HallSensorSimulator hallSensorSimulator;
    private MovementHistoryImpl movementHistory;
    private int index;
    private boolean hallSensorDataRecorded = false;
    private boolean encoderDataRecorded = false;

    @Override
    public BladeSetConfiguration getBladeSetConfiguration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getCurrentPosition() {
        return (float)this.motorSimulator.getInitialMotorPosition();
    }

    @Override
    public void setIndex(int index) {
        System.out.println("********* BladeSetSimulator: setting index to " + index);
        this.index = index;
        if (index == 0) {
            this.motorSimulator.setInitialMotorPosition(0.0);
        } else {
            this.motorSimulator.setInitialMotorPosition(1.0);
        }
        this.encoderSimulator = new MotorEncoderSimulator(this.motorSimulator);
        this.hallSensorSimulator = new HallSensorSimulator(this.motorSimulator);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public MovementHistory getMovementHistory() {
        return this.movementHistory;
    }

    public void start() {
    }

    public double getBladeSetPosition() {
        return this.motorSimulator.getInitialMotorPosition();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.encoderSimulator.addEncoderSimulatorListener(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.encoderSimulator.removeEncoderSimulatorListener(l);
    }

    @Override
    public void addHallSensorListener(HallSensorListener l) {
        this.hallSensorSimulator.addHallSensorListener(l);
    }

    @Override
    public void removeHallSensorListener(HallSensorListener l) {
        this.hallSensorSimulator.removeHallSensorListener(l);
    }

    @Override
    public void addMovementHistoryListener(MovementHistoryListener l) {
        this.mvhListeners.add(l);
    }

    @Override
    public void removeMovementHistoryListener(MovementHistoryListener l) {
        this.mvhListeners.remove(l);
    }

    private void fireMovementHistoryFinalized(MovementHistory h) {
        System.out.println("********* BladeSetSimulator: firing fireMovementHistoryFinalized ******* ");
        for (MovementHistoryListener l : new ArrayList<MovementHistoryListener>(this.mvhListeners)) {
            l.movementHistoryFinalized(h);
        }
    }

    private void fireMovementHistoryUpdated(MovementHistory h) {
        System.out.println("********* BladeSetSimulator: firing fireMovementHistoryUpdated ******* ");
        for (MovementHistoryListener l : new ArrayList<MovementHistoryListener>(this.mvhListeners)) {
            l.movementHistoryUpdated(h);
        }
    }

    @Override
    public void moveToPosition(float targetPosition, float moveTimeSeconds) {
        this.movementHistory = new MovementHistoryImpl(this.index, this.getCurrentPosition());
        this.encoderSimulator.addEncoderSimulatorListener(new EncoderSimulatorListener(){

            @Override
            public void encoderSimulatorReady(List<BladePosition> h) {
                BladeSetSimulator.this.movementHistory.setMovementProfile(h);
                BladeSetSimulator.this.movementHistory.setStatus(1);
                BladeSetSimulator.this.movementHistory.setStartTime(h.get(0).getTime());
                BladeSetSimulator.this.movementHistory.setEndPosition(h.get(h.size() - 1).getPosition());
                BladeSetSimulator.this.movementHistory.setEndTime(h.get(h.size() - 1).getTime());
                BladeSetSimulator.this.encoderSimulator.removeEncoderSimulatorListener(this);
                System.out.println("********* BladeSetSimulator: encoderSimulatorReady " + h.size() + " ******* ");
                if (BladeSetSimulator.this.hallSensorDataRecorded) {
                    BladeSetSimulator.this.fireMovementHistoryFinalized(BladeSetSimulator.this.movementHistory);
                    BladeSetSimulator.this.hallSensorDataRecorded = false;
                } else {
                    BladeSetSimulator.this.encoderDataRecorded = true;
                }
            }
        });
        this.hallSensorSimulator.addHallSensorListener(new HallSensorListener(){

            @Override
            public void hallSensorDataReady(List<HallTransition> h) {
                BladeSetSimulator.this.movementHistory.setHallTransitions(h);
                BladeSetSimulator.this.hallSensorSimulator.removeHallSensorListener(this);
                System.out.println("********* BladeSetSimulator: hallSensorDataReady " + h.size() + " ******* ");
                if (BladeSetSimulator.this.encoderDataRecorded) {
                    BladeSetSimulator.this.fireMovementHistoryFinalized(BladeSetSimulator.this.movementHistory);
                    BladeSetSimulator.this.encoderDataRecorded = false;
                } else {
                    BladeSetSimulator.this.hallSensorDataRecorded = true;
                }
            }

            @Override
            public void hallSensorTransition(HallTransition ht) {
                BladeSetSimulator.this.movementHistory.addHallTransition(ht);
                BladeSetSimulator.this.fireMovementHistoryUpdated(BladeSetSimulator.this.movementHistory);
            }
        });
        this.motorSimulator.simulateMovement(targetPosition, moveTimeSeconds);
    }
}

