/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.shutter.gui.ShutterControlPanel;
import org.lsst.ccs.subsystems.shutter.gui.ShutterDisplay;
import org.lsst.ccs.subsystems.shutter.status.CloseShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.HallTransitionStatus;
import org.lsst.ccs.subsystems.shutter.status.MoveBladeSetStatus;
import org.lsst.ccs.subsystems.shutter.status.MovementStatus;
import org.lsst.ccs.subsystems.shutter.status.ReadyForActionStatus;
import org.lsst.ccs.subsystems.shutter.status.TakeImageStatus;

public class ShutterGUISubsystem
extends Subsystem {
    static final String shutter_dest = "ccs-shutter";
    private MessagingFactory mfac;
    ShutterDisplay display = new ShutterDisplay();
    ShutterControlPanel control = new ShutterControlPanel();

    public static void main(String[] args) {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        ShutterGUISubsystem shutterGUI = new ShutterGUISubsystem();
        shutterGUI.initGui();
        JFrame frame = new JFrame("Shutter GUI demo");
        frame.getRootPane().setDoubleBuffered(true);
        frame.getContentPane().add((Component)shutterGUI.getDisplayComponent(), "Center");
        frame.getContentPane().add((Component)shutterGUI.getControlsComponent(), "South");
        frame.setDefaultCloseOperation(3);
        frame.setResizable(true);
        frame.pack();
        frame.setVisible(true);
    }

    public void initGui() {
        this.setUpActionListeners(this.control, this.display);
        this.setName("ShutterGUIModule");
        this.mfac = MessagingFactory.getInstance().forSubsystem(this.getName());
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
    }

    public JComponent getDisplayComponent() {
        return this.display;
    }

    public JComponent getControlsComponent() {
        return this.control;
    }

    public void sendMoveToPosition(int index, float targetPosition, float moveTimeSeconds) {
        Integer arg1 = index;
        Float arg2 = Float.valueOf(targetPosition);
        Float arg3 = Float.valueOf(moveTimeSeconds);
        String command = "moveToPosition";
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, new Object[]{arg1, arg2, arg3});
        cmd.setDestination(shutter_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void sendTakeImage(float moveTimeSeconds, float exposureTimeSeconds) {
        Float arg1 = Float.valueOf(moveTimeSeconds);
        Float arg2 = Float.valueOf(exposureTimeSeconds);
        String command = "takeImage";
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, new Object[]{arg1, arg2});
        cmd.setDestination(shutter_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void sendCloseShutter() {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("closeShutter", new Object[0]);
        cmd.setDestination(shutter_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void onStatus(BusMessage s) {
        if (s instanceof MovementStatus) {
            System.out.println("~_~_~_~_~_~s instanceof MovementStatus_~_~_~_~_~_~_~_");
            this.display.recordMovement((MovementStatus)s);
        } else if (s instanceof HallTransitionStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof HallTransitionStatus~_~_~_~_~_~_~_");
            this.display.recordHallTransition((HallTransitionStatus)s);
        } else if (s instanceof MoveBladeSetStatus) {
            System.out.println("~_~_~_~_~_~_~s instanceof MoveBladeSetStatus_~_~_~_~_~_~_");
            this.control.setEnabled(false);
            this.display.moveToPosition((MoveBladeSetStatus)s);
        } else if (s instanceof TakeImageStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof TakeImageStatus~_~_~_~_~_~_~_");
            this.control.setEnabled(false);
            this.display.takeImage((TakeImageStatus)s);
        } else if (s instanceof ReadyForActionStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof ReadyForActionStatus~_~_~_~_~_~_~_");
            ReadyForActionStatus status = (ReadyForActionStatus)s;
            this.control.setEnabled(status.isReadyForAction());
        } else if (s instanceof CloseShutterStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof CloseShutterStatus~_~_~_~_~_~_~_");
            this.control.setEnabled(false);
            this.display.closeShutter((CloseShutterStatus)s);
        }
    }

    public void setUpActionListeners(final ShutterControlPanel control, final ShutterDisplay display) {
        control.addTakeImageActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ShutterGUI: sending TakeImage command");
                ShutterGUISubsystem.this.sendTakeImage(control.getMovementTime(), control.getExposureTime());
                System.out.println("ShutterGUI: sent TakeImage command");
            }
        });
        control.addMoveToActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ShutterGUI: sending MoveToPosition command");
                ShutterGUISubsystem.this.sendMoveToPosition(control.getBladeSetIndex(), control.getTargetPosition(), control.getMovementTime());
                System.out.println("ShutterGUI: sent MoveToPosition command");
            }
        });
        control.addCloseShutterActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ShutterGUI: sending CloseShutter command");
                ShutterGUISubsystem.this.sendCloseShutter();
                System.out.println("ShutterGUI: sent CloseShutter command");
            }
        });
        display.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                control.setEnabled(!display.isInMotion());
            }
        });
    }
}

