/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.lsst.ccs.subsystems.shutter.gui.HallSensorHistory;
import org.lsst.ccs.subsystems.shutter.gui.MotorHistory;
import org.lsst.ccs.subsystems.shutter.gui.PlotPanelNew;
import org.lsst.ccs.subsystems.shutter.gui.ShutterAssembly;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;
import org.lsst.ccs.subsystems.shutter.interfaces.HallTransition;
import org.lsst.ccs.subsystems.shutter.simulator.EncoderReadOut;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;
import org.lsst.ccs.subsystems.shutter.status.CloseShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.HallTransitionStatus;
import org.lsst.ccs.subsystems.shutter.status.MoveBladeSetStatus;
import org.lsst.ccs.subsystems.shutter.status.MovementStatus;
import org.lsst.ccs.subsystems.shutter.status.TakeImageStatus;

public class ShutterDisplay
extends JPanel {
    private final ShutterAssembly assembly;
    private PlotPanelNew plotPanel;
    private List<MotorHistory> motorHistories = new ArrayList<MotorHistory>();
    private List<HallSensorHistory> hallSensorHistories = new ArrayList<HallSensorHistory>();
    private List<EncoderReadOut> encoderReadOuts = new ArrayList<EncoderReadOut>();
    private boolean inMotion = false;
    private EventListenerList listeners = new EventListenerList();
    private List<MotorSimulator> simulators = new ArrayList<MotorSimulator>();

    public ShutterDisplay() {
        super(new BorderLayout());
        this.simulators.add(new MotorSimulator());
        this.simulators.add(new MotorSimulator());
        this.assembly = new ShutterAssembly();
        this.motorHistories.add(new MotorHistory());
        this.motorHistories.add(new MotorHistory());
        this.hallSensorHistories.add(new HallSensorHistory());
        this.hallSensorHistories.add(new HallSensorHistory());
        this.encoderReadOuts.add(new EncoderReadOut());
        this.encoderReadOuts.add(new EncoderReadOut());
        this.plotPanel = new PlotPanelNew(this.motorHistories, this.hallSensorHistories, this.encoderReadOuts);
        JSplitPane split = new JSplitPane(1);
        split.add(this.plotPanel);
        split.add(this.assembly);
        this.add((Component)split, "Center");
        this.simulators.get(0).setInitialMotorPosition(this.assembly.getShutter(0).getShutterPosition());
        this.simulators.get(1).setInitialMotorPosition(this.assembly.getShutter(1).getShutterPosition());
    }

    List<MotorHistory> getHistories() {
        return this.motorHistories;
    }

    public boolean isInMotion() {
        return this.inMotion;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    private void fireChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
        int n = changeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener l = changeListenerArray[n2];
            l.stateChanged(e);
            ++n2;
        }
    }

    public void moveToPosition(MoveBladeSetStatus s) {
        this.moveToPosition(s.getIndex(), s.getTargetPosition(), (float)s.getMoveTime(), true, true);
    }

    public void moveToPosition(final int index, float targetPosition, float moveTimeSeconds, boolean initialize, final boolean finalize) {
        float safeTargetPosition;
        boolean retractBladeSet;
        float currentPosition = this.assembly.getShutter(index).getShutterPosition();
        System.out.println("ShutterDisplay: currentPosition " + currentPosition + " targetPosition  " + targetPosition + " moveTimeSeconds " + moveTimeSeconds);
        boolean bl = retractBladeSet = targetPosition < currentPosition;
        if (initialize) {
            this.hallSensorHistories.get(index).setStartPosition(currentPosition);
            int i = 0;
            while (i <= 1) {
                this.motorHistories.get(i).reset();
                this.hallSensorHistories.get(i).reset();
                this.encoderReadOuts.get(i).reset();
                ++i;
            }
        } else {
            this.hallSensorHistories.get(index).setStartTime(this.hallSensorHistories.get(1 - index).getStartTime());
            this.motorHistories.get(index).setStartTime(this.motorHistories.get(1 - index).getStartTime());
        }
        if (!retractBladeSet && initialize && targetPosition > (safeTargetPosition = 1.0f - this.assembly.getShutter(1 - index).getShutterPosition())) {
            System.out.printf("Unsafe operation, end position modified \n", new Object[0]);
            targetPosition = safeTargetPosition;
            System.out.println("UI: currentPosition " + currentPosition + "targetPosition  " + targetPosition);
        }
        final MotorSimulator motor = this.simulators.get(index);
        motor.addMotorListener(new MotorListener(){

            @Override
            public void positionChanged(MotorPosition p) {
                ShutterDisplay.this.assembly.getShutter(index).setShutterPosition((float)p.getPosition());
                ShutterDisplay.this.assembly.repaint();
                ((MotorHistory)ShutterDisplay.this.motorHistories.get(index)).addData(p.getTime(), p.getAcceleration(), p.getVelocity(), p.getPosition());
            }

            @Override
            public void motorStopped() {
                if (finalize) {
                    ShutterDisplay.this.inMotion = false;
                    ShutterDisplay.this.fireChangeListeners();
                }
                motor.removeMotorListener(this);
            }
        });
        this.inMotion = true;
        this.fireChangeListeners();
        motor.simulateMovement(targetPosition, (long)moveTimeSeconds);
    }

    void takeImage(TakeImageStatus s) {
        final float moveTimeSeconds = (float)s.getMoveTime();
        float exposureTimeSeconds = (float)s.getExposureTime();
        int firstMotorIndex = s.getfirstBladeSetIndex();
        this.plotPanel.setTimePeriod(moveTimeSeconds + exposureTimeSeconds);
        int exposureTime = (int)(1000.0f * exposureTimeSeconds);
        final int secondMotorIndex = 1 - firstMotorIndex;
        this.inMotion = true;
        this.fireChangeListeners();
        Timer timer1 = new Timer(exposureTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShutterDisplay.this.moveToPosition(secondMotorIndex, 1.0f, moveTimeSeconds, false, true);
            }
        });
        timer1.setRepeats(false);
        timer1.start();
        this.moveToPosition(firstMotorIndex, 0.0f, moveTimeSeconds, true, false);
    }

    void closeShutter(CloseShutterStatus s) {
        final double moveTimeSeconds = s.getMoveTime();
        int firstBladeSetIndex = s.getfirstBladeSetIndex();
        final int secondBladeSetIndex = 1 - firstBladeSetIndex;
        System.out.println("****** ShutterDisplay closeShutter: moveTimeSeconds " + moveTimeSeconds + " *********");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ShutterDisplay.this.moveToPosition(secondBladeSetIndex, 1.0f, (float)moveTimeSeconds, false, true);
            }
        });
        this.inMotion = true;
        this.fireChangeListeners();
        t.start();
        this.moveToPosition(firstBladeSetIndex, 0.0f, (float)moveTimeSeconds, true, false);
    }

    void recordMovement(MovementStatus s) {
        System.out.println("****** recordMovement*********");
        int index = s.getIndex();
        boolean movementComplete = s.isMovementComplete();
        if (movementComplete) {
            this.recordMotorPositions(index, s.getHistory().getMovementProfile());
            this.recordHallSensorPositions(index, s.getHistory().getHallTransitions());
        }
    }

    void recordHallTransition(HallTransitionStatus s) {
        System.out.println("**********recordHallTransition***********");
        int index = s.getIndex();
        this.recordHallSensorPositions(index, s.getTransition());
    }

    void recordMotorPositions(int motorIndex, List<BladePosition> h) {
        System.out.println("**********recordMotorPositions " + h.size() + " ************");
        int otherMotorIndex = 1 - motorIndex;
        long t0 = this.encoderReadOuts.get(otherMotorIndex).getStartTime() > 0L ? this.encoderReadOuts.get(otherMotorIndex).getStartTime() : h.get(0).getTime();
        this.encoderReadOuts.get(motorIndex).addData(h, t0);
        for (BladePosition p : h) {
            System.out.println("UI : set " + motorIndex + " Time" + p.getTime() + " smeared position " + p.getRelPosition());
        }
    }

    void recordHallSensorPositions(int sensorIndex, HallTransition h) {
        System.out.println("************recordHallSensorPositions************");
        this.hallSensorHistories.get(sensorIndex).addData(h.getTransitionTime(), h.getPosition());
        System.out.println("UI: set " + sensorIndex + " Time " + h.getTransitionTime() + " position " + h.getPosition());
        System.out.println("UI: set " + sensorIndex + " ID " + h.getSensorId() + " State " + h.isOpen() + " retracting " + h.isReverse());
    }

    void recordHallSensorPositions(int sensorIndex, List<HallTransition> hlist) {
        System.out.println("************recordHallSensorPositions " + hlist.size() + " ************");
        for (HallTransition h : hlist) {
            this.hallSensorHistories.get(sensorIndex).addData(h.getTransitionTime(), h.getPosition());
            System.out.println("UI: set " + sensorIndex + " Time " + h.getTransitionTime() + " position " + h.getPosition());
            System.out.println("UI: set " + sensorIndex + " ID " + h.getSensorId() + " State " + h.isOpen() + " retracting " + h.isReverse());
        }
    }
}

