/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.PlotDataListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystems.shutter.gui.HallSensorHistory;
import org.lsst.ccs.subsystems.shutter.gui.MotorHistory;
import org.lsst.ccs.subsystems.shutter.simulator.EncoderReadOut;
import plotter.Axis;
import plotter.AxisModel;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;
import plotter.DataPointChartOverlay;
import plotter.LineChartOverlay;
import plotter.LinearAxisModel;
import plotter.PlotLayout;

public class PlotPanelNew
extends JPanel {
    private final LinearAxisModel yAxisModel;

    PlotPanelNew(List<MotorHistory> motorHistories, List<HallSensorHistory> hallSensorHistories, List<EncoderReadOut> encoderReadOuts) {
        super(new BorderLayout());
        JPanel plotPanel = new JPanel((LayoutManager)new PlotLayout());
        plotPanel.setPreferredSize(new Dimension(500, 300));
        LinearAxisModel xAxisModel = new LinearAxisModel(-1.1, 1.1);
        this.yAxisModel = new LinearAxisModel(0.0, 5.0);
        Axis xAxis = new Axis((AxisModel)xAxisModel, Axis.AxisPosition.LEFT);
        Axis yAxis = new Axis((AxisModel)this.yAxisModel, Axis.AxisPosition.BOTTOM);
        DataArea da = new DataArea(yAxis, xAxis);
        LineChartOverlay acceleration = new LineChartOverlay("Acceleration", (DiscretePlotData)motorHistories.get(0), 0, 1, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        da.add((DataOverlay)acceleration);
        LineChartOverlay velocity = new LineChartOverlay("Velocity", (DiscretePlotData)motorHistories.get(0), 0, 2, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        velocity.setLineColor(Color.BLUE);
        da.add((DataOverlay)velocity);
        LineChartOverlay position = new LineChartOverlay("Position", (DiscretePlotData)motorHistories.get(0), 0, 3, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        position.setLineColor(Color.GREEN);
        da.add((DataOverlay)position);
        DataPointChartOverlay hallSensors = new DataPointChartOverlay("Hall Sensors", (DiscretePlotData)hallSensorHistories.get(0), 0, 1, -1, -1, 2, 2, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        hallSensors.setLineColor(Color.yellow);
        da.add((DataOverlay)hallSensors);
        DataPointChartOverlay readOuts = new DataPointChartOverlay("Encoder Readouts", (DiscretePlotData)encoderReadOuts.get(0), 0, 1, -1, -1, 2, 2, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        readOuts.setLineColor(Color.BLACK);
        da.add((DataOverlay)readOuts);
        KeyPanel keyPanel1 = new KeyPanel("Motor 1");
        keyPanel1.add(acceleration);
        keyPanel1.add(velocity);
        keyPanel1.add(position);
        keyPanel1.add(hallSensors);
        keyPanel1.add(readOuts);
        LineChartOverlay acceleration2 = new LineChartOverlay("Acceleration", (DiscretePlotData)motorHistories.get(1), 0, 1, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        acceleration2.setLineColor(Color.ORANGE);
        da.add((DataOverlay)acceleration2);
        LineChartOverlay velocity2 = new LineChartOverlay("Velocity", (DiscretePlotData)motorHistories.get(1), 0, 2, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        velocity2.setLineColor(Color.CYAN);
        da.add((DataOverlay)velocity2);
        LineChartOverlay position2 = new LineChartOverlay("Position", (DiscretePlotData)motorHistories.get(1), 0, 3, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        position2.setLineColor(Color.MAGENTA);
        da.add((DataOverlay)position2);
        DataPointChartOverlay hallSensors2 = new DataPointChartOverlay("Hall Sensors", (DiscretePlotData)hallSensorHistories.get(1), 0, 1, -1, -1, 2, 2, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        hallSensors2.setLineColor(Color.PINK);
        da.add((DataOverlay)hallSensors2);
        DataPointChartOverlay readOuts2 = new DataPointChartOverlay("Encoder Readouts", (DiscretePlotData)encoderReadOuts.get(1), 0, 1, -1, -1, 2, 2, (ContinuousAxisModel)this.yAxisModel, (ContinuousAxisModel)xAxisModel);
        readOuts2.setLineColor(Color.GRAY);
        da.add((DataOverlay)readOuts2);
        plotPanel.add((Component)xAxis);
        plotPanel.add((Component)yAxis);
        plotPanel.add((Component)da);
        KeyPanel keyPanel2 = new KeyPanel("Motor 2");
        keyPanel2.add(acceleration2);
        keyPanel2.add(velocity2);
        keyPanel2.add(position2);
        keyPanel2.add(hallSensors2);
        keyPanel2.add(readOuts2);
        JPanel key = new JPanel(new BorderLayout());
        key.add("North", keyPanel1);
        key.add("South", keyPanel2);
        key.setBorder(BorderFactory.createTitledBorder("Key"));
        this.add((Component)plotPanel, "Center");
        this.add((Component)key, "South");
        motorHistories.get(0).addPlotDataListener(new PlotDataListener(){

            public void dataChanged() {
                PlotPanelNew.this.repaint();
            }
        });
        motorHistories.get(1).addPlotDataListener(new PlotDataListener(){

            public void dataChanged() {
                PlotPanelNew.this.repaint();
            }
        });
        hallSensorHistories.get(0).addPlotDataListener(new PlotDataListener(){

            public void dataChanged() {
                PlotPanelNew.this.repaint();
            }
        });
        hallSensorHistories.get(1).addPlotDataListener(new PlotDataListener(){

            public void dataChanged() {
                PlotPanelNew.this.repaint();
            }
        });
        encoderReadOuts.get(0).addPlotDataListener(new PlotDataListener(){

            public void dataChanged() {
                PlotPanelNew.this.repaint();
            }
        });
        encoderReadOuts.get(1).addPlotDataListener(new PlotDataListener(){

            public void dataChanged() {
                PlotPanelNew.this.repaint();
            }
        });
    }

    void setTimePeriod(float time) {
        this.yAxisModel.setMax((double)time);
        this.repaint();
    }

    private static class KeyPanel
    extends JPanel {
        KeyPanel(String title) {
            super(new FlowLayout());
            this.add(new JLabel(title));
        }

        private void add(LineChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            this.add(label);
        }

        private void add(DataPointChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            this.add(label);
        }
    }
}

