/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSet;
import org.lsst.ccs.subsystems.shutter.interfaces.HallTransition;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistory;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistoryListener;
import org.lsst.ccs.subsystems.shutter.status.CloseShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.HallTransitionStatus;
import org.lsst.ccs.subsystems.shutter.status.MoveBladeSetStatus;
import org.lsst.ccs.subsystems.shutter.status.MovementStatus;
import org.lsst.ccs.subsystems.shutter.status.ReadyForActionStatus;
import org.lsst.ccs.subsystems.shutter.status.ShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.TakeImageStatus;

public class ShutterModule
extends Module {
    static final double MAXCLOSETIME = 2.0;
    private float moveTimeSeconds = 2.0f;
    private float exposureTimeSeconds = 10.0f;
    private List<BladeSet> bladeSets = null;
    private boolean moveSingleBlade = false;

    public void setBladeSets(List<BladeSet> bladeSets) {
        this.bladeSets = bladeSets;
    }

    public BladeSet getBladeSet(int index) {
        return this.bladeSets.get(index);
    }

    private void logFatalMessageAndThrowException(String msg) {
        Module.log.fatal((Object)msg);
        throw new RuntimeException(msg);
    }

    public void initModule() {
        Module.log.info((Object)"[ShutterModule] Initializing the Shutter module ");
        if (this.bladeSets.size() != 2) {
            this.logFatalMessageAndThrowException("[ShutterModule] The Shutter Module requires two bladeSets when initialized");
        }
        if (this.getBladeSet(0).getIndex() != 0 || this.getBladeSet(1).getIndex() != 1) {
            this.logFatalMessageAndThrowException("[ShutterModule] At least one BladeSet has been registered with the wrong index");
        }
        this.getBladeSetPosition(0);
        this.getBladeSetPosition(1);
    }

    public void tick() {
        try {
            this.notifyStatusOnBus();
        }
        catch (Exception e) {
            Module.log.error((Object)e);
        }
    }

    private void notifyStatusOnBus() {
        try {
            if (this.getContext() != null) {
                this.sendToStatus(new ShutterStatus(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getExposureTimeSeconds() {
        return this.exposureTimeSeconds;
    }

    public void setExposureTimeSeconds(double exposureTimeSeconds) {
        Module.log.info((Object)("[ShutterModule] Setting default exposure time to  " + exposureTimeSeconds + " seconds."));
        this.exposureTimeSeconds = (float)exposureTimeSeconds;
        this.notifyStatusOnBus();
    }

    public double getMoveTimeSeconds() {
        return this.moveTimeSeconds;
    }

    public void setMoveTimeSeconds(float moveTimeSeconds) {
        Module.log.info((Object)("[ShutterModule] Setting default open time to  " + moveTimeSeconds + " seconds."));
        this.moveTimeSeconds = moveTimeSeconds;
        this.notifyStatusOnBus();
    }

    public double getBladeSetPosition(int index) {
        return this.getBladeSet(index).getCurrentPosition();
    }

    public void moveToPosition(final int index, float targetPosition, float moveTimeSeconds, final boolean initialize) {
        double safeTargetPosition;
        boolean retractBladeSet;
        final BladeSet bladeSet = this.bladeSets.get(index);
        double currentPosition = this.getBladeSetPosition(index);
        boolean bl = retractBladeSet = (double)targetPosition < currentPosition;
        if (!retractBladeSet && initialize && (double)targetPosition > (safeTargetPosition = 1.0 - this.getBladeSetPosition(1 - index))) {
            Module.log.info((Object)"[ShutterModule] Unsafe operation, target position modified");
            System.out.println("********* Unsafe operation, target position modified ******* ");
            targetPosition = (float)safeTargetPosition;
            Module.log.info((Object)("[ShutterModule] currentPosition " + currentPosition + "targetPosition  " + targetPosition));
            System.out.println("ShutterModule: currentPosition " + currentPosition + "targetPosition  " + targetPosition);
        }
        bladeSet.addMovementHistoryListener(new MovementHistoryListener(){

            @Override
            public void movementHistoryFinalized(MovementHistory history) {
                System.out.println("ShutterModule: movementHistoryFinalized profile size " + history.getMovementProfile().size());
                System.out.println("ShutterModule: movementHistoryFinalized hall tr size " + history.getHallTransitions().size());
                System.out.println("ShutterModule: movementHistoryFinalized status " + history.getStatus());
                ShutterModule.this.sendToStatus(new MovementStatus(index, true, history));
                if (!initialize || ShutterModule.this.moveSingleBlade) {
                    ShutterModule.this.sendToStatus(new ReadyForActionStatus(true));
                    ShutterModule.this.moveSingleBlade = false;
                }
                bladeSet.removeMovementHistoryListener(this);
            }

            @Override
            public void movementHistoryUpdated(MovementHistory history) {
                System.out.println("ShutterModule: movementHistoryUpdated");
                int lastIndex = history.getHallTransitions().size() - 1;
                HallTransition transition = history.getHallTransitions().get(lastIndex);
                ShutterModule.this.sendToStatus(new HallTransitionStatus(index, transition));
            }
        });
        if (this.moveSingleBlade) {
            this.sendToStatus(new MoveBladeSetStatus(bladeSet, targetPosition, moveTimeSeconds));
        }
        bladeSet.moveToPosition(targetPosition, moveTimeSeconds);
    }

    public void moveToPosition(int index, float targetPosition, float moveTimeSeconds) {
        this.moveSingleBlade = true;
        this.moveToPosition(index, targetPosition, moveTimeSeconds, true);
    }

    public void takeImage() throws InterruptedException, IllegalArgumentException {
        this.takeImage(this.exposureTimeSeconds, this.moveTimeSeconds);
    }

    public void takeExposure(float exposureTimeSeconds) throws InterruptedException, IllegalArgumentException {
        this.takeImage(exposureTimeSeconds, this.moveTimeSeconds);
    }

    public void takeImage(int firstBladeSetIndex, final float moveTimeSeconds, float exposureTimeSeconds) throws InterruptedException, IllegalArgumentException {
        int exposureTime = (int)(1000.0f * exposureTimeSeconds);
        final int secondBladeSetIndex = 1 - firstBladeSetIndex;
        Timer timer1 = new Timer(exposureTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShutterModule.this.moveToPosition(secondBladeSetIndex, 1.0f, moveTimeSeconds, false);
            }
        });
        timer1.setRepeats(false);
        Module.log.info((Object)("[ShutterModule] Move bladeSets in  " + moveTimeSeconds + " seconds."));
        Module.log.info((Object)("[ShutterModule] Taking exposure of " + exposureTimeSeconds + " seconds."));
        this.sendToStatus(new TakeImageStatus(firstBladeSetIndex, moveTimeSeconds, exposureTimeSeconds));
        timer1.start();
        this.moveToPosition(firstBladeSetIndex, 0.0f, moveTimeSeconds, true);
    }

    public void takeImage(float moveTimeSeconds, float exposureTimeSeconds) throws InterruptedException, IllegalArgumentException {
        double position0 = this.getBladeSetPosition(0);
        double position1 = this.getBladeSetPosition(1);
        if (position0 == 0.0 && position1 == 1.0 || position0 == 1.0 && position1 == 0.0) {
            int firstBladeSetIndex = position0 < position1 ? 1 : 0;
            this.takeImage(firstBladeSetIndex, moveTimeSeconds, exposureTimeSeconds);
        } else {
            Module.log.error((Object)"[ShutterModule] Shutter not fully closed.");
            System.out.println("ShutterModule: Shutter not fully closed. ***** ");
        }
    }

    public void closeShutter() throws InterruptedException {
        double position0 = this.getBladeSetPosition(0);
        double position1 = this.getBladeSetPosition(1);
        System.out.println("ShutterModule closeShutter: ***** " + position0 + " " + position1 + " *******");
        if (position0 == 0.0 && position1 == 1.0 || position0 == 1.0 && position1 == 0.0) {
            System.out.println("Shutter already closed ***** ");
            Module.log.info((Object)"Shutter already closed");
        } else {
            int firstBladeSetIndex = position0 < position1 ? 0 : 1;
            final int secondBladeSetIndex = 1 - firstBladeSetIndex;
            Module.log.info((Object)"Closing shutter");
            if (position0 == 0.0 || position1 == 0.0) {
                this.moveToPosition(secondBladeSetIndex, 1.0f, 2.0f);
            } else {
                System.out.println("closeShutter: moveTimeSeconds 2.0 ***** ");
                this.sendToStatus(new CloseShutterStatus(firstBladeSetIndex, 2.0));
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            System.out.println(ie.getMessage());
                        }
                        ShutterModule.this.moveToPosition(secondBladeSetIndex, 1.0f, 2.0f, false);
                    }
                });
                t.start();
                this.moveToPosition(firstBladeSetIndex, 0.0f, 2.0f, true);
            }
        }
    }
}

