package org.lsst.ccs.subsystems.shutter.simulator.motor;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 *
 * @author azemoon
 */
public class MotorEncoderSimulator {

    private List<MotorPosition> history = new ArrayList<MotorPosition>();
    private List<EncoderSimulatorListener> listeners = new ArrayList<EncoderSimulatorListener>();
    private final MotorSimulator simulator;
    private long nextPublishTime = 0;
    private long samplingInterval = 100;

    public MotorEncoderSimulator(MotorSimulator simulator) {
        System.out.println("MotorPositionCollector STARTED ************** ");
        this.simulator = simulator;
        simulator.addMotorListener(new MotorListener() {

            final Random random = new Random();

            @Override
            public void positionChanged(MotorPosition p) {
                if (p.getTime() > nextPublishTime) {
                    //System.out.println("MotorPositionCollector: Time " + p.getTime() + " position " + p.getPosition() );
                    smearAndAdd(p, random);
                    nextPublishTime = p.getTime() + samplingInterval;
                }
            }

            @Override
            public void motorStopped() {
                fireEncoderSimulatorReadyEvent();
                history.clear();
                nextPublishTime = 0;
            }
        });
    }

    private void smearAndAdd(MotorPosition p, Random random) {
        double delta = random.nextGaussian() * 0.02;
        //System.out.println("MotorPositionCollector: position " + p.getPosition() + " delta " + delta );
        double position = (double) p.getPosition() + delta;
        //System.out.println("MotorPositionCollector: Time " + p.getTime() + " position " + position );
        //FIXME: Modifying the position in the existing motor position object, which may be passed
        //to multiple listeners seems very dubious
        p.setPosition((float) position);
        history.add(p);
    }

    public MotorSimulator getMotorSimulator() {
        return this.simulator;
    }

    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        listeners.add(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        listeners.remove(l);
    }

    private void fireEncoderSimulatorReadyEvent() {
        for (EncoderSimulatorListener l : new ArrayList<EncoderSimulatorListener>(listeners)) {
            l.encoderSimulatorReady(history);
        }
    }
}
